/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class MaskingClassLoader
extends ClassLoader {
    private final List<String> masksClasses = new ArrayList<String>();
    private final List<String> masksResources = new ArrayList<String>();

    public MaskingClassLoader(ClassLoader parent, String ... masks) {
        this(parent, Arrays.asList(masks));
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks) {
        super(parent);
        this.masksClasses.addAll(masks);
        for (String mask : masks) {
            this.masksResources.add(mask.replace(".", "/"));
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.isMasked(name)) {
            return null;
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public synchronized URL getResource(String name) {
        if (this.isMasked(name)) {
            return null;
        }
        return super.getResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isMasked(name)) {
            return Collections.emptyEnumeration();
        }
        return super.getResources(name);
    }

    public synchronized void add(String prefix) {
        this.masksClasses.add(prefix);
        if (prefix != null) {
            this.masksResources.add(prefix.replace(".", "/"));
        }
    }

    private boolean isMasked(String name) {
        for (String mask : this.masksResources) {
            if (!name.startsWith(mask)) continue;
            return true;
        }
        return false;
    }
}

