/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import com.qlangtech.tis.plugin.IdentityName;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum EnumFieldMode {
    MULTIPLE("multiple", (dftVal, fieldDesc) -> {
        if (!EnumFieldMode.isValOfOptionList(dftVal, fieldDesc)) {
            throw new IllegalStateException(fieldDesc + " val " + dftVal.getClass() + " must be type of " + List.class.getName());
        }
        return ((List)dftVal).stream().map(val -> val instanceof IdentityName ? ((IdentityName)val).identityValue() : val).collect(Collectors.toList());
    }),
    DEFAULT("default", (dftVal, fieldDesc) -> {
        if (EnumFieldMode.isValOfOptionList(dftVal, fieldDesc)) {
            dftVal = EnumFieldMode.getFirstVal(dftVal);
        }
        if (dftVal != null && !(dftVal instanceof String) && !(dftVal instanceof Boolean)) {
            throw new IllegalStateException(fieldDesc + " ,default val:" + dftVal + "  must be type of String or Boolean ,but now is " + dftVal.getClass());
        }
        return dftVal;
    });

    public final String val;
    private final BiFunction<Object, String, Object> enumDftValProcess;

    public static EnumFieldMode parse(String val) {
        for (EnumFieldMode mode : EnumFieldMode.values()) {
            if (!mode.val.equals(val)) continue;
            return mode;
        }
        return DEFAULT;
    }

    private EnumFieldMode(String val, BiFunction<Object, String, Object> enumDftValProcess) {
        this.val = val;
        this.enumDftValProcess = enumDftValProcess;
    }

    public Function<Object, Object> createDefaultValProcess(Class<?> targetClass, Field formField) {
        String fieldDesc = "default val of owner class:" + targetClass.getName() + " with field:" + formField.getName();
        return dftVal -> {
            if (dftVal == null) {
                throw new IllegalStateException(fieldDesc + " can not be null");
            }
            return this.enumDftValProcess.apply(dftVal, fieldDesc);
        };
    }

    private static boolean isValOfOptionList(Object val, String fieldDesc) {
        Class<?> valClass = val.getClass();
        if (List.class.isAssignableFrom(valClass)) {
            for (Object o : (List)val) {
                if (o.getClass() == String.class || IdentityName.class.isAssignableFrom(o.getClass())) continue;
                throw new IllegalStateException(fieldDesc + ",opt element " + o.getClass() + " must be type of " + String.class.getSimpleName() + " or " + IdentityName.class.getSimpleName());
            }
            return true;
        }
        return false;
    }

    private static Object getFirstVal(Object val) {
        Iterator iterator = ((List)val).iterator();
        if (iterator.hasNext()) {
            Object vv = iterator.next();
            return String.valueOf(vv);
        }
        return null;
    }
}

