/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension.impl;

import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ExtensionComponent;
import com.qlangtech.tis.extension.ExtensionFinder;
import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.extension.Plugin;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginStrategy;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.impl.MaskingClassLoader;
import com.qlangtech.tis.extension.impl.PluginFirstClassLoader;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.extension.util.AntClassLoader;
import com.qlangtech.tis.extension.util.ClassLoaderReflectionToolkit;
import com.qlangtech.tis.extension.util.CyclicGraphDetector;
import com.qlangtech.tis.util.ClassloaderUtils;
import com.qlangtech.tis.util.Util;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicPluginStrategy
implements PluginStrategy {
    public static final List<ExtensionFinder> finders = Collections.singletonList(new ExtensionFinder.Sezpoz());
    private PluginManager pluginManager;
    private final MaskingClassLoader coreClassLoader = new MaskingClassLoader(this.getClass().getClassLoader(), new String[0]);
    private static final Set<String> BREAK_CYCLES = new HashSet<String>(Arrays.asList("script-security/matrix-auth", "script-security/windows-slaves", "script-security/antisamy-markup-formatter", "script-security/matrix-project", "credentials/matrix-auth", "credentials/windows-slaves"));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClassicPluginStrategy.class.getName());

    public static void removeByClassNameInFinders(Class<?> superType) {
        finders.forEach(finder -> finder.removeByType(superType));
    }

    public ClassicPluginStrategy(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    @Override
    public String getShortName(File archive) throws IOException {
        Manifest manifest;
        if (PluginManifest.isLinked(archive)) {
            manifest = PluginManifest.loadLinkedManifest(archive);
        } else {
            try (JarInputStream jf = new JarInputStream((InputStream)FileUtils.openInputStream((File)archive), false);){
                manifest = jf.getManifest();
            }
        }
        Attributes attrs = manifest.getMainAttributes();
        if (attrs == null) {
            throw new IllegalStateException("archive:" + archive.getAbsolutePath() + " relevant mainifest attrs can not be null");
        }
        return PluginManifest.parseShortName(attrs, archive.getName());
    }

    @Override
    public PluginWrapper createPluginWrapper(File archive) throws IOException {
        PluginManifest manifest = PluginManifest.create(this.pluginManager.getWorkDir(), archive);
        File disableFile = new File(archive.getPath() + ".disabled");
        if (disableFile.exists()) {
            LOGGER.info("Plugin " + archive.getName() + " is disabled");
        }
        DependencyMeta dependencyMeta = manifest.getDependencyMeta();
        String masked = manifest.getMasked();
        if (masked != null) {
            for (String pkg : masked.trim().split("[ \t\r\n]+")) {
                this.coreClassLoader.add(pkg);
            }
        }
        ClassLoader dependencyLoader = new DependencyClassLoader(this.coreClassLoader, archive, manifest, Util.join(dependencyMeta.dependencies, dependencyMeta.optionalDependencies));
        dependencyLoader = this.getBaseClassLoader(manifest, dependencyLoader);
        return new PluginWrapper(this.pluginManager, archive, manifest, manifest.baseResourceURL, this.createClassLoader(manifest, dependencyLoader), disableFile, dependencyMeta.dependencies, dependencyMeta.optionalDependencies);
    }

    private static void fix(Attributes atts, List<PluginWrapper.Dependency> optionalDependencies) {
        String pluginName = atts.getValue("Short-Name");
        String jenkinsVersion = atts.getValue("Jenkins-Version");
        if (jenkinsVersion == null) {
            jenkinsVersion = atts.getValue("Hudson-Version");
        }
    }

    protected ClassLoader createClassLoader(PluginManifest manifest, ClassLoader parent) throws IOException {
        List<File> paths = manifest.getLibs();
        if (manifest.getUsePluginFirstClassLoader()) {
            PluginFirstClassLoader classLoader = new PluginFirstClassLoader(manifest.getLongName());
            classLoader.setParentFirst(false);
            classLoader.setParent(parent);
            classLoader.addPathFiles(paths);
            return classLoader;
        }
        AntClassLoader2 classLoader = new AntClassLoader2(parent);
        classLoader.addPathFiles(paths);
        return classLoader;
    }

    private ClassLoader getBaseClassLoader(PluginManifest manifest, ClassLoader base) {
        String masked = manifest.getMaskedClasses();
        if (masked != null) {
            base = new MaskingClassLoader(base, masked.trim().split("[ \t\r\n]+"));
        }
        return base;
    }

    @Override
    public void initializeComponents(PluginWrapper plugin) {
    }

    @Override
    public <T> List<ExtensionComponent<T>> findComponents(Class<T> type, TIS tis) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Scout-loading ExtensionList: " + type);
        }
        for (ExtensionFinder finder : finders) {
            finder.scout(type, tis);
        }
        ArrayList r = Lists.newArrayList();
        for (ExtensionFinder finder : finders) {
            try {
                r.addAll(finder.find(type, tis));
            }
            catch (AbstractMethodError e) {
                for (T t : finder.findExtensions(type, tis)) {
                    r.add(new ExtensionComponent<T>(t));
                }
            }
        }
        return r;
    }

    @Override
    public void load(PluginWrapper wrapper) throws IOException {
        try {
            ClassloaderUtils.processByResetThreadClassloader(wrapper.getClass(), () -> {
                String className = wrapper.getPluginClass();
                if (className == null) {
                    wrapper.setPlugin(new Plugin.DummyImpl());
                } else {
                    try {
                        Class<?> clazz = wrapper.classLoader.loadClass(className);
                        Object o = clazz.newInstance();
                        if (!(o instanceof Plugin)) {
                            throw new IOException(className + " doesn't extend from hudson.Plugin");
                        }
                        wrapper.setPlugin((Plugin)o);
                    }
                    catch (ClassNotFoundException | LinkageError e) {
                        throw new IOException("Unable to load " + className + " from " + wrapper.getShortName(), e);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IOException("Unable to create instance of " + className + " from " + wrapper.getShortName(), e);
                    }
                }
                try {
                    Plugin plugin = wrapper.getPlugin();
                    this.startPlugin(wrapper);
                }
                catch (Throwable t) {
                    throw new IOException("Failed to initialize", t);
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startPlugin(PluginWrapper plugin) throws Exception {
        plugin.getPlugin().start();
    }

    @Override
    public void updateDependency(PluginWrapper depender, PluginWrapper dependee) {
        DependencyClassLoader classLoader = this.findAncestorDependencyClassLoader(depender.classLoader);
        if (classLoader != null) {
            classLoader.updateTransientDependencies();
            LOGGER.info("Updated dependency of {}", (Object)depender.getShortName());
        }
    }

    private DependencyClassLoader findAncestorDependencyClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            DependencyClassLoader ret;
            if (classLoader instanceof DependencyClassLoader) {
                return (DependencyClassLoader)classLoader;
            }
            if (classLoader instanceof AntClassLoader && (ret = this.findAncestorDependencyClassLoader(((AntClassLoader)classLoader).getConfiguredParent())) != null) {
                return ret;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    private final class AntClassLoader2
    extends AntClassLoader
    implements Closeable {
        private final Vector pathComponents;

        private AntClassLoader2(ClassLoader parent) {
            super(parent, true);
            try {
                Field $pathComponents = AntClassLoader.class.getDeclaredField("pathComponents");
                $pathComponents.setAccessible(true);
                this.pathComponents = (Vector)$pathComponents.get(this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Error(e);
            }
        }

        public void addPathFiles(Collection<File> paths) throws IOException {
            for (File f : paths) {
                this.addPathFile(f);
            }
        }

        @Override
        public void close() throws IOException {
            this.cleanup();
        }

        @Override
        protected URL findResource(String name) {
            URL url = null;
            Enumeration e = this.pathComponents.elements();
            while (e.hasMoreElements() && url == null) {
                File pathComponent = (File)e.nextElement();
                url = this.getResourceURL(pathComponent, name);
                if (url == null) continue;
                this.log("Resource " + name + " loaded from ant loader", 4);
            }
            return url;
        }

        @Override
        protected Class defineClassFromData(File container, byte[] classData, String classname) throws IOException {
            return super.defineClassFromData(container, classData, classname);
        }
    }

    final class DependencyClassLoader
    extends ClassLoader {
        private final File _for;
        private List<PluginWrapper.Dependency> dependencies;
        private final PluginManifest manifest;
        private volatile List<PluginWrapper> transientDependencies;

        public DependencyClassLoader(ClassLoader parent, File archive, PluginManifest manifest, List<PluginWrapper.Dependency> dependencies) {
            super(parent);
            this._for = archive;
            this.dependencies = dependencies;
            this.manifest = manifest;
        }

        private void updateTransientDependencies() {
            this.transientDependencies = null;
        }

        private List<PluginWrapper> getTransitiveDependencies() {
            if (this.transientDependencies == null) {
                CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                    @Override
                    protected List<PluginWrapper> getEdges(PluginWrapper pw) {
                        ArrayList<PluginWrapper> dep = new ArrayList<PluginWrapper>();
                        ITPIArtifact.matchDependency(ClassicPluginStrategy.this.pluginManager, pw.getDependencies(), pw, pair -> {
                            PluginWrapper p = (PluginWrapper)pair.getLeft();
                            if (p.isActive()) {
                                dep.add(p);
                            }
                        }, new Consumer[0]);
                        return dep;
                    }
                };
                String requiredFrom = this.manifest.computeShortName("");
                ITPIArtifact.matchDependency(ClassicPluginStrategy.this.pluginManager, this.dependencies, requiredFrom, this.manifest.parseClassifier(), pair -> {
                    try {
                        PluginWrapper p = (PluginWrapper)pair.getLeft();
                        if (p.isActive()) {
                            cgd.run(Collections.singleton(p));
                        }
                    }
                    catch (CyclicGraphDetector.CycleDetectedException e) {
                        throw new AssertionError((Object)e);
                    }
                }, new Consumer[0]);
                this.transientDependencies = cgd.getSorted();
            }
            return this.transientDependencies;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            for (PluginWrapper pw : this.getTransitiveDependencies()) {
                try {
                    Class<?> c = ClassLoaderReflectionToolkit._findLoadedClass(pw.classLoader, name);
                    if (c != null) {
                        return c;
                    }
                    return ClassLoaderReflectionToolkit._findClass(pw.classLoader, name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException("by " + this._for.getName() + ",for:" + name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            HashSet<URL> result = new HashSet<URL>();
            for (PluginWrapper pw : this.getTransitiveDependencies()) {
                Enumeration<URL> urls = ClassLoaderReflectionToolkit._findResources(pw.classLoader, name);
                while (urls != null && urls.hasMoreElements()) {
                    result.add(urls.nextElement());
                }
            }
            return Collections.enumeration(result);
        }

        @Override
        protected URL findResource(String name) {
            for (PluginWrapper pw : this.getTransitiveDependencies()) {
                URL url = ClassLoaderReflectionToolkit._findResource(pw.classLoader, name);
                if (url == null) continue;
                return url;
            }
            return null;
        }
    }

    public static class DependencyMeta {
        public List<PluginWrapper.Dependency> dependencies = new ArrayList<PluginWrapper.Dependency>();
        List<PluginWrapper.Dependency> optionalDependencies = new ArrayList<PluginWrapper.Dependency>();
    }
}

