/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.util.ClassLoaderReflectionToolkit;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UberClassLoader
extends ClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(UberClassLoader.class);
    private PluginManager pluginManager;
    private ConcurrentMap<String, WeakReference<Class>> generatedClasses = new ConcurrentHashMap<String, WeakReference<Class>>();
    private final Set<String> acceptedPlugins;
    public final Map<String, Class<?>> loaded = new HashMap();

    public UberClassLoader(PluginManager pluginManager) {
        this(pluginManager, null);
    }

    public UberClassLoader(PluginManager pluginManager, Set<String> acceptedPlugins) {
        super(PluginManager.class.getClassLoader());
        this.pluginManager = pluginManager;
        this.acceptedPlugins = acceptedPlugins;
    }

    public void addNamedClass(String className, Class c) {
        this.generatedClasses.put(className, new WeakReference<Class>(c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        WeakReference wc = (WeakReference)this.generatedClasses.get(name);
        if (wc != null) {
            Class c = (Class)wc.get();
            if (c != null) {
                return c;
            }
            this.generatedClasses.remove(name, wc);
        }
        if (name.startsWith("SimpleTemplateScript")) {
            throw new ClassNotFoundException("ignoring " + name);
        }
        Map<String, Class<?>> map = this.loaded;
        synchronized (map) {
            Class<?> c = null;
            c = this.loaded.get(name);
            if (c != null) {
                return c;
            }
        }
        for (PluginWrapper p2 : this.pluginManager.activePlugins) {
            if (!this.accept(p2)) continue;
            try {
                Class<?> c = ClassLoaderReflectionToolkit._findLoadedClass(p2.classLoader, name);
                if (c != null) {
                    Map<String, Class<?>> map2 = this.loaded;
                    synchronized (map2) {
                        this.loaded.put(name, c);
                    }
                    return c;
                }
                c = ClassLoaderReflectionToolkit._findClass(p2.classLoader, name);
                Map<String, Class<?>> map3 = this.loaded;
                synchronized (map3) {
                    this.loaded.put(name, c);
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        map = this.loaded;
        synchronized (map) {
            this.loaded.put(name, null);
        }
        throw new ClassNotFoundException(name + (String)(this.acceptedPlugins != null ? "\naccepted plugins:" + this.acceptedPlugins.stream().collect(Collectors.joining(",")) : "") + "\n,scan plugins:" + this.pluginManager.activePlugins.stream().map(p -> p.getShortName()).collect(Collectors.joining(",")) + "\nfaild plugins desc:" + this.pluginManager.getFaildPluginsDesc());
    }

    @Override
    protected URL findResource(String name) {
        for (PluginWrapper p : this.pluginManager.activePlugins) {
            URL url = null;
            if (this.accept(p)) {
                url = ClassLoaderReflectionToolkit._findResource(p.classLoader, name);
            }
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (PluginWrapper p : this.pluginManager.activePlugins) {
            if (!this.accept(p)) continue;
            resources.addAll(Collections.list(ClassLoaderReflectionToolkit._findResources(p.classLoader, name)));
        }
        return Collections.enumeration(resources);
    }

    protected boolean accept(PluginWrapper p) {
        if (this.acceptedPlugins == null) {
            return true;
        }
        return this.acceptedPlugins.contains(p.getShortName());
    }

    public String toString() {
        return "classLoader " + this.getClass().getName();
    }
}

