/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.extension.ITPIArtifactMatch;
import com.qlangtech.tis.extension.ModelObject;
import com.qlangtech.tis.extension.Plugin;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.impl.MissingDependencyException;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.model.UpdateSite;
import com.qlangtech.tis.extension.util.VersionNumber;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.YesNoMaybe;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PluginWrapper
implements Comparable<PluginWrapper>,
ModelObject,
ITPIArtifact {
    private Set<String> dependents = Collections.emptySet();
    private Set<String> optionalDependents = Collections.emptySet();
    public final PluginManager parent;
    public final PluginManifest manifest;
    public final ClassLoader classLoader;
    public final URL baseResourceURL;
    private final File disableFile;
    private final File archive;
    private final String shortName;
    private final boolean active;
    private boolean hasCycleDependency = false;
    private final List<Dependency> dependencies;
    private final List<Dependency> optionalDependencies;
    private final Optional<PluginClassifier> classifier;
    boolean isBundled;
    private static Set<String> CORE_ONLY_DEPENDANT = Collections.singleton("jenkins-core");
    private static final Logger LOGGER = Logger.getLogger(PluginWrapper.class.getName());
    public static final String MANIFEST_FILENAME = "META-INF/MANIFEST.MF";

    @Override
    public String getIdentityName() {
        return this.shortName;
    }

    public void setDependents(Set<String> dependents) {
        this.dependents = dependents;
    }

    public Set<String> getDependents() {
        if (this.isBundled && this.dependents.isEmpty()) {
            return CORE_ONLY_DEPENDANT;
        }
        return this.dependents;
    }

    public boolean hasDependants() {
        return this.isBundled || !this.dependents.isEmpty();
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public YesNoMaybe supportsDynamicLoad() {
        return this.manifest.supportsDynamicLoad();
    }

    public void setOptionalDependents(Set<String> optionalDependents) {
        this.optionalDependents = optionalDependents;
    }

    public PluginWrapper(PluginManager parent, File archive, PluginManifest manifest, URL baseResourceURL, ClassLoader classLoader, File disableFile, List<Dependency> dependencies, List<Dependency> optionalDependencies) {
        this.parent = parent;
        this.manifest = manifest;
        this.shortName = manifest.computeShortName(archive.getName());
        this.baseResourceURL = baseResourceURL;
        this.classLoader = classLoader;
        this.disableFile = disableFile;
        this.active = !disableFile.exists();
        this.dependencies = dependencies;
        this.optionalDependencies = optionalDependencies;
        this.archive = archive;
        this.classifier = manifest.parseClassifier();
    }

    @Override
    public final Optional<PluginClassifier> getClassifier() {
        return this.classifier;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.removeStart((String)this.getLongName(), (String)"Jenkins ");
    }

    public Plugin getPluginOrFail() throws Exception {
        Plugin plugin = this.getPlugin();
        if (plugin == null) {
            throw new Exception("Cannot find the plugin instance: " + this.shortName);
        }
        return plugin;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public List<Dependency> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Plugin getPlugin() {
        PluginManager.PluginInstanceStore pis = this.parent.pluginInstanceStore;
        return pis.store.get(this);
    }

    public String getUrl() {
        String url = this.manifest.getURL();
        if (url != null) {
            return url;
        }
        return null;
    }

    public String toString() {
        return "Plugin:" + this.getShortName();
    }

    public String getLongName() {
        return StringUtils.defaultIfBlank((String)this.manifest.getLongName(), (String)this.shortName);
    }

    public String getGroupId() {
        return this.manifest.getGroupId();
    }

    public long getLastModfiyTime() {
        return this.manifest.getLastModfiyTime();
    }

    public File getArchive() {
        return this.archive;
    }

    public String getVersion() {
        return this.manifest.getVersionOf();
    }

    public VersionNumber getVersionNumber() {
        return new VersionNumber(this.getVersion());
    }

    public boolean isOlderThan(VersionNumber v) {
        try {
            return this.getVersionNumber().compareTo(v) < 0;
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }

    public void stop() {
        Plugin plugin = this.getPlugin();
        if (plugin != null) {
            try {
                LOGGER.log(Level.FINE, "Stopping {0}", this.shortName);
                plugin.stop();
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Failed to shut down " + this.shortName, t);
            }
        } else {
            LOGGER.log(Level.FINE, "Could not find Plugin instance to stop for {0}", this.shortName);
        }
    }

    public void releaseClassLoader() {
        if (this.classLoader instanceof Closeable) {
            try {
                ((Closeable)((Object)this.classLoader)).close();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to shut down classloader", e);
            }
        }
    }

    public void enable() throws IOException {
        if (!this.disableFile.exists()) {
            LOGGER.log(Level.FINEST, "Plugin {0} has been already enabled. Skipping the enable() operation", this.getShortName());
            return;
        }
        if (!this.disableFile.delete()) {
            throw new IOException("Failed to delete " + this.disableFile);
        }
    }

    public void disable() throws IOException {
        FileUtils.touch((File)this.disableFile);
    }

    public boolean isActive() {
        return this.active && !this.hasCycleDependency();
    }

    public boolean hasCycleDependency() {
        return this.hasCycleDependency;
    }

    public void setHasCycleDependency(boolean hasCycle) {
        this.hasCycleDependency = hasCycle;
    }

    public boolean isBundled() {
        return this.isBundled;
    }

    public boolean isEnabled() {
        return !this.disableFile.exists();
    }

    public void setPlugin(Plugin plugin) {
        this.parent.pluginInstanceStore.store.put(this, plugin);
        plugin.wrapper = this;
    }

    public String getPluginClass() {
        return this.manifest.getPluginClass();
    }

    public boolean hasLicensesXml() {
        try {
            new URL(this.baseResourceURL, "WEB-INF/licenses.xml").openStream().close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    void resolvePluginDependencies() throws IOException {
        ArrayList<Pair<Dependency, ITPIArtifactMatch>> missingDependencies = new ArrayList<Pair<Dependency, ITPIArtifactMatch>>();
        ITPIArtifact.matchDependency(this.parent, this.dependencies, this, (Pair<PluginWrapper, Dependency> p) -> {}, missDep -> missingDependencies.add((Pair<Dependency, ITPIArtifactMatch>)missDep));
        if (!missingDependencies.isEmpty()) {
            throw new MissingDependencyException(this.shortName, missingDependencies);
        }
        ITPIArtifact.matchDependency(this.parent, this.optionalDependencies, this, (Pair<PluginWrapper, Dependency> p) -> this.dependencies.add((Dependency)p.getRight()), new Consumer[0]);
    }

    public UpdateSite.Plugin getInfo() {
        UpdateCenter uc = TIS.get().getUpdateCenter();
        return uc.getPlugin(this.getShortName());
    }

    public boolean hasUpdate() {
        return this.getUpdateInfo() != null;
    }

    public UpdateSite.Plugin getUpdateInfo() {
        return null;
    }

    @Deprecated
    public boolean isPinned() {
        return false;
    }

    public boolean isDeleted() {
        return !this.archive.exists();
    }

    @Override
    public int compareTo(PluginWrapper pw) {
        return this.shortName.compareToIgnoreCase(pw.shortName);
    }

    public boolean isDowngradable() {
        return this.getBackupFile().exists();
    }

    public File getBackupFile() {
        return new File(TIS.pluginCfgRoot, "plugins/" + this.getShortName() + ".bak");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBackupVersion() {
        File backup = this.getBackupFile();
        if (backup.exists()) {
            String string;
            JarFile backupPlugin = new JarFile(backup);
            try {
                string = backupPlugin.getManifest().getMainAttributes().getValue("Plugin-Version");
            }
            catch (Throwable throwable) {
                try {
                    backupPlugin.close();
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to get backup version from " + backup, e);
                    return null;
                }
            }
            backupPlugin.close();
            return string;
        }
        return null;
    }

    public PluginMeta getDesc() {
        return new PluginMeta(this.getShortName(), PluginWrapper.trimVersion(this.getVersion()), this.getClassifier());
    }

    static String trimVersion(String version) {
        return version.replaceFirst(" .+$", "");
    }

    @Deprecated
    public boolean isPinningForcingOldVersion() {
        return false;
    }

    public static final class Dependency {
        public final String shortName;
        public final String version;
        public final boolean optional;

        public static Dependency parse(String s) {
            int idx = s.indexOf(58);
            if (idx == -1) {
                throw new IllegalArgumentException("Illegal dependency specifier " + s);
            }
            String shortName = s.substring(0, idx);
            String version = s.substring(idx + 1);
            boolean isOptional = false;
            String[] osgiProperties = s.split(";");
            for (int i = 1; i < osgiProperties.length; ++i) {
                String osgiProperty = osgiProperties[i].trim();
                if (!osgiProperty.equalsIgnoreCase("resolution:=optional")) continue;
                isOptional = true;
            }
            return new Dependency(shortName, version, isOptional);
        }

        public Dependency(String shortName, String version, boolean optional) {
            this.shortName = shortName;
            this.version = version;
            this.optional = optional;
        }

        public String toString() {
            return this.shortName + " (" + this.version + ")";
        }
    }
}

