/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.extension.ITPIArtifactMatch;
import com.qlangtech.tis.extension.Plugin;
import com.qlangtech.tis.extension.PluginStrategy;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.RestartRequiredException;
import com.qlangtech.tis.extension.UberClassLoader;
import com.qlangtech.tis.extension.impl.ClassicPluginStrategy;
import com.qlangtech.tis.extension.impl.ExtensionRefreshException;
import com.qlangtech.tis.extension.impl.MissingDependencyException;
import com.qlangtech.tis.extension.impl.PluginManifest;
import com.qlangtech.tis.extension.init.InitMilestone;
import com.qlangtech.tis.extension.init.InitReactorRunner;
import com.qlangtech.tis.extension.init.InitStrategy;
import com.qlangtech.tis.extension.model.UpdateCenter;
import com.qlangtech.tis.extension.util.CyclicGraphDetector;
import com.qlangtech.tis.manage.common.CenterResource;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import com.qlangtech.tis.util.InitializerFinder;
import com.qlangtech.tis.util.Util;
import com.qlangtech.tis.util.YesNoMaybe;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jvnet.hudson.reactor.Executable;
import org.jvnet.hudson.reactor.Milestone;
import org.jvnet.hudson.reactor.Reactor;
import org.jvnet.hudson.reactor.TaskBuilder;
import org.jvnet.hudson.reactor.TaskGraphBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    public static PluginClassifier targetClassifierFilter;
    public static final String PACAKGE_CLASSIFIER = "classifier";
    public static final String PACAKGE_TPI_EXTENSION = ".tpi";
    private static final Logger logger;
    private static final Logger LOGGER;
    private final PluginStrategy strategy;
    private final File workDir;
    public final File rootDir;
    public volatile boolean pluginUploaded = false;
    public final PluginInstanceStore pluginInstanceStore = new PluginInstanceStore();
    public final UberClassLoader uberClassLoader = new UberClassLoader(this);
    boolean pluginListed = false;
    protected final List<PluginWrapper> plugins = new ArrayList<PluginWrapper>(){

        @Override
        public boolean add(PluginWrapper pluginWrapper) {
            return super.add(pluginWrapper);
        }
    };
    public final List<PluginWrapper> activePlugins = new CopyOnWriteArrayList<PluginWrapper>();
    protected final List<FailedPlugin> failedPlugins = new ArrayList<FailedPlugin>();
    public static final boolean FAST_LOOKUP = true;

    public File getWorkDir() {
        return this.workDir;
    }

    public Map<String, PluginWrapper> getActivePluginsMap() {
        return this.activePlugins.stream().collect(Collectors.toMap(p -> p.getShortName(), p -> p));
    }

    public String getFaildPluginsDesc() {
        if (CollectionUtils.isEmpty(this.failedPlugins)) {
            return "FailedPlugins is Empty";
        }
        return this.failedPlugins.stream().map(f -> "plugin:" + f.name + ",cause:" + ExceptionUtils.getMessage((Throwable)f.cause)).collect(Collectors.joining(","));
    }

    public PluginManager(File rootDir) {
        try {
            if (!rootDir.exists()) {
                FileUtils.forceMkdir((File)rootDir);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.workDir = rootDir;
        this.rootDir = rootDir;
        this.strategy = this.createPluginStrategy();
    }

    protected PluginStrategy createPluginStrategy() {
        return new ClassicPluginStrategy(this);
    }

    public PluginStrategy getPluginStrategy() {
        return this.strategy;
    }

    public void dynamicLoad(File arc, boolean removeExisting, PluginAndCfgsSnapshot.PluginWrapperList batch) throws IOException, InterruptedException, RestartRequiredException {
        LOGGER.info("Attempting to dynamic load {}", (Object)arc);
        PluginManifest manifest = PluginManifest.create(arc);
        if (manifest == null) {
            LOGGER.warn("can not find tpi:" + arc.getAbsolutePath());
            return;
        }
        ITPIArtifactMatch install = ITPIArtifact.create(manifest.computeShortName(""), manifest.parseClassifier());
        this.dynamicLoad(install, arc, removeExisting, batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dynamicLoad(ITPIArtifactMatch art, File arc, boolean removeExisting, PluginAndCfgsSnapshot.PluginWrapperList batch) throws IOException, InterruptedException, RestartRequiredException {
        Object aplugin;
        PluginWrapper p = null;
        PluginWrapper pw2 = this.getPlugin(art);
        if (pw2 != null) {
            if (removeExisting) {
                Iterator<PluginWrapper> i = this.plugins.iterator();
                while (i.hasNext()) {
                    pw2 = i.next();
                    if (!art.getIdentityName().equals(pw2.getShortName())) continue;
                    i.remove();
                    break;
                }
                aplugin = null;
                for (PluginWrapper pw2 : this.activePlugins) {
                    if (!art.getIdentityName().equals(pw2.getShortName())) continue;
                    aplugin = pw2;
                    break;
                }
                if (aplugin != null) {
                    this.activePlugins.remove(aplugin);
                }
            } else {
                throw new RestartRequiredException("PluginIsAlreadyInstalled_RestartRequired:" + art.getIdentityName());
            }
        }
        if (p == null) {
            p = this.strategy.createPluginWrapper(arc);
        }
        if (p.supportsDynamicLoad() == YesNoMaybe.NO) {
            throw new RestartRequiredException("PluginDoesntSupportDynamicLoad_RestartRequired:" + art.getIdentityName());
        }
        this.plugins.add(p);
        if (p.isActive()) {
            this.activePlugins.add(p);
        }
        aplugin = this.uberClassLoader.loaded;
        synchronized (aplugin) {
            this.uberClassLoader.loaded.clear();
        }
        try {
            p.resolvePluginDependencies();
            this.strategy.load(p);
            if (batch != null) {
                batch.add(p);
            } else {
                this.start(new PluginAndCfgsSnapshot.PluginWrapperList(p));
            }
        }
        catch (Exception e) {
            this.failedPlugins.add(new FailedPlugin(art.getIdentityName(), e));
            this.activePlugins.remove(p);
            this.plugins.remove(p);
            throw new IOException("Failed to install " + art.getIdentityName() + " plugin", e);
        }
        LOGGER.info("Plugin {}:{} dynamically {}", new Object[]{p.getShortName(), p.getVersion(), batch != null ? "loaded but not yet started" : "installed"});
    }

    public void start(PluginAndCfgsSnapshot.PluginWrapperList plugins) throws Exception {
        Map<String, PluginWrapper> pluginsByName = plugins.getPluginsByName();
        block2: for (PluginWrapper depender : this.plugins) {
            if (plugins.contains(depender)) continue;
            for (PluginWrapper.Dependency d : depender.getOptionalDependencies()) {
                PluginWrapper dependee = pluginsByName.get(d.shortName);
                if (dependee == null) continue;
                this.getPluginStrategy().updateDependency(depender, dependee);
                continue block2;
            }
        }
        this.resolveDependentPlugins();
        try {
            TIS.get().refreshExtensions();
        }
        catch (ExtensionRefreshException e) {
            throw new IOException("Failed to refresh extensions after installing some plugins", e);
        }
        for (PluginWrapper p : plugins.getPlugins()) {
            p.getPluginOrFail().postInitialize();
        }
        Reactor r = new Reactor(new TaskBuilder[]{InitMilestone.ordering()});
        final Set<ClassLoader> loaders = plugins.getLoaders();
        r.addAll((Iterable)new InitializerFinder(this.uberClassLoader){

            @Override
            protected boolean filter(Method e) {
                return !loaders.contains(e.getDeclaringClass().getClassLoader()) || super.filter(e);
            }
        }.discoverTasks(r));
        new InitReactorRunner().run(r);
    }

    public synchronized void resolveDependentPlugins() {
        for (PluginWrapper plugin : this.plugins) {
            HashSet<String> optionalDependents = new HashSet<String>();
            HashSet<String> dependents = new HashSet<String>();
            block1: for (PluginWrapper possibleDependent : this.plugins) {
                if (possibleDependent.getShortName().equals(plugin.getShortName()) || possibleDependent.isDeleted()) continue;
                List<PluginWrapper.Dependency> dependencies = possibleDependent.getDependencies();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    if (!dependency.shortName.equals(plugin.getShortName())) continue;
                    dependents.add(possibleDependent.getShortName());
                    if (!dependency.optional) continue block1;
                    optionalDependents.add(possibleDependent.getShortName());
                    continue block1;
                }
            }
            plugin.setDependents(dependents);
            plugin.setOptionalDependents(optionalDependents);
        }
    }

    public TaskBuilder initTasks(final InitStrategy initStrategy, final TIS tis) {
        Object builder = !this.pluginListed ? new TaskGraphBuilder(){
            List<File> archives;
            Collection<String> bundledPlugins = Collections.emptyList();
            {
                TaskGraphBuilder.Handle listUpPlugins = this.add("Listing up plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        archives = initStrategy.listPluginArchives(PluginManager.this);
                        if (CollectionUtils.isEmpty(archives)) {
                            throw new IllegalStateException("have not found any plugin in :" + PluginManager.this.rootDir.getAbsolutePath());
                        }
                    }
                });
                this.requires(new Milestone[]{listUpPlugins}).attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Preparing plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        final HashMap inspectedShortNames = new HashMap();
                        for (final File arc : archives) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Inspecting plugin " + arc, new Executable(){

                                public void run(Reactor session1) throws Exception {
                                    try {
                                        PluginWrapper p = PluginManager.this.strategy.createPluginWrapper(arc);
                                        if (this.isDuplicate(p)) {
                                            return;
                                        }
                                        p.isBundled = PluginManager.this.containsHpiJpi(bundledPlugins, arc.getName());
                                        PluginManager.this.plugins.add(p);
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(arc.getName(), e));
                                        throw e;
                                    }
                                }

                                private boolean isDuplicate(PluginWrapper p) {
                                    String shortName = p.getShortName();
                                    if (inspectedShortNames.containsKey(shortName)) {
                                        LOGGER.info("Ignoring " + arc + " because " + inspectedShortNames.get(shortName) + " is already loaded");
                                        return true;
                                    }
                                    boolean duplicated = false;
                                    Optional<PluginClassifier> classifier = p.getClassifier();
                                    if (targetClassifierFilter != null && classifier.isPresent()) {
                                        boolean bl = duplicated = !targetClassifierFilter.match(p.getShortName(), classifier.get());
                                    }
                                    if (!duplicated) {
                                        inspectedShortNames.put(shortName, arc);
                                    }
                                    return duplicated;
                                }
                            });
                        }
                        g.followedBy().attains(new Milestone[]{InitMilestone.PLUGINS_LISTED}).add("Checking cyclic dependencies", new Executable(){

                            public void run(Reactor reactor) throws Exception {
                                try {
                                    CyclicGraphDetector<PluginWrapper> cgd = new CyclicGraphDetector<PluginWrapper>(){

                                        @Override
                                        protected List<PluginWrapper> getEdges(PluginWrapper p) {
                                            ArrayList<PluginWrapper> next = new ArrayList<PluginWrapper>();
                                            this.addTo(p, p.getDependencies(), next);
                                            this.addTo(p, p.getOptionalDependencies(), next);
                                            return next;
                                        }

                                        private void addTo(PluginWrapper plugin, List<PluginWrapper.Dependency> dependencies, List<PluginWrapper> r) {
                                            ITPIArtifact.matchDependency(PluginManager.this, dependencies, plugin, p -> r.add((PluginWrapper)p.getLeft()), new Consumer[0]);
                                        }

                                        @Override
                                        protected void reactOnCycle(PluginWrapper q, List<PluginWrapper> cycle) throws CyclicGraphDetector.CycleDetectedException {
                                            LOGGER.info("found cycle in plugin dependencies: (root=" + q + ", deactivating all involved) " + Util.join(cycle, " -> "));
                                            for (PluginWrapper pluginWrapper : cycle) {
                                                pluginWrapper.setHasCycleDependency(true);
                                                PluginManager.this.failedPlugins.add(new FailedPlugin(pluginWrapper.getShortName(), new CyclicGraphDetector.CycleDetectedException(cycle)));
                                            }
                                        }
                                    };
                                    cgd.run(PluginManager.this.getPlugins());
                                    ListIterator<PluginWrapper> litr = PluginManager.this.getPlugins().listIterator();
                                    for (PluginWrapper p : cgd.getSorted()) {
                                        litr.next();
                                        litr.set(p);
                                        if (!p.isActive()) continue;
                                        PluginManager.this.activePlugins.add(p);
                                    }
                                }
                                catch (CyclicGraphDetector.CycleDetectedException e) {
                                    PluginManager.this.stop();
                                    throw e;
                                }
                            }
                        });
                        session.addAll(g.discoverTasks(session));
                        PluginManager.this.pluginListed = true;
                    }
                });
            }
        } : TaskBuilder.EMPTY_BUILDER;
        return TaskBuilder.union((TaskBuilder[])new TaskBuilder[]{builder, new TaskGraphBuilder(){
            {
                this.requires(new Milestone[]{InitMilestone.PLUGINS_LISTED}).attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add("Loading plugins", new Executable(){

                    public void run(Reactor session) throws Exception {
                        TaskGraphBuilder g = new TaskGraphBuilder();
                        for (final PluginWrapper pluginWrapper : PluginManager.this.activePlugins.toArray(new PluginWrapper[PluginManager.this.activePlugins.size()])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).add("Loading plugin " + pluginWrapper.getShortName(), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    try {
                                        pluginWrapper.resolvePluginDependencies();
                                        PluginManager.this.strategy.load(pluginWrapper);
                                    }
                                    catch (MissingDependencyException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(pluginWrapper.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(pluginWrapper);
                                        PluginManager.this.plugins.remove(pluginWrapper);
                                        LOGGER.error("Failed to install {}: {}", (Object)pluginWrapper.getShortName(), (Object)e.getMessage());
                                        return;
                                    }
                                    catch (IOException e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(pluginWrapper.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(pluginWrapper);
                                        PluginManager.this.plugins.remove(pluginWrapper);
                                        throw e;
                                    }
                                }
                            });
                        }
                        for (final PluginWrapper p : PluginManager.this.activePlugins.toArray(new PluginWrapper[PluginManager.this.activePlugins.size()])) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Initializing plugin " + p.getShortName(), new Executable(){

                                public void run(Reactor session) throws Exception {
                                    if (!PluginManager.this.activePlugins.contains(p)) {
                                        return;
                                    }
                                    try {
                                        p.getPlugin().postInitialize();
                                    }
                                    catch (Exception e) {
                                        PluginManager.this.failedPlugins.add(new FailedPlugin(p.getShortName(), e));
                                        PluginManager.this.activePlugins.remove(p);
                                        PluginManager.this.plugins.remove(p);
                                        throw e;
                                    }
                                }
                            });
                        }
                        if (CenterResource.notFetchFromCenterRepository()) {
                            g.followedBy().notFatal().attains(new Milestone[]{InitMilestone.PLUGINS_STARTED}).add("Load updateCenter", reactor -> {
                                UpdateCenter updateCenter = tis.getUpdateCenter();
                                updateCenter.load();
                                updateCenter.updateAllSites();
                            });
                        }
                        session.addAll(g.discoverTasks(session));
                    }
                });
                this.requires(new Milestone[]{InitMilestone.PLUGINS_PREPARED}).attains(new Milestone[]{InitMilestone.COMPLETED}).add("Resolving Dependant Plugins Graph", new Executable(){

                    public void run(Reactor reactor) throws Exception {
                        PluginManager.this.resolveDependantPlugins();
                    }
                });
            }
        }});
    }

    public synchronized void resolveDependantPlugins() {
        for (PluginWrapper plugin : this.plugins) {
            HashSet<String> dependants = new HashSet<String>();
            for (PluginWrapper possibleDependant : this.plugins) {
                if (possibleDependant.isDeleted()) continue;
                List<PluginWrapper.Dependency> dependencies = possibleDependant.getDependencies();
                for (PluginWrapper.Dependency dependency : dependencies) {
                    if (!dependency.shortName.equals(plugin.getShortName())) continue;
                    dependants.add(possibleDependant.getShortName());
                }
            }
            plugin.setDependents(dependants);
        }
    }

    public void stop() {
        for (PluginWrapper p : this.activePlugins) {
            p.stop();
            p.releaseClassLoader();
        }
        this.activePlugins.clear();
    }

    protected Collection<String> loadBundledPlugins() throws Exception {
        try {
            Set<String> set = this.loadPluginsFromWar("/WEB-INF/plugins", null);
            return set;
        }
        finally {
            this.loadDetachedPlugins();
        }
    }

    protected void loadDetachedPlugins() {
    }

    protected Set<String> loadPluginsFromWar(String fromPath, FilenameFilter filter) {
        HashSet<String> names = new HashSet<String>();
        return names;
    }

    public PluginWrapper whichPlugin(Class c) {
        PluginWrapper oneAndOnly = null;
        ClassLoader cl = c.getClassLoader();
        for (PluginWrapper p : this.activePlugins) {
            if (p.classLoader != cl) continue;
            if (oneAndOnly != null) {
                return null;
            }
            oneAndOnly = p;
        }
        return oneAndOnly;
    }

    private boolean containsHpiJpi(Collection<String> bundledPlugins, String name) {
        return bundledPlugins.contains(name.replaceAll("\\.hpi", PACAKGE_TPI_EXTENSION)) || bundledPlugins.contains(name.replaceAll("\\.tpi", ".hpi"));
    }

    public PluginWrapper getPlugin(ITPIArtifactMatch tpi) {
        for (PluginWrapper p : this.getPlugins()) {
            if (!ITPIArtifact.isEquals(p, tpi)) continue;
            return p;
        }
        return null;
    }

    public List<PluginWrapper> getPlugins() {
        ArrayList<PluginWrapper> out = new ArrayList<PluginWrapper>(this.plugins.size());
        out.addAll(this.plugins);
        return out;
    }

    static {
        LOGGER = logger = LoggerFactory.getLogger(PluginManager.class);
    }

    public static final class FailedPlugin {
        public final String name;
        public final Exception cause;

        public FailedPlugin(String name, Exception cause) {
            this.name = name;
            this.cause = cause;
        }

        public String getExceptionString() {
            return ExceptionUtils.getFullStackTrace((Throwable)this.cause);
        }
    }

    static final class PluginInstanceStore {
        final Map<PluginWrapper, Plugin> store = new Hashtable<PluginWrapper, Plugin>();

        PluginInstanceStore() {
        }
    }
}

