/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.extension.ITPIArtifact;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class ITPIArtifactMatch
implements ITPIArtifact {
    private Optional<PluginClassifier> classifier;
    private String identityName;
    private final String requiredFrom;

    ITPIArtifactMatch(String requiredFrom, Optional<PluginClassifier> classifier) {
        this.classifier = classifier;
        this.requiredFrom = requiredFrom;
    }

    public String getRequiredFrom() {
        return this.requiredFrom;
    }

    @Override
    public String getIdentityName() {
        if (StringUtils.isEmpty((String)this.identityName)) {
            throw new IllegalStateException("prop identityName can not be null");
        }
        return this.identityName;
    }

    public ITPIArtifactMatch setIdentityName(String identityName) {
        this.identityName = identityName;
        return this;
    }

    public String toString() {
        return "{classifier=" + (this.classifier.isPresent() ? this.classifier.get().getClassifier() : "not Present") + ", identityName='" + this.identityName + "', requiredFrom='" + this.requiredFrom + "'}";
    }

    @Override
    public Optional<PluginClassifier> getClassifier() {
        return this.classifier;
    }

    public boolean match(PluginClassifier candidateClassifier) {
        if (!this.classifier.isPresent()) {
            throw new IllegalStateException("plugin:" + this.requiredFrom + " classifier must be present");
        }
        PluginClassifier c = this.classifier.get();
        return c.match(this.requiredFrom, candidateClassifier);
    }
}

