/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.config.flink.IFlinkCluster;
import com.qlangtech.tis.extension.ITPIArtifactMatch;
import com.qlangtech.tis.extension.PluginManager;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.maven.plugins.tpi.PluginClassifier;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ITPIArtifact {
    public static final Logger logger = LoggerFactory.getLogger(ITPIArtifact.class);

    public static ITPIArtifactMatch matchh(String requiredFrom, Optional<PluginClassifier> classifier) {
        return new ITPIArtifactMatch(requiredFrom, classifier);
    }

    public static ITPIArtifactMatch matchh(ITPIArtifact art) {
        ITPIArtifactMatch match = ITPIArtifact.matchh(null, art.getClassifier());
        return match.setIdentityName(art.getIdentityName());
    }

    public static void matchDependency(PluginManager pluginManager, List<PluginWrapper.Dependency> dependencies, PluginWrapper pw, Consumer<Pair<PluginWrapper, PluginWrapper.Dependency>> pluginConsumer, Consumer<Pair<PluginWrapper.Dependency, ITPIArtifactMatch>> ... missConsumer) {
        ITPIArtifact.matchDependency(pluginManager, dependencies, pw.getShortName(), pw.getClassifier(), pluginConsumer, missConsumer);
    }

    public static void matchDependency(PluginManager pluginManager, List<PluginWrapper.Dependency> dependencies, String requiredFrom, Optional<PluginClassifier> classifier, Consumer<Pair<PluginWrapper, PluginWrapper.Dependency>> pluginConsumer, Consumer<Pair<PluginWrapper.Dependency, ITPIArtifactMatch>> ... missConsumer) {
        ITPIArtifactMatch match = ITPIArtifact.matchh(requiredFrom, classifier);
        for (PluginWrapper.Dependency d : dependencies) {
            match.setIdentityName(d.shortName);
            PluginWrapper p = pluginManager.getPlugin(match);
            if (p != null) {
                pluginConsumer.accept((Pair<PluginWrapper, PluginWrapper.Dependency>)Pair.of((Object)p, (Object)d));
                continue;
            }
            if (!IFlinkCluster.SKIP_PLUGIN_NAMES.contains(d.shortName)) {
                for (Consumer<Pair<PluginWrapper.Dependency, ITPIArtifactMatch>> c : missConsumer) {
                    c.accept((Pair<PluginWrapper.Dependency, ITPIArtifactMatch>)Pair.of((Object)d, (Object)match));
                }
                continue;
            }
            logger.warn("skip plugin dependency for:{}", (Object)d);
        }
    }

    public static ITPIArtifactMatch create(String idName) {
        return ITPIArtifact.create(idName, Optional.empty());
    }

    public static ITPIArtifactMatch create(String idName, Optional<PluginClassifier> classifier) {
        if (StringUtils.isEmpty((String)idName)) {
            throw new IllegalArgumentException("param idName can not be empty");
        }
        ITPIArtifactMatch match = ITPIArtifact.matchh("", classifier);
        match.setIdentityName(idName);
        return match;
    }

    public static boolean isEquals(ITPIArtifact dptCandidate, ITPIArtifactMatch b) {
        if (!StringUtils.equals((String)dptCandidate.getIdentityName(), (String)b.getIdentityName())) {
            return false;
        }
        Optional<PluginClassifier> ca = dptCandidate.getClassifier();
        Optional<PluginClassifier> ba = b.getClassifier();
        PluginClassifier.validate((String)b.getRequiredFrom(), (String)b.getIdentityName(), ca, ba);
        if (ca.isPresent()) {
            PluginClassifier candidateClassifier = ca.get();
            return b.match(candidateClassifier);
        }
        return true;
    }

    public String getIdentityName();

    default public Optional<PluginClassifier> getClassifier() {
        return Optional.empty();
    }
}

