/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ExtensionComponent;
import com.qlangtech.tis.extension.ExtensionComponentSet;
import com.qlangtech.tis.extension.ExtensionListListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionList<T>
extends AbstractList<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionList.class);
    protected final TIS tis;
    private final Class<T> extensionType;
    private volatile List<ExtensionComponent<T>> extensions;
    private final List<ExtensionListListener> listeners = new CopyOnWriteArrayList<ExtensionListListener>();
    private final Lock lock = new Lock();

    public static <T> ExtensionList<T> create(TIS tis, Class<T> type) {
        return new ExtensionList<T>(tis, type);
    }

    public List<ExtensionComponent<T>> getComponents() {
        return Collections.unmodifiableList(this.ensureLoaded());
    }

    protected ExtensionList(TIS tis, Class<T> extensionType) {
        this.tis = tis;
        this.extensionType = extensionType;
        Objects.requireNonNull(tis, "tis can not be null");
        if (tis == null) {
            this.extensions = Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(ExtensionComponentSet delta) {
        boolean fireOnChangeListeners = false;
        Object object = this.getLoadLock();
        synchronized (object) {
            if (this.extensions == null) {
                return;
            }
            Collection<ExtensionComponent<T>> found = this.load(delta);
            if (!found.isEmpty()) {
                ArrayList<ExtensionComponent<T>> l = new ArrayList<ExtensionComponent<T>>(this.extensions);
                l.addAll(found);
                this.extensions = this.sort(l);
                fireOnChangeListeners = true;
            }
        }
        if (fireOnChangeListeners) {
            this.fireOnChangeListeners();
        }
    }

    private void fireOnChangeListeners() {
        for (ExtensionListListener listener : this.listeners) {
            try {
                listener.onChange();
            }
            catch (Exception e) {
                LOGGER.info("Error firing ExtensionListListener.onChange().", (Throwable)e);
            }
        }
    }

    public static <T> ExtensionList<T> lookup(Class<T> type) {
        TIS j = TIS.get();
        return j == null ? ExtensionList.create(null, type) : j.getExtensionList(type);
    }

    public Class<T> getExtensionType() {
        return this.extensionType;
    }

    @Override
    public T get(int index) {
        return this.ensureLoaded().get(index).getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtensions() {
        Object object = this.getLoadLock();
        synchronized (object) {
            this.extensions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ExtensionComponent<T>> ensureLoaded() {
        if (this.extensions != null) {
            return this.extensions;
        }
        Object object = this.getLoadLock();
        synchronized (object) {
            if (this.extensions == null) {
                List<ExtensionComponent<T>> r = this.load();
                this.extensions = this.sort(r);
            }
            return this.extensions;
        }
    }

    protected List<ExtensionComponent<T>> sort(List<ExtensionComponent<T>> r) {
        r = new ArrayList<ExtensionComponent<T>>(r);
        Collections.sort(r);
        return r;
    }

    protected List<ExtensionComponent<T>> load() {
        return this.tis.getPluginManager().getPluginStrategy().findComponents(this.extensionType, this.tis);
    }

    protected Collection<ExtensionComponent<T>> load(ExtensionComponentSet delta) {
        return delta.find(this.extensionType);
    }

    protected Object getLoadLock() {
        return this.lock;
    }

    @Override
    public int size() {
        return this.ensureLoaded().size();
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

