/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.ExtensionComponent;
import com.qlangtech.tis.extension.ExtensionComponentSet;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.extension.UberClassLoader;
import com.qlangtech.tis.extension.impl.ExtensionRefreshException;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.java.sezpoz.Index;
import net.java.sezpoz.IndexItem;
import org.apache.commons.collections.CollectionUtils;

public abstract class ExtensionFinder {
    private static final Logger LOGGER = Logger.getLogger(ExtensionFinder.class.getName());

    @Deprecated
    public <T> Collection<T> findExtensions(Class<T> type, TIS hudson) {
        return Collections.emptyList();
    }

    public abstract void removeByType(Class<?> var1);

    public abstract ExtensionComponentSet refresh() throws ExtensionRefreshException;

    public abstract <T> Collection<ExtensionComponent<T>> find(Class<T> var1, TIS var2);

    @Deprecated
    public <T> Collection<ExtensionComponent<T>> _find(Class<T> type, TIS hudson) {
        return this.find(type, hudson);
    }

    public void scout(Class extensionType, TIS hudson) {
    }

    public static final class Sezpoz
    extends ExtensionFinder {
        private volatile List<IndexItem<TISExtension, Object>> indices;

        private List<IndexItem<TISExtension, Object>> getIndices() {
            if (this.indices == null) {
                UberClassLoader cl = TIS.get().getPluginManager().uberClassLoader;
                this.indices = ImmutableList.copyOf((Iterable)Index.load(TISExtension.class, Object.class, (ClassLoader)cl));
            }
            return this.indices;
        }

        @Override
        public void removeByType(Class<?> superType) {
            if (superType == null) {
                throw new IllegalArgumentException("param className can not be null");
            }
            if (CollectionUtils.isEmpty(this.indices)) {
                return;
            }
            try {
                ArrayList mask = Lists.newArrayList();
                for (IndexItem<TISExtension, Object> index : this.indices) {
                    if (index.kind() != ElementType.TYPE || !superType.isAssignableFrom((Class)index.element())) continue;
                    mask.add(index);
                }
                if (mask.size() > 0) {
                    this.indices = ImmutableList.copyOf((Collection)this.indices.stream().filter(i -> !mask.contains(i)).collect(Collectors.toList()));
                }
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized ExtensionComponentSet refresh() {
            List<IndexItem<TISExtension, Object>> old = this.indices;
            if (old == null) {
                return ExtensionComponentSet.EMPTY;
            }
            final List<IndexItem<TISExtension, Object>> delta = Sezpoz.listDelta(TISExtension.class, old);
            ArrayList r = Lists.newArrayList(old);
            r.addAll(delta);
            this.indices = ImmutableList.copyOf((Collection)r);
            return new ExtensionComponentSet(){

                @Override
                public <T> Collection<ExtensionComponent<T>> find(Class<T> type) {
                    return this._find(type, delta);
                }
            };
        }

        static <T extends Annotation> List<IndexItem<T, Object>> listDelta(Class<T> annotationType, List<? extends IndexItem<?, Object>> old) {
            ArrayList delta = Lists.newArrayList();
            UberClassLoader cl = TIS.get().getPluginManager().uberClassLoader;
            for (IndexItem ii : Index.load(annotationType, Object.class, (ClassLoader)cl)) {
                if (old.contains(ii)) continue;
                delta.add(ii);
            }
            return delta;
        }

        @Override
        public <T> Collection<ExtensionComponent<T>> find(Class<T> type, TIS tis) {
            return this._find(type, this.getIndices());
        }

        private <T> Collection<ExtensionComponent<T>> _find(Class<T> type, List<IndexItem<TISExtension, Object>> indices) {
            ArrayList<ExtensionComponent<T>> result = new ArrayList<ExtensionComponent<T>>();
            for (IndexItem<TISExtension, Object> item : indices) {
                try {
                    Object instance;
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    if (!type.isAssignableFrom(extType) || (instance = item.instance()) == null) continue;
                    result.add(new ExtensionComponent<T>(type.cast(instance), (TISExtension)item.annotation()));
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to load " + item.className(), e);
                }
            }
            return result;
        }

        @Override
        public void scout(Class extensionType, TIS tis) {
            for (IndexItem<TISExtension, Object> item : this.getIndices()) {
                try {
                    Class<?> extType;
                    AnnotatedElement e = item.element();
                    if (e instanceof Class) {
                        extType = (Class<?>)e;
                    } else if (e instanceof Field) {
                        extType = ((Field)e).getType();
                    } else if (e instanceof Method) {
                        extType = ((Method)e).getReturnType();
                    } else {
                        throw new AssertionError();
                    }
                    Class.forName(extType.getName(), true, extType.getClassLoader());
                }
                catch (Exception | LinkageError e) {
                    LOGGER.log(this.logLevel(item), "Failed to scout " + item.className(), e);
                }
            }
        }

        private Level logLevel(IndexItem<TISExtension, Object> item) {
            return ((TISExtension)item.annotation()).optional() ? Level.FINE : Level.WARNING;
        }
    }
}

