/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.TISExtension;
import com.qlangtech.tis.util.Util;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtensionComponent<T>
implements Comparable<ExtensionComponent<T>> {
    private static final Logger LOG = Logger.getLogger(ExtensionComponent.class.getName());
    private final T instance;
    private final double ordinal;

    public ExtensionComponent(T instance, double ordinal) {
        this.instance = instance;
        this.ordinal = ordinal;
    }

    public ExtensionComponent(T instance, TISExtension annotation) {
        this(instance, annotation.ordinal());
    }

    public ExtensionComponent(T instance) {
        this(instance, 0.0);
    }

    public double ordinal() {
        return this.ordinal;
    }

    public T getInstance() {
        return this.instance;
    }

    public boolean isDescriptorOf(Class<? extends Describable> c) {
        return this.instance instanceof Descriptor && ((Descriptor)this.instance).isSubTypeOf(c);
    }

    @Override
    public int compareTo(ExtensionComponent<T> that) {
        double b;
        double a = this.ordinal();
        if (a > (b = that.ordinal())) {
            return -1;
        }
        if (a < b) {
            return 1;
        }
        if (this.instance instanceof Descriptor && that.instance instanceof Descriptor) {
            try {
                return Util.fixNull(((Descriptor)this.instance).getDisplayName()).compareTo(Util.fixNull(((Descriptor)that.instance).getDisplayName()));
            }
            catch (RuntimeException x) {
                LOG.log(Level.WARNING, null, x);
            }
            catch (LinkageError x) {
                LOG.log(Level.WARNING, null, x);
            }
        }
        return this.instance.getClass().getName().compareTo(that.instance.getClass().getName());
    }
}

