/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.ExtensionComponent;
import com.qlangtech.tis.extension.ExtensionComponentSet;
import com.qlangtech.tis.extension.ExtensionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescriptorExtensionList<T extends Describable<T>, D extends Descriptor<T>>
extends ExtensionList<D> {
    private final Class<T> describableType;
    private static final Logger LOGGER = LoggerFactory.getLogger(DescriptorExtensionList.class);

    public static <T extends Describable<T>, D extends Descriptor<T>> DescriptorExtensionList<T, D> createDescriptorList(TIS tis, Class<T> describableType) {
        return new DescriptorExtensionList<T, D>(tis, describableType);
    }

    protected DescriptorExtensionList(TIS tis, Class<T> describableType) {
        super(tis, Descriptor.class);
        this.describableType = describableType;
    }

    public Class<T> getDescribableType() {
        return this.describableType;
    }

    @Override
    protected List<ExtensionComponent<D>> load() {
        return this._load(this.tis.getExtensionList(Descriptor.class).getComponents());
    }

    @Override
    protected Collection<ExtensionComponent<D>> load(ExtensionComponentSet delta) {
        return this._load(delta.find(Descriptor.class));
    }

    private List<ExtensionComponent<D>> _load(Iterable<ExtensionComponent<Descriptor>> set) {
        ArrayList<ExtensionComponent<D>> r = new ArrayList<ExtensionComponent<D>>();
        for (ExtensionComponent<Descriptor> c : set) {
            Descriptor d = c.getInstance();
            try {
                if (!this.describableType.isAssignableFrom(d.getT())) continue;
                r.add(c);
            }
            catch (IllegalStateException e) {
                LOGGER.error(d.getClass() + " doesn't extend Descriptor with a type parameter", (Throwable)e);
            }
        }
        return r;
    }
}

