/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.extension;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.citrus.turbine.impl.DefaultContext;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.async.message.client.consumer.impl.MQListenerFactory;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IManipulateStatus;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.ElementPluginDesc;
import com.qlangtech.tis.extension.HelpPath;
import com.qlangtech.tis.extension.IDescribableManipulate;
import com.qlangtech.tis.extension.IPropertyType;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.PluginWrapper;
import com.qlangtech.tis.extension.Saveable;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.AdapterPluginFormProperties;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.EnumFieldMode;
import com.qlangtech.tis.extension.impl.PropValRewrite;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.RootFormProperties;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.extension.util.AbstractPropAssist;
import com.qlangtech.tis.extension.util.OverwriteProps;
import com.qlangtech.tis.extension.util.PluginExtraProps;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.SubForm;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.IMultiElement;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.incr.TISSinkFactory;
import com.qlangtech.tis.runtime.module.misc.FormVaildateType;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.impl.DefaultFieldErrorHandler;
import com.qlangtech.tis.util.AttrValMap;
import com.qlangtech.tis.util.DescribableJSON;
import com.qlangtech.tis.util.DescriptorsJSON;
import com.qlangtech.tis.util.ISelectOptionsGetter;
import com.qlangtech.tis.util.PluginMeta;
import com.qlangtech.tis.util.impl.AttrVals;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jvnet.tiger_types.Types;

public abstract class Descriptor<T extends Describable>
implements Saveable,
ISelectOptionsGetter {
    public static final String SWITCH_OFF = "off";
    public static final String SWITCH_ON = "on";
    public static final String SWITCH_DEFAULT = "default";
    public static final String SWITCH_CUSTOMIZE = "customize";
    public static final String KEY_ENUM_PROP = "enum";
    public static final String KEY_primaryVal = "_primaryVal";
    public static final String KEY_DESC_VAL = "descVal";
    public static final String KEY_OPTIONS = "options";
    public static final String KEY_EPROPS = "eprops";
    private static final String KEY_VALIDATE_METHOD_PREFIX = "validate";
    private static final Pattern validateMethodPattern = Pattern.compile("validate(.+?)");
    private static final Pattern PATTERN_DISPLAY_NAME = Pattern.compile("(\\s+)(\\w)");
    public final transient Class<? extends T> clazz;
    public transient boolean overWriteValidateMethod;
    private volatile transient Map<String, IPropertyType> propertyTypes;
    private volatile transient Map<String, IPropertyType> globalPropertyTypes;
    private volatile transient PropertyType identityProp = null;
    private final transient Map<String, Method> validateMethodMap;
    private HelpPath _helpPath;
    private final Map<String, Callable<List<? extends IdentityName>>> selectOptsRegister = Maps.newHashMap();
    public PluginExtraProps fieldExtraDescs = new PluginExtraProps();

    protected Descriptor(Class<? extends T> clazz) {
        if (clazz == Descriptor.self()) {
            clazz = this.getClass();
        }
        this.clazz = clazz;
        this.validateMethodMap = this.createValidateMap();
    }

    public Optional<DescribableJSON<ParamsConfig>> getAIAssistSupport() {
        return Optional.empty();
    }

    public String helpPath() {
        return null;
    }

    public void cleanPropertyTypes() {
        this.propertyTypes = null;
    }

    protected Descriptor() {
        ParameterizedType pt;
        Class t;
        this.clazz = this.getClass().getEnclosingClass();
        if (this.clazz == null) {
            throw new AssertionError((Object)(this.getClass() + " doesn't have an outer class. Use the constructor that takes the Class object explicitly."));
        }
        Type bt = Types.getBaseClass(this.getClass(), Descriptor.class);
        if (bt instanceof ParameterizedType && !(t = Types.erasure((Type)(pt = (ParameterizedType)bt).getActualTypeArguments()[0])).isAssignableFrom(this.clazz)) {
            throw new AssertionError((Object)("Outer class " + this.clazz + " of " + this.getClass() + " is not assignable to " + t + ". Perhaps wrong outer class?"));
        }
        try {
            Method getd = this.clazz.getMethod("getDescriptor", new Class[0]);
            if (!getd.getReturnType().isAssignableFrom(this.getClass())) {
                throw new AssertionError((Object)(this.getClass() + " must be assignable to " + getd.getReturnType()));
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)(this.getClass() + " is missing getDescriptor method."));
        }
        this.initializeValidateMethod();
        this.validateMethodMap = this.createValidateMap();
    }

    private void initializeValidateMethod() {
        Class clazz;
        ArrayList allSuperclasses = Lists.newArrayList((Object[])new Class[]{this.getClass()});
        allSuperclasses.addAll(ClassUtils.getAllSuperclasses(this.getClass()));
        Iterator iterator = allSuperclasses.iterator();
        while (iterator.hasNext() && (clazz = (Class)iterator.next()) != Descriptor.class) {
            try {
                Method validateMethod = clazz.getDeclaredMethod(FormVaildateType.VERIFY.getToken(), IControlMsgHandler.class, Context.class, PostFormVals.class);
                this.overWriteValidateMethod = true;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
    }

    public Map<String, PluginExtraProps.FieldRefCreateor> getPropsImplRefs() {
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, IPropertyType> entry : this.getPropertyTypes().entrySet()) {
            if (!(entry.getValue() instanceof PropertyType)) continue;
            PropertyType pt = (PropertyType)entry.getValue();
            Optional<PluginExtraProps.FieldRefCreateor> refCreator = pt.getRefCreator();
            Objects.requireNonNull(refCreator, "field:" + entry.getKey() + " of plugin:" + this.clazz.getName() + " relevant refCreator can not be null");
            refCreator.ifPresent(creator -> result.put((String)entry.getKey(), creator));
        }
        return result;
    }

    public Map<String, Object> getExtractProps() {
        return this.getExtractProps(false);
    }

    public Map<String, Object> getExtractProps(boolean forAIPromote) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (this instanceof IEndTypeGetter) {
            this.appendProps(((IEndTypeGetter)((Object)this)).getEndType(), props);
        }
        if (this instanceof IDescribableManipulate) {
            IDescribableManipulate descManipuldate = (IDescribableManipulate)((Object)this);
            HashMap<String, String> manipulate = new HashMap<String, String>();
            manipulate.put("extendPoint", Objects.requireNonNull(descManipuldate.getManipulateExtendPoint()).getName());
            Optional<IPluginStore<IPluginStore>> manipulateStore = descManipuldate.getManipulateStore();
            manipulateStore.ifPresent(man -> {
                List plugins = man.getPlugins();
                JSONArray storeManipuldate = Descriptor.getManipulateMetas(forAIPromote, plugins);
                manipulate.put("stored", (String)storeManipuldate);
            });
            props.put("manipulate", manipulate);
        }
        if (this instanceof IDescribableManipulate.IManipulateStorable) {
            props.put("manipulateStorable", ((IDescribableManipulate.IManipulateStorable)((Object)this)).isManipulateStorable());
        }
        if (this._helpPath == null) {
            if (forAIPromote) {
                this._helpPath = HelpPath.NULL_PATH;
            } else {
                Object helpPath = this.helpPath();
                this._helpPath = HelpPath.create((String)helpPath);
                if (StringUtils.isEmpty((String)helpPath) && this instanceof IEndTypeGetter) {
                    IEndTypeGetter.EndType endType = Objects.requireNonNull(((IEndTypeGetter)((Object)this)).getEndType(), "endType can not be null");
                    if (endType.category == IEndTypeGetter.EndTypeCategory.Assist) {
                        helpPath = "docs/integrations/assist/" + endType.name() + "/#" + this.getDisplayNameAsAnchor();
                    } else if (endType.category == IEndTypeGetter.EndTypeCategory.Data) {
                        String anchor = null;
                        if (this instanceof DataSourceFactory.BaseDataSourceFactoryDescriptor || this instanceof ParamsConfig.BasicParamsConfigDescriptor) {
                            anchor = "\u6570\u636e\u6e90\u914d\u7f6e";
                        } else if (this instanceof DataxReader.BaseDataxReaderDescriptor) {
                            anchor = "\u6279\u91cf\u8bfb";
                        } else if (this instanceof DataxWriter.BaseDataxWriterDescriptor) {
                            anchor = "\u6279\u91cf\u5199";
                        } else if (this instanceof MQListenerFactory.BaseDescriptor) {
                            anchor = "\u5b9e\u65f6\u8bfb";
                        } else if (this instanceof TISSinkFactory.BaseSinkFunctionDescriptor) {
                            anchor = "\u5b9e\u65f6\u5199";
                        }
                        helpPath = "docs/integrations/data/" + endType.name() + "/#" + anchor;
                    } else if (endType.category == IEndTypeGetter.EndTypeCategory.Transformer) {
                        helpPath = "docs/integrations/transformer/" + endType.name() + "/#" + this.getDisplayNameAsAnchor();
                    }
                    this._helpPath = new HelpPath((String)helpPath);
                }
            }
        }
        if (!this._helpPath.isNull()) {
            props.put("helpPath", this._helpPath.getPath());
        }
        return props;
    }

    public static JSONArray getManipulateMetas(boolean forAIPromote, Collection<? extends Describable> plugins) {
        Object id = null;
        Object desc = null;
        JSONArray storeManipuldate = new JSONArray();
        try {
            for (Describable describable : plugins) {
                storeManipuldate.add((Object)Descriptor.getManipulateMeta(forAIPromote, describable));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return storeManipuldate;
    }

    public static JSONObject getManipulateMeta(boolean forAIPromote, Describable plugin) {
        if (!(plugin instanceof IdentityName)) {
            throw new IllegalStateException("plugin must be a IdentityName:" + ToStringBuilder.reflectionToString((Object)plugin));
        }
        Descriptor desc = Objects.requireNonNull(plugin.getDescriptor(), "desc can not be null");
        JSONObject eprops = new JSONObject();
        IdentityName id = (IdentityName)plugin;
        eprops.put("identityName", (Object)id.identityValue());
        eprops.put("descMeta", DescriptorsJSON.createPluginFormPropertyTypes(desc, Optional.empty(), forAIPromote).getLeft());
        if (plugin instanceof IManipulateStatus) {
            IManipulateStatus status = (IManipulateStatus)((Object)plugin);
            eprops.put("stateSummary", (Object)status.manipulateStatusSummary());
        }
        return eprops;
    }

    private Map<String, Object> appendProps(IEndTypeGetter.IEndType endType, Map<String, Object> eprops) {
        eprops.put(IEndTypeGetter.EndType.KEY_END_TYPE, endType.getVal());
        eprops.put(IEndTypeGetter.EndType.KEY_SUPPORT_ICON, endType.getIcon() != null);
        Optional<String> desc = endType.getDesc();
        desc.ifPresent(d -> eprops.put(IEndTypeGetter.EndType.KEY_END_TYPE_DESC, d));
        return eprops;
    }

    private Map<String, Method> createValidateMap() {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        Method[] validateMethods = this.getClass().getMethods();
        Matcher methodMatcher = null;
        String fieldName = null;
        for (Method validateMethod : validateMethods) {
            Parameter[] parameters;
            methodMatcher = validateMethodPattern.matcher(validateMethod.getName());
            if (!methodMatcher.matches() || !StringUtils.isNotBlank((String)(fieldName = StringUtils.uncapitalize((String)methodMatcher.group(1)))) || (parameters = validateMethod.getParameters()).length != 4 || parameters[0].getType() != IFieldErrorHandler.class || parameters[1].getType() != Context.class || parameters[2].getType() != String.class || parameters[3].getType() != String.class) continue;
            if (validateMethod.getReturnType() != Boolean.TYPE) {
                throw new IllegalStateException("method:" + validateMethod.getName() + " return type shall be type of boolean");
            }
            mapBuilder.put((Object)fieldName, (Object)validateMethod);
        }
        return mapBuilder.build();
    }

    public IPropertyType getPropertyType(String field) {
        return this.getPropertyTypes().get(field);
    }

    @Override
    public synchronized void save() {
        try {
            this.getConfigFile().write(this, Collections.emptySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected XmlFile getConfigFile() {
        return Descriptor.getConfigFile(this.getId());
    }

    public static String getPluginFileName(String pluginId) {
        return pluginId + ".xml";
    }

    public static XmlFile getConfigFile(String pluginId) {
        return Descriptor.getConfigFile(pluginId, false);
    }

    public static XmlFile getConfigFile(String pluginId, boolean metaCfgDir) {
        String pluginFileName = Descriptor.getPluginFileName(pluginId);
        return new XmlFile(new File(metaCfgDir ? Config.getMetaCfgDir() : TIS.pluginCfgRoot, pluginFileName), pluginFileName);
    }

    public PluginFormProperties getSubPluginFormPropertyTypes(String subFieldName) {
        IPropertyType propertyType = this.getPropertyTypes().get(subFieldName);
        if (propertyType == null) {
            throw new IllegalStateException(this.clazz.getName() + "'s prop subField:" + subFieldName + " relevant prop can not be null,exist prop keys:" + this.getPropertyTypes().keySet().stream().collect(Collectors.joining(",")));
        }
        if (!(propertyType instanceof SuFormProperties)) {
            throw new IllegalStateException("subFieldName:" + subFieldName + " prop must be " + SuFormProperties.class.getSimpleName() + "but now is :" + propertyType.getClass().getName());
        }
        return (SuFormProperties)propertyType;
    }

    public List<PluginFormProperties> getSubPluginFormPropertyTypes() {
        return this.getPropertyTypes().values().stream().filter(pp -> pp instanceof SuFormProperties).map(pp -> (SuFormProperties)pp).collect(Collectors.toList());
    }

    public Set<String> getPropertyFields() {
        return this.getPropertyTypes().keySet();
    }

    public PluginFormProperties getPluginFormPropertyTypes() {
        return this.getPluginFormPropertyTypes(Optional.empty());
    }

    public PluginFormProperties getPluginFormPropertyTypes(Optional<SubFormFilter> subFormFilter) {
        SubFormFilter filter = null;
        if (subFormFilter.isPresent()) {
            filter = subFormFilter.get();
            if (!filter.match(this)) {
                Descriptor parentDesc = filter.getTargetDescriptor();
                SuFormProperties subProps = (SuFormProperties)parentDesc.getSubPluginFormPropertyTypes(filter.subFieldName);
                Objects.requireNonNull(subProps, "prop:" + filter.subFieldName + " relevant subProps can not be null ");
                SuFormProperties subPluginFormPropertyTypes = SuFormProperties.copy(PropertyType.filterFieldProp(this.getPropertyTypes(true, ElementPluginDesc.create(this))), this.clazz, this, subProps);
                return subPluginFormPropertyTypes.overWriteInstClazz(this.clazz);
            }
            SuFormProperties subPluginFormPropertyTypes = (SuFormProperties)this.getSubPluginFormPropertyTypes(filter.subFieldName);
            try {
                Descriptor writerDescriptor = IDataxProcessor.getWriterDescriptor(filter.uploadPluginMeta);
                if (writerDescriptor != null && writerDescriptor instanceof DataxWriter.IRewriteSuFormProperties) {
                    subPluginFormPropertyTypes = Objects.requireNonNull(((DataxWriter.IRewriteSuFormProperties)((Object)writerDescriptor)).overwriteSubPluginFormPropertyType(subPluginFormPropertyTypes), "result can not be null " + PluginFormProperties.class.getSimpleName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (filter.subformDetailView) {
                final String subformDetailId = filter.subformDetailId;
                final SuFormProperties _subPluginFormPropertyTypes = subPluginFormPropertyTypes;
                return new AdapterPluginFormProperties(subPluginFormPropertyTypes){

                    @Override
                    public JSON getInstancePropsJson(Object instance) {
                        Collection<IdentityName> subFormPropVal = _subPluginFormPropertyTypes.getSubFormPropVal(instance);
                        for (IdentityName subProp : subFormPropVal) {
                            if (!StringUtils.equals((String)subformDetailId, (String)subProp.identityValue())) continue;
                            return _subPluginFormPropertyTypes.convertRootFormProps().getInstancePropsJson(subProp);
                        }
                        ISelectedTab subDetailed = (ISelectedTab)_subPluginFormPropertyTypes.newSubDetailed();
                        _subPluginFormPropertyTypes.pkPropertyType.setVal(subDetailed, subformDetailId);
                        return _subPluginFormPropertyTypes.convertRootFormProps().getInstancePropsJson(subDetailed);
                    }
                };
            }
            return subPluginFormPropertyTypes;
        }
        return new RootFormProperties(this, PropertyType.filterFieldProp(this.getPropertyTypes()));
    }

    public Map<String, IPropertyType> getPropertyTypes() {
        return this.getPropertyTypes(true);
    }

    public Map<String, IPropertyType> getPropertyTypes(boolean useCache) {
        return this.getPropertyTypes(useCache, ElementPluginDesc.create(this));
    }

    private Map<String, IPropertyType> getPropertyTypes(boolean useCache, Optional<ElementPluginDesc> descriptor) {
        if (!useCache || this.propertyTypes == null) {
            Map<String, IPropertyType> tmpPropertyTypes = Collections.unmodifiableMap(PropertyType.buildPropertyTypes(descriptor, this.clazz));
            List identityFields = tmpPropertyTypes.values().stream().filter(p -> p instanceof PropertyType && ((PropertyType)p).isIdentity()).map(p -> (PropertyType)p).collect(Collectors.toList());
            if (IdentityName.class.isAssignableFrom(this.clazz)) {
                if (identityFields.size() != 1) {
                    throw new IllegalStateException("class:" + this.clazz + " is type of " + IdentityName.class + " ,size:" + identityFields.size() + " must sign no more than one col:" + identityFields.stream().map(c -> c.displayName).collect(Collectors.joining(",")));
                }
                this.identityProp = (PropertyType)identityFields.get(0);
            } else if (identityFields.size() > 0) {
                throw new IllegalStateException("class:" + this.clazz + " is not type of " + IdentityName.class + " but more than one identity col:" + identityFields.stream().map(c -> c.displayName).collect(Collectors.joining(",")));
            }
            if (!useCache) {
                this.propertyTypes = null;
                return tmpPropertyTypes;
            }
            this.propertyTypes = tmpPropertyTypes;
        }
        return this.propertyTypes;
    }

    public final PluginValidateResult verify(final IControlMsgHandler msgHandler, final Context context, final FormVaildateType verify, final AttrVals formData, Optional<PluginFormProperties> pTypes, final Optional<SubFormFilter> subFormFilter, final PropValRewrite propValRewrite, final Optional<PostFormVals> parentFormVals) {
        if (parentFormVals == null) {
            throw new IllegalArgumentException("param parentFormVals can not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("param contenxt can not be null");
        }
        if (msgHandler == null) {
            throw new IllegalArgumentException("param msgHandler can not be null");
        }
        if (msgHandler == null) {
            throw new IllegalArgumentException("formData msgHandler can not be null");
        }
        final PluginFormProperties propertyTypes = this.getPropertyTypes(pTypes, subFormFilter);
        return (PluginValidateResult)propertyTypes.accept(new PluginFormProperties.IVisitor(){

            public PluginValidateResult visit(RootFormProperties props) {
                PostFormVals postFormVals = new PostFormVals(Descriptor.this, props, subFormFilter, msgHandler, context, formData);
                PluginValidateResult validateResult = new PluginValidateResult(postFormVals, (Integer)context.get("validate_plugin_index"), (Integer)context.get("validate_item_index"));
                boolean valid = this.validatePostFormVals(parentFormVals, postFormVals, Optional.empty());
                validateResult.valid = valid;
                validateResult.setDescriptor(Descriptor.this);
                return validateResult;
            }

            private boolean validatePostFormVals(Optional<PostFormVals> parentFormVals2, PostFormVals postFormVals, Optional<SubFormFilter> subFormFilter2) {
                if (verify == FormVaildateType.SECOND_VALIDATE && !Descriptor.this.secondVerify(msgHandler, context, postFormVals, parentFormVals2.orElseThrow(() -> new IllegalStateException("parentFormVals must be present")))) {
                    return false;
                }
                boolean valid = Descriptor.this.isValid(msgHandler, context, verify, subFormFilter2, propertyTypes, postFormVals, propValRewrite, parentFormVals2);
                if (verify == FormVaildateType.STRICT) {
                    if (!(!valid || Descriptor.this.verify(msgHandler, context, postFormVals) && this.validateSubformByParent(subFormFilter2, postFormVals))) {
                        valid = false;
                    }
                    if (!(!valid || Descriptor.this.validateAll(msgHandler, context, postFormVals) && this.validateSubformByParent(subFormFilter2, postFormVals))) {
                        valid = false;
                    }
                    if (valid) {
                        return Descriptor.this.isValid(msgHandler, context, FormVaildateType.SECOND_VALIDATE, subFormFilter2, propertyTypes, postFormVals, propValRewrite, Optional.of(postFormVals));
                    }
                } else {
                    if (!(!valid || verify != FormVaildateType.VERIFY || Descriptor.this.verify(msgHandler, context, postFormVals) && this.validateSubformByParent(subFormFilter2, postFormVals))) {
                        valid = false;
                    }
                    if (!(!valid || verify != FormVaildateType.FIRST_VALIDATE || Descriptor.this.validateAll(msgHandler, context, postFormVals) && this.validateSubformByParent(subFormFilter2, postFormVals))) {
                        valid = false;
                    }
                    if (valid && verify == FormVaildateType.VERIFY) {
                        return Descriptor.this.isValid(msgHandler, context, FormVaildateType.SECOND_VALIDATE, subFormFilter2, propertyTypes, postFormVals, propValRewrite, Optional.of(postFormVals));
                    }
                }
                return valid;
            }

            private boolean validateSubformByParent(Optional<SubFormFilter> subFormFilter2, PostFormVals postFormVals) {
                Descriptor parentDesc;
                if (subFormFilter2.isPresent() && (parentDesc = subFormFilter2.get().getTargetDescriptor()) instanceof SubForm.ISubFormItemValidate) {
                    return ((SubForm.ISubFormItemValidate)((Object)parentDesc)).validateSubForm(msgHandler, context, (SelectedTab)postFormVals.newInstance());
                }
                return true;
            }

            public PluginValidateResult visit(final BaseSubFormProperties props) {
                PluginValidateResult validateResult = null;
                if (!subFormFilter.isPresent()) {
                    throw new IllegalStateException("subFormFilter must be present");
                }
                SubFormFilter filter = (SubFormFilter)subFormFilter.get();
                if (filter.subformDetailView) {
                    PostFormVals formVals = new PostFormVals(Descriptor.this, props, subFormFilter, msgHandler, context, formData);
                    boolean valid = this.validatePostFormVals(parentFormVals, formVals, subFormFilter);
                    if (!valid) {
                        validateResult = new PluginValidateResult(formVals, (Integer)context.get("validate_plugin_index"), (Integer)context.get("validate_item_index"));
                        validateResult.valid = false;
                        return validateResult;
                    }
                } else {
                    if (props.atLeastOne() && formData.size() < 1) {
                        msgHandler.addErrorMessage(context, "\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a");
                        validateResult = new PluginValidateResult(null, 0, 0);
                        validateResult.valid = false;
                        return validateResult;
                    }
                    if (Descriptor.this instanceof SubForm.ISubFormItemValidate) {
                        assert (subFormFilter.isPresent());
                        if (!((SubForm.ISubFormItemValidate)((Object)Descriptor.this)).validateSubFormItems(msgHandler, context, props, (SubFormFilter)subFormFilter.get(), formData)) {
                            validateResult = new PluginValidateResult(null, 0, 0);
                            validateResult.valid = false;
                            return validateResult;
                        }
                    }
                    final SubDetailedPluginValidateResult subDetailedValidateResult = new SubDetailedPluginValidateResult();
                    props.visitAllSubDetailed(context, formData, new BaseSubFormProperties.ISubDetailedProcess<PluginValidateResult>(){

                        @Override
                        public PluginValidateResult process(String subFormId, AttrValMap sform) {
                            PluginValidateResult vResult = sform.validate(msgHandler, context, Optional.of(props.convertRootFormProps()), verify, parentFormVals);
                            subDetailedValidateResult.addSubDetailVaildateResult(subFormId, vResult);
                            return null;
                        }
                    });
                    if (!subDetailedValidateResult.isValid()) {
                        return subDetailedValidateResult;
                    }
                }
                validateResult = new PluginValidateResult(null, 0, 0);
                validateResult.valid = true;
                return validateResult;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(IControlMsgHandler msgHandler, Context context, FormVaildateType validateType, Optional<SubFormFilter> subFormFilter, PluginFormProperties propertyTypes, PostFormVals postFormVals, PropValRewrite propValRewrite, Optional<PostFormVals> parentFormVals) {
        Objects.requireNonNull(postFormVals, "postFormVals can not be null");
        Map<String, JSONObject> formData = postFormVals.rawFormData.asRootFormVals();
        boolean valid = true;
        for (Map.Entry<String, PropertyType> entry : propertyTypes.getKVTuples()) {
            Validator[] validators;
            String attr = entry.getKey();
            PropertyType attrDesc = entry.getValue();
            JSONObject valJ = formData.get(attr);
            if (valJ == null && attrDesc.isInputRequired()) {
                this.addFieldRequiredError((IFieldErrorHandler)msgHandler, context, attr);
                valid = false;
                continue;
            }
            if (valJ == null) {
                valJ = new JSONObject();
            }
            if (attrDesc.isDescribable()) {
                JSONObject descVal = valJ.getJSONObject(KEY_DESC_VAL);
                String impl = PropertyType.getPluginImpl(valJ);
                if (StringUtils.isBlank((String)impl)) {
                    this.addFieldRequiredError((IFieldErrorHandler)msgHandler, context, attr);
                    valid = false;
                    continue;
                }
                AttrValMap attrValMap = AttrValMap.parseDescribableMap(Optional.empty(), descVal);
                DefaultFieldErrorHandler.pushFieldStack((Context)context, (String)attr, (int)0);
                try {
                    if (attrValMap.validate(msgHandler, context, validateType, parentFormVals).isValid()) continue;
                    valid = false;
                    continue;
                }
                finally {
                    DefaultFieldErrorHandler.popFieldStack((Context)context);
                    continue;
                }
            }
            if (validateType == FormVaildateType.SECOND_VALIDATE) continue;
            if (attrDesc.typeIdentity() == FormFieldType.MULTI_SELECTABLE.getIdentity()) {
                FormFieldType.IMultiSelectValidator multiSelectValidator;
                List<FormFieldType.SelectedItem> selectedItems = this.getSelectedMultiItems(msgHandler, context, attrDesc, valJ);
                if (context.hasErrors()) {
                    return false;
                }
                if (selectedItems.size() < 1) {
                    for (Validator v : validators = attrDesc.getValidator()) {
                        if (v != Validator.require) continue;
                        v.validate((IFieldErrorHandler)msgHandler, context, attr, "");
                    }
                    continue;
                }
                if (!(this instanceof FormFieldType.IMultiSelectValidator) || (multiSelectValidator = (FormFieldType.IMultiSelectValidator)((Object)this)).validate((IFieldErrorHandler)msgHandler, subFormFilter, context, attr, selectedItems)) continue;
                valid = false;
                break;
            }
            boolean containVal = valJ.containsKey((Object)KEY_primaryVal);
            if (!containVal && attrDesc.isInputRequired()) {
                this.addFieldRequiredError((IFieldErrorHandler)msgHandler, context, attr);
                valid = false;
                continue;
            }
            if (containVal) {
                EnumFieldMode m = null;
                m = attrDesc.getEnumFieldMode();
                if (m != null && m == EnumFieldMode.MULTIPLE) {
                    Validator[] multiSelected = valJ.getJSONArray(KEY_primaryVal);
                    if (attrDesc.isInputRequired() && multiSelected.size() < 1) {
                        this.addFieldRequiredError((IFieldErrorHandler)msgHandler, context, attr);
                        valid = false;
                        continue;
                    }
                }
            }
            if (!containVal) continue;
            String attrVal = (String)propValRewrite.rewrite((IPropertyType)attrDesc, (Object)valJ.getString(KEY_primaryVal));
            postFormVals.fieldVals.put(attr, attrVal);
            for (Validator v : validators = attrDesc.getValidator()) {
                if (v.validate((IFieldErrorHandler)msgHandler, context, attr, attrVal)) continue;
                valid = false;
                break;
            }
            try {
                Method validateMethod = this.validateMethodMap.get(attr);
                if (validateMethod == null || !StringUtils.isNotEmpty((String)attrVal) || ((Boolean)validateMethod.invoke((Object)this, msgHandler, context, attr, attrVal)).booleanValue()) continue;
                valid = false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return valid;
    }

    private List<FormFieldType.SelectedItem> getSelectedMultiItems(IControlMsgHandler msgHandler, Context context, PropertyType attrDesc, JSONObject valJ) {
        JSONObject eprops = valJ.getJSONObject("_eprops");
        Objects.requireNonNull(eprops, "property '_eprops'   can not be null");
        return attrDesc.multiSelectablePropProcess(viewType -> viewType.getPostSelectedItems(attrDesc, msgHandler, context, eprops));
    }

    protected boolean verify(IControlMsgHandler msgHandler, Context context, PostFormVals postFormVals) {
        return true;
    }

    public boolean secondVerify(IControlMsgHandler msgHandler, Context context, PostFormVals postFormVals, PostFormVals parentPostFormVals) {
        return true;
    }

    protected boolean validateAll(IControlMsgHandler msgHandler, Context context, PostFormVals postFormVals) {
        return true;
    }

    public boolean validateCustomerField(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
        return true;
    }

    private void addFieldRequiredError(IFieldErrorHandler msgHandler, Context context, String attrKey) {
        msgHandler.addFieldError(context, attrKey, "\u5fc5\u987b\u586b\u5199", new Object[0]);
    }

    public ParseDescribable<Describable> newInstance(IControlMsgHandler pluginContext, Context context, FormData formData) {
        return this.newInstance(pluginContext, context, formData, Optional.empty(), (propType, val) -> val);
    }

    public ParseDescribable<Describable> newInstance(String appName, FormData formData) {
        return this.newInstance(IControlMsgHandler.namedContext((String)appName), (Context)new DefaultContext(), formData, Optional.empty(), (propType, val) -> val);
    }

    public ParseDescribable<Describable> newInstance(IControlMsgHandler pluginContext, Context context, AttrValMap.IAttrVals formData, Optional<SubFormFilter> subFormFilter, PropValRewrite propValRewrite) {
        try {
            return this.parseDescribable(pluginContext, context, formData, Optional.empty(), subFormFilter, propValRewrite);
        }
        catch (Exception e) {
            throw new RuntimeException("class:" + this.clazz.getName(), e);
        }
    }

    public ParseDescribable<Describable> parseDescribable(final IControlMsgHandler pluginContext, final Context context, final AttrValMap.IAttrVals keyValMap, Optional<PluginFormProperties> pTypes, final Optional<SubFormFilter> subFormFilter, final PropValRewrite propValRewrite) {
        final PluginFormProperties propertyTypes = this.getPropertyTypes(pTypes, subFormFilter);
        return (ParseDescribable)propertyTypes.accept(new PluginFormProperties.IVisitor(){

            public ParseDescribable<Describable> visit(RootFormProperties props) {
                return this.createPluginInstance();
            }

            private ParseDescribable<Describable> createPluginInstance() {
                try {
                    ParseDescribable<Describable> result = new ParseDescribable<Describable>((Describable)Descriptor.this.clazz.newInstance());
                    Descriptor.this.buildPluginInstance(pluginContext, context, keyValMap.asRootFormVals(), result, propertyTypes, propValRewrite);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private Describable setParentPluginClass(ParseDescribable<Describable> r) {
                Describable plugin = (Describable)r.getInstance();
                return plugin;
            }

            public ParseDescribable<Describable> visit(final BaseSubFormProperties props) {
                if (!subFormFilter.isPresent()) {
                    throw new IllegalStateException("subFormFilter must be present");
                }
                SubFormFilter filter = (SubFormFilter)subFormFilter.get();
                if (filter.subformDetailView) {
                    return new ParseDescribable<Describable>(this.setParentPluginClass(this.createPluginInstance()));
                }
                try {
                    final ArrayList subDetailedList = Lists.newArrayList();
                    props.visitAllSubDetailed(null, keyValMap, new BaseSubFormProperties.ISubDetailedProcess<Void>(){

                        @Override
                        public Void process(String subFormId, AttrValMap attrVals) {
                            ParseDescribable r = attrVals.createDescribable(pluginContext, context, Optional.of(props.convertRootFormProps()));
                            Describable plugin = this.setParentPluginClass(r);
                            subDetailedList.add(plugin);
                            return null;
                        }
                    });
                    return new ParseDescribable<Describable>(subDetailedList);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private PluginFormProperties getPropertyTypes(Optional<PluginFormProperties> pTypes, Optional<SubFormFilter> subFormFilter) {
        return pTypes.map(pp -> this == pp.getDescriptor() ? pp : null).orElseGet(() -> this.getPluginFormPropertyTypes(subFormFilter));
    }

    private <TARGET extends Describable<TARGET>> TARGET buildPluginInstance(IControlMsgHandler pluginContext, Context context, Map<String, JSONObject> keyValMap, ParseDescribable<TARGET> result, PluginFormProperties propertyTypes, PropValRewrite propValRewrite) {
        Describable describable = (Describable)result.getInstance();
        block2: for (Map.Entry<String, PropertyType> entry : propertyTypes.getKVTuples()) {
            boolean containVal;
            String attr = entry.getKey();
            PropertyType attrDesc = entry.getValue();
            JSONObject valJ = keyValMap.get(attr);
            if (valJ == null && attrDesc.isInputRequired()) {
                throw new IllegalStateException("prop:" + attr + " can not be empty,desc :" + this.clazz.getSimpleName());
            }
            if (valJ == null) {
                valJ = new JSONObject();
            }
            if (attrDesc.isDescribable()) {
                JSONObject descVal = Objects.requireNonNull(valJ.getJSONObject(KEY_DESC_VAL), "key:descVal relevant instant can not be null");
                String impl = descVal.getString("impl");
                Descriptor descriptor = TIS.get().getDescriptor(impl);
                if (descriptor == null) {
                    throw new IllegalStateException("impl:" + impl + " relevant descripotor can not be null");
                }
                ParseDescribable<Describable> vals = descriptor.newInstance(pluginContext, context, AttrVals.parseAttrValMap(descVal.get((Object)"vals")), Optional.empty(), propValRewrite);
                attrDesc.setVal(describable, propValRewrite.rewrite((IPropertyType)attrDesc, vals.getInstance()));
                continue;
            }
            if (attrDesc.typeIdentity() == FormFieldType.MULTI_SELECTABLE.getIdentity()) {
                List<FormFieldType.SelectedItem> selectedItems = this.getSelectedMultiItems(pluginContext, context, attrDesc, valJ);
                List multi = selectedItems.stream().filter(item -> item.isChecked()).map(item -> {
                    if (item.getCmeta() != null) {
                        return item.getCmeta();
                    }
                    CMeta c = new CMeta();
                    c.setName(item.getName());
                    return c;
                }).collect(Collectors.toList());
                if (attrDesc.isCollectionType()) {
                    attrDesc.setVal(describable, propValRewrite.rewrite((IPropertyType)attrDesc, multi));
                    continue;
                }
                for (IMultiElement type : multi) {
                    attrDesc.setVal(describable, propValRewrite.rewrite((IPropertyType)attrDesc, (Object)type));
                }
                continue;
            }
            boolean bl = containVal = valJ.containsKey((Object)KEY_primaryVal) && StringUtils.isNotBlank((String)valJ.getString(KEY_primaryVal));
            if (!containVal && attrDesc.isInputRequired()) {
                throw new IllegalStateException("prop:" + attr + " can not be empty ,descriptor:" + this.clazz.getSimpleName());
            }
            if (!containVal) continue;
            Object attrVal = valJ.get((Object)KEY_primaryVal);
            attrDesc.setVal(describable, propValRewrite.rewrite((IPropertyType)attrDesc, attrVal));
            if (!valJ.containsKey((Object)KEY_OPTIONS)) continue;
            JSONArray options = valJ.getJSONArray(KEY_OPTIONS);
            JSONObject opt = null;
            for (int i = 0; i < options.size(); ++i) {
                opt = options.getJSONObject(i);
                try {
                    if (!StringUtils.equals((String)((String)attrVal), (String)opt.getString("name"))) continue;
                    Class<?> implClass = TIS.get().pluginManager.uberClassLoader.loadClass(opt.getString("impl"));
                    PluginWrapper pluginWrapper = TIS.get().pluginManager.whichPlugin(implClass);
                    PluginMeta pluginMeta = Objects.requireNonNull(pluginWrapper, "implClass:" + implClass + " relevant pluginWrapper can not be null").getDesc();
                    result.extraPluginMetas.add(pluginMeta);
                    continue block2;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return (TARGET)describable;
    }

    public String getIdentityValue(T tDescribable) {
        return (String)this.getIdentityField().getFrontendOutput(tDescribable);
    }

    public PropertyType getIdentityField() {
        return this.getIdentityField(true);
    }

    public PropertyType getIdentityField(boolean validateNull) {
        if (this.identityProp == null) {
            this.getPropertyTypes();
            if (validateNull && this.identityProp == null) {
                throw new IllegalStateException("property identityProp can not be null,desc:" + this.getClass());
            }
        }
        return this.identityProp;
    }

    public final boolean isSubTypeOf(Class type) {
        return type.isAssignableFrom(this.clazz);
    }

    public String getDisplayName() {
        return this.clazz.getSimpleName();
    }

    public final String getDisplayNameAsAnchor() {
        String displayName = this.getDisplayName();
        Matcher matcher = PATTERN_DISPLAY_NAME.matcher(displayName);
        if (matcher.find()) {
            return matcher.replaceAll(mr -> "-" + StringUtils.lowerCase((String)mr.group(2)));
        }
        return displayName;
    }

    public String getId() {
        return this.clazz.getName();
    }

    public Class<T> getT() {
        Type subTyping = Types.getBaseClass(this.getClass(), Descriptor.class);
        if (!(subTyping instanceof ParameterizedType)) {
            throw new IllegalStateException(this.getClass() + " doesn't extend Descriptor with a type parameter.");
        }
        return Types.erasure((Type)Types.getTypeArgument((Type)subTyping, (int)0));
    }

    protected static Class self() {
        return Self.class;
    }

    protected final void registerSelectOptions(String fieldName, Callable<List<? extends IdentityName>> getter) {
        this.selectOptsRegister.put(fieldName, getter);
    }

    @Override
    public final List<SelectOption> getSelectOptions(String name) {
        Callable<List<? extends IdentityName>> opsCallable = this.selectOptsRegister.get(name);
        if (opsCallable == null) {
            throw new IllegalStateException("fieldName:" + name + " is select options has not been register,class:" + this.getClass().getName() + ",has registed:" + this.selectOptsRegister.keySet().stream().collect(Collectors.joining(",")));
        }
        try {
            List<? extends IdentityName> opts = opsCallable.call();
            if (opts == null) {
                return Collections.emptyList();
            }
            HashMap pluginEndTypeMapper = Maps.newHashMap();
            return opts.stream().map(r -> {
                Optional<IEndTypeGetter.EndType> et = Optional.empty();
                if (r instanceof Describable && (et = (Optional<IEndTypeGetter.EndType>)pluginEndTypeMapper.get(r.getClass())) == null) {
                    IEndTypeGetter.EndType endType = null;
                    Descriptor desc = null;
                    desc = ((Describable)r).getDescriptor();
                    if (desc instanceof IEndTypeGetter) {
                        endType = ((IEndTypeGetter)((Object)desc)).getEndType();
                    }
                    et = Optional.ofNullable(endType);
                } else if (r instanceof IEndTypeGetter) {
                    et = Optional.ofNullable(((IEndTypeGetter)r).getEndType());
                }
                pluginEndTypeMapper.put(r.getClass(), et);
                return new SelectOption(r.identityValue(), r.getDescribleClass(), et.orElse(null));
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("field name:" + name + ",class:" + this.getClass().getName(), e);
        }
    }

    public void addFieldDescriptor(String fieldName, Object dftVal, AbstractPropAssist.MarkdownHelperContent helperContent) {
        this.addFieldDescriptor(fieldName, dftVal, null, helperContent, Optional.empty(), false, false);
    }

    public PluginExtraProps.Props addFieldDescriptor(String fieldName, Object dftVal, AbstractPropAssist.MarkdownHelperContent helperContent, Optional<List<Option>> enums) {
        return this.addFieldDescriptor(fieldName, dftVal, null, helperContent, enums, false, false);
    }

    public PluginExtraProps.Props addFieldDescriptor(String fieldName, Object dftVal, String label, AbstractPropAssist.MarkdownHelperContent helperContent, Optional<List<Option>> enums) {
        return this.addFieldDescriptor(fieldName, dftVal, label, helperContent, enums, false, false);
    }

    public PluginExtraProps.Props addFieldDescriptor(String fieldName, Object dftVal, String label, AbstractPropAssist.MarkdownHelperContent helperContent, Optional<List<Option>> enums, OverwriteProps overwriteProps) {
        return this.addFieldDescriptor(fieldName, dftVal, label, helperContent, enums, overwriteProps.getDisabled(), overwriteProps.isReadOnly());
    }

    public PluginExtraProps.Props addFieldDescriptor(String fieldName, Object dftVal, String label, AbstractPropAssist.MarkdownHelperContent helperContent, Optional<List<Option>> enums, boolean disabled, boolean readonly) {
        JSONObject c = new JSONObject();
        PropertyType.setDefaultVal(dftVal, c);
        if (StringUtils.isNotEmpty((String)label)) {
            PropertyType.setLabel(label, c);
        }
        if (disabled) {
            PropertyType.setDisabled(c);
        }
        if (readonly) {
            PropertyType.setReadOnly(c);
        }
        PluginExtraProps.Props props = new PluginExtraProps.Props(c);
        if (helperContent.isNotEmpty()) {
            props.tagAsynHelp(helperContent);
        }
        if (enums.isPresent()) {
            c.put(KEY_ENUM_PROP, (Object)Option.toJson(enums.get()));
        }
        this.fieldExtraDescs.put(fieldName, props);
        return props;
    }

    public static class PostFormVals {
        public final AttrValMap.IAttrVals rawFormData;
        private final Descriptor desc;
        private final PluginFormProperties formProperties;
        private final Optional<SubFormFilter> subFormFilter;
        private final IControlMsgHandler msgHandler;
        private final Context context;
        private Describable instance;
        private Map<String, String> fieldVals = Maps.newHashMap();

        public <T extends Describable> T newInstance() {
            if (this.instance == null) {
                ParseDescribable<Describable> plugin = this.desc.parseDescribable(this.msgHandler, this.context, this.rawFormData, Optional.of(this.formProperties), this.subFormFilter, (propType, val) -> val);
                this.instance = (Describable)plugin.getInstance();
            }
            return (T)this.instance;
        }

        public PostFormVals(Descriptor desc, IControlMsgHandler msgHandler, Context context, AttrValMap.IAttrVals rawFormData) {
            this(desc, desc.getPluginFormPropertyTypes(Optional.empty()), Optional.empty(), msgHandler, context, rawFormData);
        }

        public PostFormVals(Descriptor desc, PluginFormProperties formProperties, Optional<SubFormFilter> subFormFilter, IControlMsgHandler msgHandler, Context context, AttrValMap.IAttrVals rawFormData) {
            this.rawFormData = rawFormData;
            this.desc = desc;
            this.formProperties = formProperties;
            this.subFormFilter = subFormFilter;
            this.msgHandler = msgHandler;
            this.context = context;
        }

        public String getField(String key) {
            return this.fieldVals.get(key);
        }
    }

    public static class SelectOption {
        private final String name;
        private final Class<?> implClass;
        private final IEndTypeGetter.EndType endType;

        public SelectOption(String name, Class<?> implClass, IEndTypeGetter.EndType endType) {
            this.name = name;
            this.implClass = implClass;
            this.endType = endType;
        }

        public String getEndType() {
            if (this.endType != null) {
                return this.endType.getVal();
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public String getImpl() {
            return this.implClass.getName();
        }
    }

    public static final class Self {
    }

    public static class ParseDescribable<T> {
        private final List<T> instance;
        public final boolean subFormFields;
        public final List<PluginMeta> extraPluginMetas = Lists.newArrayList();

        public ParseDescribable(T instance) {
            this(Collections.singletonList(instance), false);
        }

        public List<T> getSubFormInstances() {
            return this.instance;
        }

        public <TT> TT getInstance() {
            if (this.subFormFields) {
                throw new IllegalStateException("has multi instance");
            }
            Optional first = this.instance.stream().findFirst();
            return first.isPresent() ? (TT)first.get() : null;
        }

        public ParseDescribable(List<T> instance) {
            this(instance, true);
        }

        private ParseDescribable(List<T> instance, boolean subFormFields) {
            this.instance = instance;
            this.subFormFields = subFormFields;
        }
    }

    public static class FormData
    extends AttrVals {
        public FormData() {
            super(Maps.newHashMap());
        }

        public FormData(String key, String val) {
            this();
            this.addProp(key, val);
        }

        public JSONObject addProp(String key, String val) {
            JSONObject o = new JSONObject();
            o.put(Descriptor.KEY_primaryVal, (Object)val);
            this.attrValMap.put(key, o);
            return o;
        }

        public JSONObject addSubForm(String key, String formImpl, FormData form) {
            JSONObject o = new JSONObject();
            JSONObject vals = new JSONObject();
            if (StringUtils.isEmpty((String)formImpl)) {
                throw new IllegalArgumentException("parm formImpl can not empty");
            }
            vals.put("vals", form.asRootFormVals());
            vals.put("impl", (Object)formImpl);
            o.put(Descriptor.KEY_DESC_VAL, (Object)vals);
            this.attrValMap.put(key, o);
            return o;
        }
    }

    public static class PluginValidateResult {
        private final PostFormVals itemForm;
        public Boolean valid;
        private Descriptor descriptor;
        private final Integer validatePluginIndex;
        private final Integer validatePluginItemIndex;

        public PluginValidateResult(PostFormVals itemForm, Integer validatePluginIndex, Integer validatePluginItemIndex) {
            this.itemForm = itemForm;
            if (validatePluginIndex == null) {
                throw new IllegalArgumentException("param validatePluginIndex can not be null");
            }
            if (validatePluginItemIndex == null) {
                throw new IllegalArgumentException("param validatePluginItemIndex can not be null");
            }
            this.validatePluginIndex = validatePluginIndex;
            this.validatePluginItemIndex = validatePluginItemIndex;
        }

        public void setDescriptor(Descriptor descriptor) {
            this.descriptor = descriptor;
        }

        public static void setValidateItemPos(Context context, Integer pluginIndex, Integer itemIndex) {
            context.put("validate_plugin_index", (Object)pluginIndex);
            context.put("validate_item_index", (Object)itemIndex);
        }

        public void addIdentityFieldValueDuplicateError(IControlMsgHandler handler, Context context) {
            PluginValidateResult.setValidateItemPos(context, this.validatePluginIndex, this.validatePluginItemIndex);
            handler.addFieldError(context, this.descriptor.getIdentityField().displayName, "\u540d\u79f0\u91cd\u590d", new Object[0]);
        }

        public String getIdentityFieldValue() {
            if (this.descriptor == null) {
                throw new IllegalStateException("descriptor can not be null");
            }
            return this.itemForm.getField(this.descriptor.getIdentityField().displayName);
        }

        public PostFormVals getItemForm() {
            return this.itemForm;
        }

        public <T extends Describable> T newInstance() {
            if (this.descriptor == null) {
                throw new IllegalStateException("descriptor can not be null");
            }
            Object describable = this.itemForm.newInstance();
            return describable;
        }

        public boolean isValid() {
            return Boolean.TRUE.equals(this.valid);
        }
    }

    private static class SubDetailedPluginValidateResult
    extends PluginValidateResult {
        Map<String, PluginValidateResult> detailedValidateResult = Maps.newHashMap();

        public SubDetailedPluginValidateResult() {
            super(null, 0, 0);
        }

        public void addSubDetailVaildateResult(String subFormId, PluginValidateResult vResult) {
            this.detailedValidateResult.put(subFormId, vResult);
        }

        @Override
        public boolean isValid() {
            if (this.valid != null) {
                return this.valid;
            }
            for (Map.Entry<String, PluginValidateResult> entry : this.detailedValidateResult.entrySet()) {
                if (entry.getValue().isValid()) continue;
                this.valid = false;
                return this.valid;
            }
            this.valid = true;
            return this.valid;
        }
    }
}

