/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.impl;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.exec.AbstractExecContext;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class WorkflowExecContext
extends AbstractExecContext {
    private final Integer workflowId;
    private String workflowName;

    public WorkflowExecContext(Integer workflowId, long triggerTimestamp) {
        super(triggerTimestamp);
        this.workflowId = workflowId;
    }

    @Override
    public StoreResourceType getResType() {
        return StoreResourceType.DataFlow;
    }

    @Override
    public Integer getWorkflowId() {
        return this.workflowId;
    }

    @Override
    public String getWorkflowName() {
        return this.workflowName;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @Override
    public IDataxProcessor getProcessor() {
        if (StringUtils.isEmpty((String)this.getWorkflowName())) {
            throw new IllegalStateException("proper workflowName can not be empty");
        }
        return DataxProcessor.load(null, this.getResType(), this.getWorkflowName());
    }

    public String identityValue() {
        StoreResourceType resType = Objects.requireNonNull(this.getResType(), "resType can not be null");
        if (StringUtils.isEmpty((String)this.getWorkflowName())) {
            throw new IllegalStateException("proper workflowName can not be empty");
        }
        return resType.getType() + "_" + this.getWorkflowName();
    }

    public String getIndexName() {
        return null;
    }

    public boolean hasIndexName() {
        return false;
    }
}

