/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec.impl;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.exec.AbstractExecContext;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class DataXPipelineExecContext
extends AbstractExecContext {
    private final String dataXName;

    public DataXPipelineExecContext(String dataXName, Long triggerTimestamp) {
        super(triggerTimestamp);
        if (StringUtils.isEmpty((String)dataXName)) {
            throw new IllegalArgumentException("param dataXName can not be null");
        }
        this.dataXName = dataXName;
    }

    @Override
    public StoreResourceType getResType() {
        return StoreResourceType.DataApp;
    }

    @Override
    public IDataxProcessor getProcessor() {
        StoreResourceType resType = Objects.requireNonNull(this.getResType(), "resType can not be null");
        return DataxProcessor.load(null, resType, this.dataXName);
    }

    @Override
    public Integer getWorkflowId() {
        return null;
    }

    @Override
    public String getWorkflowName() {
        return null;
    }

    public String identityValue() {
        StoreResourceType resType = Objects.requireNonNull(this.getResType(), "resType can not be null");
        return resType.getType() + "_" + this.getIndexName();
    }

    public String getIndexName() {
        return this.dataXName;
    }

    public boolean hasIndexName() {
        return StringUtils.isNotEmpty((String)this.dataXName);
    }
}

