/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.ajax.AjaxResult;
import com.qlangtech.tis.assemble.FullbuildPhase;
import com.qlangtech.tis.assemble.TriggerType;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.coredefine.module.action.DistributeJobTriggerBuildResult;
import com.qlangtech.tis.datax.DataXJobSubmit;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.ISpecifiedLocalLogger;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.exec.AbstractExecContext;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.CreateNewTaskResult;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshotUtils;
import com.qlangtech.tis.powerjob.TriggersConfig;
import java.io.ByteArrayOutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IExecChainContext
extends IJoinTaskContext,
ISpecifiedLocalLogger {
    public static final Logger logger = LoggerFactory.getLogger(IExecChainContext.class);
    public static final MessageFormat WORKFLOW_CONFIG_URL_POST_FORMAT = new MessageFormat(Config.getConfigRepositoryHost() + "/config/config.ajax?action={0}&event_submit_{1}=true");

    public static Integer createNewTask(IExecChainContext chainContext) {
        return IExecChainContext.createNewTask(chainContext, TriggerType.MANUAL);
    }

    public static Integer createNewTask(IExecChainContext chainContext, TriggerType triggerType) {
        String histroyTaskId;
        Integer workflowId = chainContext.getWorkflowId();
        NewTaskParam newTaskParam = new NewTaskParam();
        ExecutePhaseRange executeRanage = chainContext.getExecutePhaseRange();
        if (executeRanage == null) {
            throw new IllegalStateException("executeRanage can not be null");
        }
        if (chainContext.hasIndexName() || executeRanage.getEnd().bigThan(FullbuildPhase.JOIN)) {
            String indexname = chainContext.getIndexName();
            newTaskParam.setAppname(indexname);
        }
        if (StringUtils.isNotBlank((String)(histroyTaskId = chainContext.getString("history.task.id")))) {
            newTaskParam.setHistoryTaskId(Integer.parseInt(histroyTaskId));
        }
        newTaskParam.setWorkflowid(workflowId);
        newTaskParam.setExecuteRanage(executeRanage);
        newTaskParam.setTriggerType(triggerType);
        Integer taskid = IExecChainContext.createNewTask(newTaskParam);
        logger.info("create new taskid:" + taskid);
        chainContext.setAttribute("taskid", taskid);
        return taskid;
    }

    public static Integer createNewTask(NewTaskParam newTaskParam) {
        String url = WORKFLOW_CONFIG_URL_POST_FORMAT.format(new Object[]{"fullbuild_workflow_action", "do_create_new_task"});
        AjaxResult result = HttpUtils.soapRemote((String)url, newTaskParam.params(), CreateNewTaskResult.class);
        if (!result.isSuccess()) {
            throw new IllegalStateException("error:" + String.join((CharSequence)",", result.getErrormsg()));
        }
        return ((CreateNewTaskResult)result.getBizresult()).getTaskid();
    }

    public static DistributeJobTriggerBuildResult triggerNewTask(TriggerNewTaskParam triggerNewTaskParam) {
        String url = WORKFLOW_CONFIG_URL_POST_FORMAT.format(new Object[]{"fullbuild_workflow_action", "do_initialize_trigger_task"});
        AjaxResult result = HttpUtils.soapRemote((String)url, triggerNewTaskParam.params(), DistributeJobTriggerBuildResult.class);
        if (!result.isSuccess()) {
            throw new IllegalStateException("error:" + String.join((CharSequence)",", result.getErrormsg()));
        }
        return (DistributeJobTriggerBuildResult)result.getBizresult();
    }

    public static JSONObject createInstanceParams(Integer tisTaskId, IDataxProcessor processor, boolean dryRun, Optional<String> pluginCfgsMetas) {
        JSONObject instanceParams = new JSONObject();
        instanceParams.put("taskid", (Object)tisTaskId);
        instanceParams.put("app", (Object)processor.identityValue());
        instanceParams.put("execTimeStamp", (Object)TimeFormat.getCurrentTimeStamp());
        instanceParams.put("storeResType", (Object)processor.getResType().getType());
        instanceParams.put("dryRun", (Object)dryRun);
        instanceParams.put("pluginCfgsMetas", (Object)pluginCfgsMetas.orElseGet(() -> {
            String string;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                PluginAndCfgsSnapshotUtils.writeManifest2OutputStream(outputStream, PluginAndCfgsSnapshot.createDataBatchJobManifestCfgAttrs(processor));
                Base64 base64 = new Base64();
                string = base64.encodeAsString(outputStream.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        outputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            outputStream.close();
            return string;
        }));
        return instanceParams;
    }

    public static AbstractExecContext deserializeInstanceParams(TriggersConfig triggerCfg, JSONObject instanceParams, Consumer<AbstractExecContext> execChainContextConsumer, Consumer<PluginAndCfgsSnapshot> cfgsSnapshotConsumer) {
        return AbstractExecContext.deserializeInstanceParams(triggerCfg, instanceParams, true, execChainContextConsumer, cfgsSnapshotConsumer);
    }

    public static AbstractExecContext deserializeInstanceParams(TriggersConfig triggerCfg, JSONObject instanceParams) {
        return AbstractExecContext.deserializeInstanceParams(triggerCfg, instanceParams, false, execChainContext -> {}, snapshot -> {
            throw new UnsupportedOperationException("shall not be execute");
        });
    }

    public IDataxProcessor getProcessor();

    public void addAsynSubJob(AsynSubJob var1);

    public List<AsynSubJob> getAsynSubJobs();

    public boolean containAsynJob();

    public void setTskTriggers(RemoteTaskTriggers var1);

    public RemoteTaskTriggers getTskTriggers();

    public void cancelTask();

    public ITISCoordinator getZkClient();

    public Integer getWorkflowId();

    public String getWorkflowName();

    public ITISFileSystem getIndexBuildFileSystem();

    public void rebindLoggingMDCParams();

    public static class NewTaskParam {
        private Integer workflowid;
        private TriggerType triggerType;
        private String appname;
        private Integer historyTaskId;
        private ExecutePhaseRange executeRanage;

        public void setHistoryTaskId(Integer historyTaskId) {
            this.historyTaskId = historyTaskId;
        }

        public Integer getWorkflowid() {
            return this.workflowid;
        }

        public void setWorkflowid(Integer workflowid) {
            this.workflowid = workflowid;
        }

        public TriggerType getTriggerType() {
            return this.triggerType;
        }

        public void setTriggerType(TriggerType triggerType) {
            this.triggerType = triggerType;
        }

        public String getAppname() {
            return this.appname;
        }

        public void setAppname(String appname) {
            this.appname = appname;
        }

        public ExecutePhaseRange getExecuteRanage() {
            return this.executeRanage;
        }

        public void setExecuteRanage(ExecutePhaseRange executeRanage) {
            this.executeRanage = executeRanage;
        }

        public List<HttpUtils.PostParam> params() {
            if (this.executeRanage == null) {
                throw new IllegalStateException("executeRanage can not be null");
            }
            ArrayList params = Lists.newArrayList((Object[])new HttpUtils.PostParam[]{new HttpUtils.PostParam("triggertype", (Object)this.triggerType.getValue()), new HttpUtils.PostParam("component.start", (Object)this.executeRanage.getStart().getValue()), new HttpUtils.PostParam("component.end", (Object)this.executeRanage.getEnd().getValue())});
            if (!this.executeRanage.contains(FullbuildPhase.FullDump)) {
                if (this.historyTaskId == null) {
                    throw new IllegalStateException("param historyTaskId can not be null");
                }
                params.add(new HttpUtils.PostParam("history.task.id", (Object)this.historyTaskId));
            }
            int requireParamCount = 0;
            if (this.workflowid != null) {
                params.add(new HttpUtils.PostParam("workflow_id", (Object)this.workflowid));
                ++requireParamCount;
            }
            if (StringUtils.isNotBlank((String)this.appname)) {
                params.add(new HttpUtils.PostParam("appname", (Object)this.appname));
                ++requireParamCount;
            }
            if (requireParamCount < 1) {
                throw new IllegalStateException("neither of param workflowid:" + this.workflowid + " appname:" + this.appname + " can be null");
            }
            return params;
        }
    }

    public static class TriggerNewTaskParam {
        private final Long powerJobWorkflowInstanceId;
        private final String appname;
        private final StoreResourceType resourceType;
        private final DataXJobSubmit.InstanceType instanceTriggerType;

        public TriggerNewTaskParam(Long powerJobWorkflowInstanceId, DataXJobSubmit.InstanceType instanceTriggerType, String appname, StoreResourceType resourceType) {
            this.powerJobWorkflowInstanceId = Objects.requireNonNull(powerJobWorkflowInstanceId);
            this.instanceTriggerType = Objects.requireNonNull(instanceTriggerType, "param instanceTriggerType can not be null");
            this.appname = Objects.requireNonNull(appname, "appname can not be null");
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType can not be null");
        }

        public List<HttpUtils.PostParam> params() {
            return Lists.newArrayList((Object[])new HttpUtils.PostParam[]{new HttpUtils.PostParam("triggertype", (Object)this.instanceTriggerType.literia), new HttpUtils.PostParam("storeResType", (Object)this.resourceType.getType()), new HttpUtils.PostParam("powerJobWorkflowInstanceId", (Object)this.powerJobWorkflowInstanceId), new HttpUtils.PostParam("appname", (Object)this.appname)});
        }
    }

    public static class AsynSubJob {
        public final String jobName;

        public AsynSubJob(String jobName) {
            this.jobName = jobName;
        }
    }
}

