/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.exec;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.exec.ExecChainContextUtils;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.exec.impl.DataXPipelineExecContext;
import com.qlangtech.tis.exec.impl.WorkflowExecContext;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.ITabPartition;
import com.qlangtech.tis.fullbuild.indexbuild.RemoteTaskTriggers;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.order.center.IAppSourcePipelineController;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.PluginAndCfgsSnapshot;
import com.qlangtech.tis.powerjob.TriggersConfig;
import com.qlangtech.tis.sql.parser.TabPartitions;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractExecContext
implements IExecChainContext,
IdentityName {
    private ITISCoordinator coordinator;
    private ExecutePhaseRange executePhaseRange;
    private boolean dryRun;
    private PhaseStatusCollection latestPhaseStatusCollection;
    private File specifiedLocalLoggerPath;
    private boolean disableGrpcRemoteServerConnect;
    private final long ps;
    private RemoteTaskTriggers tskTriggers;
    private String javaMemSpec;
    private final Map<String, Object> attribute = new HashMap<String, Object>();

    public long getPartitionTimestampWithMillis() {
        return this.ps;
    }

    public AbstractExecContext(long triggerTimestamp) {
        this.ps = Objects.requireNonNull(Long.valueOf(triggerTimestamp), "param triggerTimestamp can not be null");
        ExecChainContextUtils.setDependencyTablesPartitions((IJoinTaskContext)this, (TabPartitions)new TabPartitions((Map)Maps.newHashMap()));
    }

    public static PluginAndCfgsSnapshot resolveCfgsSnapshotConsumer(StoreResourceType resourceType, JSONObject instanceParams) {
        PluginAndCfgsSnapshot pluginAndCfgsSnapshot;
        String pluginCfgsMetas = instanceParams.getString("pluginCfgsMetas");
        String appName = instanceParams.getString("app");
        if (StringUtils.isEmpty((String)pluginCfgsMetas)) {
            throw new IllegalStateException("property:pluginCfgsMetas of instanceParams can not be null");
        }
        Base64 base64 = new Base64();
        ByteArrayInputStream manifestJar = new ByteArrayInputStream(base64.decode(pluginCfgsMetas));
        try {
            pluginAndCfgsSnapshot = PluginAndCfgsSnapshot.getRepositoryCfgsSnapshot(appName, Objects.requireNonNull(resourceType, "resourceType can not be null"), manifestJar);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)manifestJar).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        ((InputStream)manifestJar).close();
        return pluginAndCfgsSnapshot;
    }

    public void putTablePt(IDumpTable table, ITabPartition pt) {
        ExecChainContextUtils.getDependencyTablesPartitions((IJoinTaskContext)this).putPt(table, pt);
    }

    public boolean isDisableGrpcRemoteServerConnect() {
        return this.disableGrpcRemoteServerConnect;
    }

    public void setDisableGrpcRemoteServerConnect(boolean val) {
        this.disableGrpcRemoteServerConnect = val;
    }

    @Override
    public void setTskTriggers(RemoteTaskTriggers tskTriggers) {
        this.tskTriggers = tskTriggers;
    }

    @Override
    public RemoteTaskTriggers getTskTriggers() {
        return Objects.requireNonNull(this.tskTriggers, "tskTriggers can not be null");
    }

    public File getSpecifiedLocalLoggerPath() {
        return this.specifiedLocalLoggerPath;
    }

    public void setSpecifiedLocalLoggerPath(File specifiedLocalLoggerPath) {
        this.specifiedLocalLoggerPath = specifiedLocalLoggerPath;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    public abstract StoreResourceType getResType();

    @Override
    public abstract IDataxProcessor getProcessor();

    @Override
    public ITISCoordinator getZkClient() {
        return this.coordinator;
    }

    public void setCoordinator(ITISCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    public void setExecutePhaseRange(ExecutePhaseRange executePhaseRange) {
        this.executePhaseRange = executePhaseRange;
    }

    public String getJavaMemSpec() {
        return this.javaMemSpec;
    }

    public void setJavaMemSpec(String javaMemSpec) {
        this.javaMemSpec = javaMemSpec;
    }

    static AbstractExecContext deserializeInstanceParams(TriggersConfig triggerCfg, JSONObject instanceParams, boolean resolveCfgsSnapshotConsumer, Consumer<AbstractExecContext> execChainContextConsumer, Consumer<PluginAndCfgsSnapshot> cfgsSnapshotConsumer) {
        Integer taskId = Objects.requireNonNull(instanceParams.getInteger("taskid"), "taskid can not be null," + JsonUtil.toString((Object)instanceParams));
        boolean dryRun = instanceParams.getBooleanValue("dryRun");
        String javaMemSpec = instanceParams.getString("javaMemorySpec");
        Long triggerTimestamp = instanceParams.getLong("execTimeStamp");
        AbstractExecContext execChainContext = null;
        switch (triggerCfg.getResType()) {
            case DataFlow: {
                WorkflowExecContext wfContext = new WorkflowExecContext(0, triggerTimestamp);
                wfContext.setWorkflowName(triggerCfg.getDataXName());
                execChainContext = wfContext;
                break;
            }
            case DataApp: {
                String appName = instanceParams.getString("app");
                execChainContext = new DataXPipelineExecContext(appName, triggerTimestamp);
                break;
            }
            default: {
                throw new IllegalStateException("illegal resType:" + triggerCfg.getResType());
            }
        }
        execChainContext.setJavaMemSpec(javaMemSpec);
        execChainContext.setCoordinator(ITISCoordinator.create());
        execChainContext.setDryRun(dryRun);
        execChainContext.setAttribute("taskid", taskId);
        execChainContextConsumer.accept(execChainContext);
        if (resolveCfgsSnapshotConsumer) {
            cfgsSnapshotConsumer.accept(AbstractExecContext.resolveCfgsSnapshotConsumer(triggerCfg.getResType(), instanceParams));
        }
        return execChainContext;
    }

    public ExecutePhaseRange getExecutePhaseRange() {
        return this.executePhaseRange;
    }

    @Override
    public ITISFileSystem getIndexBuildFileSystem() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rebindLoggingMDCParams() {
        throw new UnsupportedOperationException();
    }

    public int getIndexShardCount() {
        throw new UnsupportedOperationException();
    }

    public <T> T getAttribute(String key) {
        return (T)this.attribute.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getAttribute(String key, Supplier<T> creator) {
        Map<String, Object> map = this.attribute;
        synchronized (map) {
            T attr = this.getAttribute(key);
            if (attr == null) {
                attr = creator.get();
                this.setAttribute(key, attr);
            }
            return attr;
        }
    }

    public void setAttribute(String key, Object v) {
        this.attribute.put(key, v);
    }

    public IAppSourcePipelineController getPipelineController() {
        return null;
    }

    public int getTaskId() {
        Integer taskId = Objects.requireNonNull((Integer)this.getAttribute("taskid"), "taskid can not be null");
        return taskId;
    }

    public void setLatestPhaseStatusCollection(PhaseStatusCollection latestPhaseStatusCollection) {
        this.latestPhaseStatusCollection = latestPhaseStatusCollection;
    }

    public PhaseStatusCollection loadPhaseStatusFromLatest() {
        return this.latestPhaseStatusCollection;
    }

    @Override
    public void addAsynSubJob(IExecChainContext.AsynSubJob jobName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IExecChainContext.AsynSubJob> getAsynSubJobs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containAsynJob() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelTask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getWorkflowId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getWorkflowName() {
        throw new UnsupportedOperationException();
    }

    public String getString(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String key) {
        throw new UnsupportedOperationException();
    }

    public int getInt(String key) {
        throw new UnsupportedOperationException();
    }

    public long getLong(String key) {
        throw new UnsupportedOperationException();
    }
}

