/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.db.parser;

import com.google.common.collect.Lists;
import com.qlangtech.tis.db.parser.ScanRecognizer;
import com.qlangtech.tis.plugin.ValidatorCommons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScannerPatterns {
    public static final String HOST_KEY = "host";
    private static final Pattern a2zPattern = Pattern.compile("[a-z]");
    private static List<ScanRecognizer> patternMatchers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ScanRecognizer> loadPatterns() {
        Pattern pattern = null;
        if (patternMatchers != null) return patternMatchers;
        Class<ScannerPatterns> clazz = ScannerPatterns.class;
        synchronized (ScannerPatterns.class) {
            if (patternMatchers != null) return patternMatchers;
            patternMatchers = new ArrayList<ScanRecognizer>();
            ArrayList tokens = Lists.newArrayList((Object[])TokenTypes.values());
            Collections.sort(tokens, new Comparator<TokenTypes>(){

                @Override
                public int compare(TokenTypes t1, TokenTypes t2) {
                    return t2.priority - t1.priority;
                }
            });
            for (TokenTypes t : tokens) {
                pattern = t.createPattern();
                patternMatchers.add(new ScanRecognizer(t, pattern, t.outputToken));
            }
            patternMatchers = Collections.unmodifiableList(patternMatchers);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return patternMatchers;
        }
    }

    public static void main(String[] args) {
    }

    private static class Group {
        final int gourpIndex;

        public Group(int group) {
            this.gourpIndex = group;
        }
    }

    public static enum TokenTypes {
        TT_HOST_DESC("^host", true, 999),
        TT_PASSWORD("^password", true),
        TT_USERNAME("^username", true),
        TT_PORT("^port", true),
        TT_MYSQL("^mysql", true),
        TT_LEFT("^\\{", true),
        TT_RIGHT("^\\}", true),
        TT_DBDESC_SPLIT("^,", true),
        TT_RANGE_LEFT("^\\[", true),
        TT_RANGE_RIGHT("^\\]", true),
        TT_RANGE_MINUS("^-", true),
        TT_IP("^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])", true, 995),
        TT_RANGE_NUMBER("^\\d+", true),
        TT_WHITESPACE("^(\\s)+", false),
        TT_HOST("(^([a-z0-9][a-z0-9\\-]{0,61}[a-z0-9])(\\.([a-z0-9][a-z0-9\\-]{0,61}[a-z0-9]))*)|^localhost", true, new Group(-1), 996, testToken -> {
            Matcher matcher = a2zPattern.matcher((CharSequence)testToken);
            return matcher.find();
        }),
        TT_COLON("^:", true, 998),
        TT_IDENTIFIER("^(" + ValidatorCommons.pattern_identity.pattern() + ")[\\r|\\n]?", true, new Group(1)),
        TT_PASSWORD_VALUE("^(\\S+)[\\r|\\n]?", true, new Group(1)),
        TT_EOF("^EOF", false);

        private final String regExpattern;
        private final boolean outputToken;
        private final Group gourpIndex;
        private final int priority;
        public final Function<String, Boolean> furtherChecker;

        public int getGourpIndex() {
            return this.gourpIndex.gourpIndex;
        }

        private TokenTypes(String regExpattern, boolean outputToken) {
            this(regExpattern, outputToken, 0);
        }

        private TokenTypes(String regExpattern, boolean outputToken, int priority) {
            this(regExpattern, outputToken, new Group(-1), priority, test -> true);
        }

        private TokenTypes(String regExpattern, boolean outputToken, Group group) {
            this(regExpattern, outputToken, group, 0, test -> true);
        }

        private TokenTypes(String regExpattern, boolean outputToken, Group group, int priority, Function<String, Boolean> furtherChecker) {
            this.regExpattern = regExpattern;
            this.outputToken = outputToken;
            this.gourpIndex = group;
            this.priority = priority;
            this.furtherChecker = furtherChecker;
        }

        public Pattern createPattern() {
            return Pattern.compile(this.regExpattern);
        }
    }
}

