/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.db.parser;

import java.util.ArrayList;
import java.util.List;

public final class NameRange {
    static final long[] pow10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private int zeroPadding;
    private long min;
    private long max;

    static boolean numericCheck(String input) {
        int len = input.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(input.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public final List<String> list() {
        return this.iterate(new StringBuilder(), new ArrayList<String>());
    }

    static String paddingZero(long number, int zeroPadding) {
        long pow = pow10[zeroPadding];
        if (number < pow) {
            return String.valueOf(pow + number).substring(1);
        }
        return String.valueOf(number);
    }

    public NameRange(String numeric) {
        this.zeroPadding = numeric.charAt(0) == '0' ? numeric.length() : 0;
        this.max = this.min = Long.parseLong(numeric);
    }

    public NameRange(long min, long max, int zeroPadding) {
        if (zeroPadding > 18) {
            throw new IllegalArgumentException("ZeroPadding must less than 18, but given " + zeroPadding);
        }
        this.zeroPadding = zeroPadding;
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public int getZeroPadding() {
        return this.zeroPadding;
    }

    private boolean merge(long min, long max, int zeroPadding) {
        if (max < this.min - 1L || min > this.max + 1L) {
            return false;
        }
        if (zeroPadding > 0) {
            if (this.zeroPadding == 0) {
                if (Long.toString(this.min).length() != zeroPadding || Long.toString(this.max).length() != zeroPadding) {
                    return false;
                }
                this.zeroPadding = zeroPadding;
            } else if (this.zeroPadding != zeroPadding) {
                return false;
            }
        } else if (zeroPadding == 0 && this.zeroPadding != 0 && (Long.toString(min).length() != this.zeroPadding || Long.toString(max).length() != this.zeroPadding)) {
            return false;
        }
        if (min < this.min) {
            this.min = min;
        }
        if (max > this.max) {
            this.max = max;
        }
        return true;
    }

    public boolean put(long number, int zeroPadding) {
        return this.merge(number, number, zeroPadding);
    }

    public boolean merge(NameRange nameRange) {
        return this.merge(nameRange.min, nameRange.max, nameRange.zeroPadding);
    }

    public boolean contains(String name) {
        if (!NameRange.numericCheck(name)) {
            return false;
        }
        if (this.zeroPadding != 0 && name.length() != this.zeroPadding) {
            return false;
        }
        long number = Long.parseLong(name);
        return number >= this.min && number <= this.max;
    }

    protected List<String> iterate(StringBuilder buf, List<String> list) {
        int len = buf.length();
        for (long number = this.min; number <= this.max; ++number) {
            if (this.zeroPadding != 0) {
                buf.append(NameRange.paddingZero(number, this.zeroPadding));
            } else {
                buf.append(number);
            }
            list.add(buf.toString());
            buf.setLength(len);
        }
        return list;
    }

    public static NameRange loadInput(String input) {
        int len = input.length();
        int minusIndex = input.indexOf(45);
        if (minusIndex < 0) {
            if (NameRange.numericCheck(input)) {
                long min = Long.parseLong(input);
                int zeroPadding = input.charAt(0) == '0' ? len : 0;
                return new NameRange(min, min, zeroPadding);
            }
            throw new IllegalArgumentException("Range not number: " + input);
        }
        if (minusIndex < 1 || minusIndex + 1 >= len) {
            throw new IllegalArgumentException("Range not complete: " + input);
        }
        String min = input.substring(0, minusIndex);
        String max = input.substring(minusIndex + 1);
        if (!NameRange.numericCheck(min) || !NameRange.numericCheck(max)) {
            throw new IllegalArgumentException("Range min/max not number: " + input);
        }
        if ((min.charAt(0) == '0' || max.charAt(0) == '0') && min.length() == max.length()) {
            return new NameRange(Long.parseLong(min), Long.parseLong(max), min.length());
        }
        return new NameRange(Long.parseLong(min), Long.parseLong(max), 0);
    }

    protected StringBuilder buildString(StringBuilder buf) {
        if (this.max > this.min) {
            if (this.zeroPadding != 0) {
                buf.append(NameRange.paddingZero(this.min, this.zeroPadding));
                buf.append('-');
                buf.append(NameRange.paddingZero(this.max, this.zeroPadding));
            } else {
                buf.append(this.min);
                buf.append('-');
                buf.append(this.max);
            }
        } else if (this.zeroPadding != 0) {
            buf.append(NameRange.paddingZero(this.min, this.zeroPadding));
        } else {
            buf.append(this.min);
        }
        return buf;
    }

    public static void main(String[] args) {
        NameRange nameRange = NameRange.loadInput("032-063");
    }
}

