/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.db.parser;

import com.qlangtech.tis.db.parser.ScanRecognizer;
import com.qlangtech.tis.db.parser.ScannerPatterns;
import com.qlangtech.tis.db.parser.Token;
import com.qlangtech.tis.db.parser.TokenBuffer;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class DBTokenizer {
    private String scannerBuffer;
    private final ArrayList<Token> tokenList = new ArrayList();
    private final List<ScanRecognizer> recognizerPatterns;

    public DBTokenizer(String content) {
        this.scannerBuffer = content;
        this.recognizerPatterns = ScannerPatterns.loadPatterns();
    }

    public TokenBuffer getTokenBuffer() {
        return new TokenBuffer(this.tokenList);
    }

    public void parse() {
        boolean parseInProgress = true;
        while (parseInProgress) {
            Iterator<ScanRecognizer> patternIterator = this.recognizerPatterns.iterator();
            parseInProgress = this.matchToken(patternIterator);
        }
    }

    private boolean matchToken(Iterator<ScanRecognizer> patternIterator) {
        boolean tokenMatch = false;
        boolean result = true;
        String content = null;
        do {
            ScanRecognizer recognizer;
            Pattern pattern;
            Matcher matcher;
            if (!(matcher = (pattern = (recognizer = patternIterator.next()).getPattern()).matcher(this.scannerBuffer)).find()) continue;
            String string = content = recognizer.getToken().getGourpIndex() > 0 ? matcher.group(recognizer.getToken().getGourpIndex()) : matcher.group();
            if (!recognizer.getToken().furtherChecker.apply(content).booleanValue()) continue;
            if (recognizer.isOutputToken()) {
                this.tokenList.add(new Token(recognizer.getToken(), content));
            }
            tokenMatch = true;
            this.scannerBuffer = this.scannerBuffer.substring(matcher.end());
        } while (patternIterator.hasNext() && !tokenMatch);
        if (!tokenMatch) {
            result = false;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        File f = new File("./db_config.txt");
        String content = FileUtils.readFileToString((File)f, (String)"utf8");
        System.out.println(content);
        DBTokenizer tokenizer = new DBTokenizer(content);
        tokenizer.parse();
        for (Token t : tokenizer.tokenList) {
            System.out.println(t.getContent() + "               " + t.getToken());
        }
    }
}

