/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.db.parser;

import com.qlangtech.tis.db.parser.DBTokenizer;
import com.qlangtech.tis.db.parser.NameRange;
import com.qlangtech.tis.db.parser.ScannerPatterns;
import com.qlangtech.tis.db.parser.Token;
import com.qlangtech.tis.db.parser.TokenBuffer;
import com.qlangtech.tis.plugin.ds.DBConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class DBConfigParser {
    private final TokenBuffer tokenBuffer;
    public final DBConfig dbConfigResult = new DBConfig();
    public final StringBuffer hostDesc = new StringBuffer();

    public DBConfigParser(TokenBuffer tokenBuffer) {
        this.tokenBuffer = tokenBuffer;
        this.dbConfigResult.setHostDesc(this.hostDesc);
    }

    public static Map<String, List<String>> parseDBEnum(String dbName, String dbNodeDesc) {
        if (StringUtils.isEmpty((String)dbNodeDesc)) {
            throw new IllegalArgumentException("param dbNodeDesc can not be null");
        }
        if (StringUtils.isEmpty((String)dbName)) {
            throw new IllegalArgumentException("param dbName can not be null");
        }
        try {
            DBTokenizer tokenizer = new DBTokenizer("host:" + dbNodeDesc);
            tokenizer.parse();
            DBConfigParser parser = new DBConfigParser(tokenizer.getTokenBuffer());
            parser.dbConfigResult.setName(dbName);
            parser.parseHostDesc();
            DBConfig db = parser.dbConfigResult;
            return db.getDbEnum();
        }
        catch (Throwable e) {
            throw new RuntimeException("dbNodeDesc:" + dbNodeDesc, e);
        }
    }

    public static void main(String[] args) throws Exception {
        File f = new File("./db_config.txt");
        String content = FileUtils.readFileToString((File)f, (String)"utf8");
        DBTokenizer tokenizer = new DBTokenizer(content);
        tokenizer.parse();
        DBConfigParser parser = new DBConfigParser(tokenizer.getTokenBuffer());
        DBConfig db = parser.startParser();
        System.out.println("hostDesc:" + parser.hostDesc);
        System.out.println("type:" + db.getDbType());
        System.out.println("name:" + db.getName());
        StringBuffer dbdesc = new StringBuffer();
        for (Map.Entry<String, List<String>> e : db.getDbEnum().entrySet()) {
            dbdesc.append(e.getKey()).append(":");
            for (String dbName : e.getValue()) {
                dbdesc.append(dbName).append(",");
            }
            dbdesc.append("\n");
        }
        System.out.println(dbdesc.toString());
    }

    public DBConfig startParser() {
        if (!this.dbConfig()) {
            throw new IllegalStateException("parse dbconfig file falid");
        }
        return this.dbConfigResult;
    }

    private boolean dbConfig() {
        boolean parseSuccess = false;
        if (this.mysqlBlock()) {
            parseSuccess = true;
        }
        return parseSuccess;
    }

    public boolean parseHostDesc() {
        boolean parseSuccess = true;
        Token t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_HOST_DESC)) {
            this.tokenBuffer.popToken();
            t = this.tokenBuffer.nextToken();
            if (t.isTokenType(ScannerPatterns.TokenTypes.TT_COLON)) {
                this.tokenBuffer.popToken();
                if (!this.dbHostEnum()) {
                    parseSuccess = false;
                }
            } else {
                parseSuccess = false;
            }
        } else {
            parseSuccess = false;
        }
        return parseSuccess;
    }

    private boolean dbPrimaryInfo() {
        int save = this.tokenBuffer.getCurrentPosition();
        boolean parseSuccess = this.parseHostDesc();
        Token t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_USERNAME)) {
            this.tokenBuffer.popToken();
            t = this.tokenBuffer.nextToken();
            if (t.isTokenType(ScannerPatterns.TokenTypes.TT_COLON)) {
                this.tokenBuffer.popToken();
                t = this.tokenBuffer.nextToken();
                if (t.isTokenType(ScannerPatterns.TokenTypes.TT_IDENTIFIER)) {
                    this.tokenBuffer.popToken();
                } else {
                    parseSuccess = false;
                }
            } else {
                parseSuccess = false;
            }
        } else {
            parseSuccess = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_PASSWORD)) {
            this.tokenBuffer.popToken();
            t = this.tokenBuffer.nextToken();
            if (t.isTokenType(ScannerPatterns.TokenTypes.TT_COLON)) {
                this.tokenBuffer.popToken();
                t = this.tokenBuffer.nextToken();
                if (t.isTokenType(ScannerPatterns.TokenTypes.TT_PASSWORD_VALUE)) {
                    this.tokenBuffer.popToken();
                } else {
                    parseSuccess = false;
                }
            } else {
                parseSuccess = false;
            }
        } else {
            parseSuccess = false;
        }
        if (!parseSuccess) {
            this.tokenBuffer.resetCurrentPosition(save);
        }
        return parseSuccess;
    }

    private boolean dbHostEnum() {
        boolean parseResult = this.dbHostParse();
        if (!parseResult) {
            return false;
        }
        Token t = null;
        while (true) {
            if (!parseResult) {
                continue;
            }
            t = this.tokenBuffer.nextToken();
            if (t == null || !t.isTokenType(ScannerPatterns.TokenTypes.TT_DBDESC_SPLIT)) break;
            this.tokenBuffer.popToken();
            this.hostDesc.append(t.getContent());
            parseResult = this.dbHostParse();
        }
        return parseResult;
    }

    private boolean dbHostParse() {
        String hostIp = this.ipORHost();
        if (hostIp != null) {
            if (!this.parseDBRange(hostIp) && !this.parseDBSingle(hostIp)) {
                this.dbConfigResult.addDbName(hostIp, this.dbConfigResult.getName());
            }
            return true;
        }
        return false;
    }

    private boolean parseDBSingle(String hostIp) {
        boolean parseResult = true;
        int save = this.tokenBuffer.getCurrentPosition();
        Token t = this.tokenBuffer.nextToken();
        if (t == null) {
            return false;
        }
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_LEFT)) {
            this.tokenBuffer.popToken();
        } else {
            parseResult = false;
        }
        NameRange range = null;
        String dbSuffix = null;
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_NUMBER)) {
            this.tokenBuffer.popToken();
            dbSuffix = t.getContent();
            range = NameRange.loadInput(t.getContent());
        } else {
            parseResult = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_RIGHT)) {
            this.tokenBuffer.popToken();
        } else {
            parseResult = false;
        }
        if (!parseResult) {
            this.tokenBuffer.resetCurrentPosition(save);
        } else {
            if (range == null) {
                throw new IllegalStateException("parse success but object range is null");
            }
            for (String dbOffset : range.list()) {
                this.dbConfigResult.addDbName(hostIp, this.dbConfigResult.getName() + dbOffset);
            }
            this.hostDesc.append("[" + dbSuffix + "]");
        }
        return parseResult;
    }

    private boolean parseDBRange(String hostIp) {
        boolean parseResult = true;
        int save = this.tokenBuffer.getCurrentPosition();
        Token t = this.tokenBuffer.nextToken();
        if (t == null) {
            return false;
        }
        String from = null;
        String to = null;
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_LEFT)) {
            this.tokenBuffer.popToken();
        } else {
            parseResult = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_NUMBER)) {
            this.tokenBuffer.popToken();
            from = t.getContent();
        } else {
            parseResult = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_MINUS)) {
            this.tokenBuffer.popToken();
        } else {
            parseResult = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_NUMBER)) {
            this.tokenBuffer.popToken();
            to = t.getContent();
        } else {
            parseResult = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_RIGHT)) {
            this.tokenBuffer.popToken();
        } else {
            parseResult = false;
        }
        if (!parseResult) {
            this.tokenBuffer.resetCurrentPosition(save);
        } else {
            NameRange range = NameRange.loadInput(from + "-" + to);
            this.hostDesc.append("[" + from + "-" + to + "]");
            for (String dbOffset : range.list()) {
                this.dbConfigResult.addDbName(hostIp, this.dbConfigResult.getName() + dbOffset);
            }
        }
        return parseResult;
    }

    private String ipORHost() {
        boolean praseResult = false;
        String hostip = null;
        int save = this.tokenBuffer.getCurrentPosition();
        Token t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_IP)) {
            this.tokenBuffer.popToken();
            this.hostDesc.append(t.getContent());
            praseResult = true;
            hostip = t.getContent();
        }
        if (!praseResult && (t = this.tokenBuffer.nextToken()).isTokenType(ScannerPatterns.TokenTypes.TT_HOST)) {
            this.hostDesc.append(t.getContent());
            this.tokenBuffer.popToken();
            praseResult = true;
            hostip = t.getContent();
        }
        if (!praseResult) {
            this.tokenBuffer.resetCurrentPosition(save);
        }
        return hostip;
    }

    private boolean dbPort() {
        boolean praseResult = false;
        int save = this.tokenBuffer.getCurrentPosition();
        Token token = this.tokenBuffer.nextToken();
        if (token.isTokenType(ScannerPatterns.TokenTypes.TT_PORT)) {
            this.tokenBuffer.popToken();
            token = this.tokenBuffer.nextToken();
            if (token.isTokenType(ScannerPatterns.TokenTypes.TT_COLON)) {
                this.tokenBuffer.popToken();
                token = this.tokenBuffer.nextToken();
                if (token.isTokenType(ScannerPatterns.TokenTypes.TT_RANGE_NUMBER)) {
                    this.tokenBuffer.popToken();
                    praseResult = true;
                }
            }
        }
        if (!praseResult) {
            this.tokenBuffer.resetCurrentPosition(save);
        }
        return praseResult;
    }

    private boolean mysqlBlock() {
        boolean parseSuccess = true;
        int save = this.tokenBuffer.getCurrentPosition();
        Token t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_MYSQL)) {
            this.dbConfigResult.setDbType(t.getContent());
            this.tokenBuffer.popToken();
        } else {
            parseSuccess = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_IDENTIFIER)) {
            this.dbConfigResult.setName(t.getContent());
            this.tokenBuffer.popToken();
        } else {
            parseSuccess = false;
        }
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_LEFT)) {
            this.tokenBuffer.popToken();
        } else {
            parseSuccess = false;
        }
        if (!this.dbPrimaryInfo()) {
            parseSuccess = false;
        }
        this.dbPort();
        t = this.tokenBuffer.nextToken();
        if (t.isTokenType(ScannerPatterns.TokenTypes.TT_RIGHT)) {
            this.tokenBuffer.popToken();
        } else {
            parseSuccess = false;
        }
        if (!parseSuccess) {
            this.tokenBuffer.resetCurrentPosition(save);
        }
        return parseSuccess;
    }
}

