/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class SubJobMilestone {
    private String name;
    private String describe;
    private boolean complete;
    private boolean success;

    public static SubJobMilestone readSubJobMilestoneJson(String o) {
        return (SubJobMilestone)JSON.parseObject((String)o, SubJobMilestone.class);
    }

    public SubJobMilestone() {
    }

    public SubJobMilestone(String name, String describe, boolean complete, boolean success) {
        this.name = name;
        this.describe = describe;
        this.complete = complete;
        this.success = success;
    }

    public static JSONObject createMilestoneJson(String subJobName, Optional<String> describe, boolean complete, Boolean success) {
        JSONObject step = new JSONObject();
        step.put("name", (Object)subJobName);
        step.put("describe", (Object)describe.orElse(subJobName));
        step.put("complete", (Object)complete);
        if (complete) {
            step.put("success", (Object)Objects.requireNonNull(success, "success can not be null"));
        }
        return step;
    }

    public static JSONArray createSubJobJSONArray(List<ILaunchingOrchestrate.ExecuteStep> executeSteps) {
        JSONArray steps = new JSONArray();
        JSONObject step = null;
        for (ILaunchingOrchestrate.ExecuteStep s : executeSteps) {
            step = SubJobMilestone.createMilestoneJson(s.getName(), Optional.ofNullable(s.getDescribe()), s.isComplete(), s.isSuccess());
            steps.add((Object)step);
        }
        return steps;
    }

    public static List<ILaunchingOrchestrate.ExecuteStep> readSubJobJSONArray(List<ILaunchingOrchestrate.ExecuteStep> example, Function<String, SubJobMilestone> executeSubJobFinder) {
        ArrayList result = Lists.newArrayList();
        SubJobMilestone subJobStone = null;
        for (ILaunchingOrchestrate.ExecuteStep e : example) {
            subJobStone = executeSubJobFinder.apply(e.getName());
            if (subJobStone != null) {
                result.add(e.copy(subJobStone));
                continue;
            }
            result.add(e.copy());
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescribe() {
        return this.describe;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isFaild() {
        return this.complete && !this.success;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}

