/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.qlangtech.tis.datax.job.JobResName;
import com.qlangtech.tis.datax.job.SubJobResName;
import com.qlangtech.tis.plugin.k8s.K8sImage;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class ServiceResName<T>
extends SubJobResName<T> {
    private static final String PORT_SUFFIX = "_SERVICE_PORT";

    public ServiceResName(String name, JobResName.SubJobExec<T> subJobExec) {
        super(name, subJobExec);
    }

    public String getPortEvnName() {
        return this.replaceAndUpperCase(this.getName()) + PORT_SUFFIX;
    }

    public String getHostPortReplacement(K8sImage image) {
        return this.getName() + "." + image.getNamespace() + ":" + this.toVarReplacement(this.getPortEvnName());
    }

    private String toVarReplacement(String val) {
        return "$(" + Objects.requireNonNull(val, "val can not be null") + ")";
    }

    private String replaceAndUpperCase(String val) {
        return StringUtils.upperCase((String)StringUtils.replace((String)val, (String)"-", (String)"_"));
    }

    @Override
    protected String getResourceType() {
        return "service";
    }
}

