/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.coredefine.module.action.LoopQueue;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.datax.job.DataXJobWorker;
import com.qlangtech.tis.datax.job.DefaultSSERunnable;
import com.qlangtech.tis.datax.job.FlinkClusterPojo;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.IServerLaunchCallable;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchLog;
import com.qlangtech.tis.datax.job.SubJobMilestone;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class ServerLaunchToken
extends Observable
implements Closeable {
    private final File launchedToken;
    private JSONObject launchedTokenJSON;
    private final File launchingToken;
    public final DataXJobWorker.K8SWorkerCptType workerCptType;
    private final LaunchTokenKey tokenKey;
    private static final Map<LaunchTokenKey, ServerLaunchToken> launchTokens = new WeakHashMap<LaunchTokenKey, ServerLaunchToken>();
    private Object writeOwner;
    private static final FlinkClusterTokenManager flinkClusterTokenManager = new FlinkClusterTokenManager();
    private final AtomicInteger writeLaunchTokenLock = new AtomicInteger();
    private List<JSONObject> notepadQueue;
    private PrintWriter launchingWriter;

    public ServerLaunchLog buildWALLog(ILaunchingOrchestrate.ExecuteSteps executeSteps) {
        ServerLaunchLog k8SLaunching2 = new ServerLaunchLog(this.isLaunchingTokenExist());
        k8SLaunching2.setExecuteSteps(executeSteps);
        if (!this.isLaunchingTokenExist()) {
            k8SLaunching2.setMilestones(Collections.emptyList());
            return k8SLaunching2;
        }
        try {
            LineIterator lines = FileUtils.lineIterator((File)this.getLaunchingToken(), (String)TisUTF8.getName());
            final HashMap milestones = Maps.newHashMap();
            final LoopQueue loggerQueue = new LoopQueue((Object[])new DefaultSSERunnable.SubJobLog[100]);
            while (lines.hasNext()) {
                ServerLaunchToken.processLaunchWALLine(lines.nextLine(), new DefaultSSERunnable.LaunchWALLineVisitor(){

                    @Override
                    public void process(DefaultSSERunnable.SubJobLog jobLog) {
                        loggerQueue.write((Object)jobLog);
                    }

                    @Override
                    public void process(SubJobMilestone stone) {
                        milestones.put(stone.getName(), stone);
                    }
                });
            }
            k8SLaunching2.setMilestones(Lists.newArrayList(milestones.values()));
            k8SLaunching2.setExecuteSteps(new ILaunchingOrchestrate.ExecuteSteps(executeSteps.getTaskName(), this, SubJobMilestone.readSubJobJSONArray(executeSteps.getExecuteSteps(), subJobName -> (SubJobMilestone)milestones.get(subJobName))));
            k8SLaunching2.setLogs((DefaultSSERunnable.SubJobLog[])loggerQueue.readBuffer());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return k8SLaunching2;
    }

    public static void processLaunchWALLine(String line, DefaultSSERunnable.LaunchWALLineVisitor lineStructVisitor) {
        String[] lineSplit = StringUtils.split((String)line, (char)'\u0005');
        SSERunnable.SSEEventType event = SSERunnable.SSEEventType.parse((String)lineSplit[0]);
        String data = lineSplit[1];
        switch (event) {
            case TASK_LOG: {
                lineStructVisitor.process(DefaultSSERunnable.SubJobLog.readSubJobLog(data));
                break;
            }
            case TASK_MILESTONE: {
                SubJobMilestone stone = SubJobMilestone.readSubJobMilestoneJson(data);
                lineStructVisitor.process(stone);
                break;
            }
            case TASK_EXECUTE_STEPS: {
                break;
            }
            default: {
                throw new IllegalStateException("illegal token:" + event);
            }
        }
    }

    public static FlinkClusterTokenManager createFlinkClusterToken() {
        return flinkClusterTokenManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerLaunchToken create(File launchTokenParentDir, TargetResName workerType, boolean launchTokenUseCptType, DataXJobWorker.K8SWorkerCptType workerCptType) {
        Class<ServerLaunchToken> clazz = ServerLaunchToken.class;
        synchronized (ServerLaunchToken.class) {
            ServerLaunchToken launchToken = null;
            LaunchTokenKey tokenKey = new LaunchTokenKey(workerType, launchTokenUseCptType, workerCptType);
            launchToken = launchTokens.get(tokenKey);
            if (launchToken == null) {
                launchToken = new ServerLaunchToken(tokenKey, launchTokenParentDir, workerType, launchTokenUseCptType, workerCptType);
                launchTokens.put(tokenKey, launchToken);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return launchToken;
        }
    }

    public boolean hasWriteOwner() {
        return this.writeOwner != null;
    }

    private ServerLaunchToken(LaunchTokenKey tokenKey, File launchTokenParentDir, TargetResName workerType, boolean launchTokenUseCptType, DataXJobWorker.K8SWorkerCptType workerCptType) {
        this.launchedToken = DataXJobWorker.LaunchToken.SUCCESS_COMPLETE.getTokenFile(launchTokenParentDir, workerType, launchTokenUseCptType, workerCptType);
        this.launchingToken = DataXJobWorker.LaunchToken.DOING.getTokenFile(launchTokenParentDir, workerType, launchTokenUseCptType, workerCptType);
        this.workerCptType = Objects.requireNonNull(workerCptType, "workerCptType can not be null");
        this.tokenKey = Objects.requireNonNull(tokenKey, "tokenKey can not be null");
    }

    public void setWriteOwner(Object writeOwner) {
        this.writeOwner = writeOwner;
    }

    @Override
    public void notifyObservers(Object arg) {
        super.setChanged();
        super.notifyObservers(arg);
    }

    public File getLaunchingToken() {
        return this.launchingToken;
    }

    public boolean isLaunchingTokenExist() {
        return this.getLaunchingToken().exists();
    }

    public void deleteLaunchToken() {
        this.deleteLaunchToken(false);
    }

    public void deleteLaunchToken(boolean removeCache) {
        FileUtils.deleteQuietly((File)this.launchingToken);
        FileUtils.deleteQuietly((File)this.launchedToken);
        this.launchedTokenJSON = null;
        if (removeCache) {
            launchTokens.remove(this.tokenKey);
        }
    }

    public boolean isLaunchTokenExist() {
        return this.launchedToken.exists();
    }

    public DataXJobWorker.K8SWorkerCptType getWorkerCptType() {
        return this.workerCptType;
    }

    public void appendJobNote(JSONObject note) {
        Objects.requireNonNull(this.notepadQueue, "notepadQueue can not be null").add(Objects.requireNonNull(note, "note can not be null"));
    }

    public void writeLaunchToken(IServerLaunchCallable bizLogic) {
        this.writeLaunchToken(false, bizLogic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLaunchToken(boolean isRelaunch, IServerLaunchCallable bizLogic) {
        block12: {
            if (this.writeLaunchTokenLock.compareAndSet(0, 1)) {
                try {
                    this.notepadQueue = new ArrayList<JSONObject>();
                    if (isRelaunch ^ this.isLaunchTokenExist()) {
                        throw TisException.create((String)("launch token :" + this.launchedToken.getPath() + " shall " + (isRelaunch ? "" : "not") + "  be exist"));
                    }
                    try {
                        Optional<JSONObject> t = Objects.requireNonNull(bizLogic.call(), "bizLogic can not be null");
                        JSONObject token = t.orElseGet(() -> new JSONObject());
                        ArrayList notes = Lists.newArrayList(this.notepadQueue);
                        JSONObject note = null;
                        for (int idx = 0; idx < notes.size(); ++idx) {
                            note = (JSONObject)notes.get(idx);
                            for (String key : note.keySet()) {
                                token.put(key, note.get((Object)key));
                            }
                        }
                        token.put("launchTime", (Object)TimeFormat.getCurrentTimeStamp());
                        token.put("cptType", (Object)this.workerCptType.token);
                        FileUtils.write((File)this.launchedToken, (CharSequence)JsonUtil.toString((Object)token, (boolean)true), (Charset)TisUTF8.get(), (boolean)false);
                        break block12;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        FileUtils.deleteQuietly((File)this.launchingToken);
                    }
                }
                finally {
                    this.notepadQueue = null;
                    this.writeLaunchTokenLock.decrementAndGet();
                }
            }
            throw new IllegalStateException("can not process this writeLaunchToken");
        }
    }

    public JSONObject readLaunchedToken() {
        try {
            if (this.launchedTokenJSON == null) {
                if (!this.isLaunchTokenExist()) {
                    throw new IllegalStateException("LaunchToken is not exist");
                }
                this.launchedTokenJSON = JSONObject.parseObject((String)FileUtils.readFileToString((File)this.launchedToken, (Charset)TisUTF8.get()));
            }
            return this.launchedTokenJSON;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void touchLaunchingToken() {
        try {
            FileUtils.touch((File)this.launchingToken);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLaunchingLine(String line) {
        try {
            ServerLaunchToken serverLaunchToken = this;
            synchronized (serverLaunchToken) {
                if (this.launchingWriter == null) {
                    this.launchingWriter = new PrintWriter(FileUtils.openOutputStream((File)this.launchingToken));
                }
                this.launchingWriter.println(line);
                this.launchingWriter.flush();
                this.notifyObservers(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Class<ServerLaunchToken> clazz = ServerLaunchToken.class;
        synchronized (ServerLaunchToken.class) {
            IOUtils.closeQuietly((Closeable)this.launchingWriter, null);
            launchTokens.remove((Object)this.workerCptType);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static enum FlinkClusterType {
        K8SApplication("k8s_application_"),
        K8SSession("k8s_session_"),
        K8SSessionReference("k8s_session_ref_"),
        Standalone("standalone_");

        private final String token;

        public static FlinkClusterType parse(String token) {
            for (FlinkClusterType type : FlinkClusterType.values()) {
                if (!type.token.equals(token)) continue;
                return type;
            }
            throw new IllegalStateException("invalid token:" + token);
        }

        public String getToken() {
            return this.token;
        }

        private FlinkClusterType(String token) {
            this.token = token;
        }
    }

    public static class FlinkClusterTokenManager {
        public static final String JSON_KEY_WEB_INTERFACE_URL = "webInterfaceURL";
        public static final String JSON_KEY_CLUSTER_ID = "clusterId";
        public static final String JSON_KEY_APP_NAME = "dataxName";
        public static final String JSON_KEY_CLUSTER_TYPE = "clusterType";
        public static final String JSON_KEY_K8S_NAMESPACE = "k8s_namespace";
        public static final String JSON_KEY_K8S_BASE_PATH = "k8s_base_path";
        public static final String JSON_KEY_K8S_ID = "k8s_id";
        public static final String JSON_KEY_LAUNCH_TIME = "launchTime";
        private List<FlinkClusterPojo> _clusters;
        final File flinkClusterParentDir;

        public FlinkClusterTokenManager() {
            this.flinkClusterParentDir = new File(Config.getMetaCfgDir(), DataXJobWorker.K8SWorkerCptType.FlinkCluster.token);
        }

        public ServerLaunchToken token(FlinkClusterType clusterType, TargetResName workerType) {
            return ServerLaunchToken.create(this.flinkClusterParentDir, new TargetResName(clusterType.token + workerType.getName()), false, DataXJobWorker.K8SWorkerCptType.FlinkCluster);
        }

        public void deleteFlinkSessionCluster(String clusterId) {
            ServerLaunchToken token = this.token(FlinkClusterType.K8SSession, new TargetResName(clusterId));
            token.deleteLaunchToken(true);
            this.cleanCache();
        }

        public void cleanCache() {
            this._clusters = null;
        }

        public List<FlinkClusterPojo> getAllFlinkSessionClusters() throws Exception {
            return this.getAllClusters().stream().filter(cluster -> cluster.clusterType == FlinkClusterType.K8SSession).collect(Collectors.toList());
        }

        private List<FlinkClusterPojo> getAllClusters() throws Exception {
            if (this._clusters == null) {
                String[] clusters = this.flinkClusterParentDir.list();
                if (clusters == null) {
                    return Collections.emptyList();
                }
                this._clusters = Lists.newLinkedList();
                FlinkClusterPojo c = null;
                JSONObject meta = null;
                File clusterFile = null;
                for (String cluster : clusters) {
                    clusterFile = new File(this.flinkClusterParentDir, cluster);
                    try {
                        c = new FlinkClusterPojo();
                        try {
                            meta = JSONObject.parseObject((String)FileUtils.readFileToString((File)clusterFile, (Charset)TisUTF8.get()));
                            if (meta == null) {
                            }
                        }
                        catch (Throwable e) {}
                        continue;
                        c.setClusterId(meta.getString(JSON_KEY_CLUSTER_ID));
                        c.setDataXName(meta.getString(JSON_KEY_APP_NAME));
                        c.setWebInterfaceURL(meta.getString(JSON_KEY_WEB_INTERFACE_URL));
                        c.setClusterType(FlinkClusterType.parse(StringUtils.defaultIfEmpty((String)meta.getString(JSON_KEY_CLUSTER_TYPE), (String)FlinkClusterType.Standalone.getToken())));
                        c.setK8sNamespace(meta.getString(JSON_KEY_K8S_NAMESPACE));
                        c.setK8sBasePath(meta.getString(JSON_KEY_K8S_BASE_PATH));
                        c.setK8sId(meta.getString(JSON_KEY_K8S_ID));
                        c.setCreateTime(meta.getLongValue(JSON_KEY_LAUNCH_TIME));
                        this._clusters.add(c);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(clusterFile.getAbsolutePath(), e);
                    }
                }
            }
            return this._clusters;
        }

        public FlinkClusterPojo find(FlinkClusterType clusterType, String clusterId) {
            if (StringUtils.isEmpty((String)clusterId)) {
                throw new IllegalArgumentException("param clusterId can not be empty");
            }
            try {
                for (FlinkClusterPojo cluster : this.getAllClusters()) {
                    if (cluster.clusterType != Objects.requireNonNull(clusterType) || !StringUtils.equals((String)cluster.getClusterId(), (String)clusterId)) continue;
                    return cluster;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    private static class LaunchTokenKey {
        private final TargetResName workerType;
        private final boolean launchTokenUseCptType;
        private final DataXJobWorker.K8SWorkerCptType workerCptType;

        public LaunchTokenKey(TargetResName workerType, boolean launchTokenUseCptType, DataXJobWorker.K8SWorkerCptType workerCptType) {
            this.workerType = workerType;
            this.launchTokenUseCptType = launchTokenUseCptType;
            this.workerCptType = workerCptType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LaunchTokenKey that = (LaunchTokenKey)o;
            return this.launchTokenUseCptType == that.launchTokenUseCptType && com.google.common.base.Objects.equal((Object)this.workerType.getName(), (Object)that.workerType.getName()) && this.workerCptType == that.workerCptType;
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.workerType.getName(), this.launchTokenUseCptType, this.workerCptType});
        }
    }
}

