/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.qlangtech.tis.datax.job.JobOrchestrateException;
import com.qlangtech.tis.datax.job.JobResName;
import com.qlangtech.tis.datax.job.SSERunnable;
import java.util.Objects;

public abstract class OwnerJobResName<T, RESULT>
extends JobResName<T> {
    private final JobResName.OwnerJobExec<T, RESULT> jobExec;

    public OwnerJobResName(String name, JobResName.OwnerJobExec<T, RESULT> jobExec) {
        super(name);
        this.jobExec = jobExec;
    }

    @Override
    protected final void execute(SSERunnable sse, T t) throws JobOrchestrateException {
        RESULT result = this.jobExec.accept(t);
        if (result != null) {
            sse.setContextAttr(SSEExecuteOwner.class, (Object)new SSEExecuteOwner(result));
        } else {
            sse.cleanContextAttr(SSEExecuteOwner.class);
        }
    }

    public static SSEExecuteOwner getSSEExecuteOwner() {
        SSERunnable sse = SSERunnable.getLocal();
        SSEExecuteOwner contextAttr = Objects.requireNonNull((SSEExecuteOwner)sse.getContextAttr(SSEExecuteOwner.class), "SSEExecuteOwner must be present");
        return contextAttr;
    }

    public static class SSEExecuteOwner {
        public final Object owner;

        public SSEExecuteOwner(Object owner) {
            this.owner = owner;
        }
    }
}

