/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.qlangtech.tis.coredefine.module.action.ResName;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.datax.job.JobOrchestrateException;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.SubJobResName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobResName<T>
extends TargetResName {
    private static final Logger logger = LoggerFactory.getLogger(JobResName.class);

    public JobResName(String name) {
        super(name);
    }

    public static <T> SubJobResName<T> createSubJob(final String jobName, final ThrowableConsumer<T> exec) {
        SubJobResName created = new SubJobResName<T>(jobName, new SubJobExec<T>(){

            @Override
            public void accept(T dto) throws JobOrchestrateException {
                exec.accept(dto);
            }
        }){

            @Override
            protected String getResourceType() {
                return jobName;
            }
        };
        return created;
    }

    public final void execSubJob(T t) throws JobOrchestrateException {
        SSERunnable sse = SSERunnable.getLocal();
        boolean success = false;
        try {
            sse.info(this.getName(), TimeFormat.getCurrentTimeStamp(), "\u3007\u3007 start to publish " + this.getResourceType() + "'" + this.getName() + "'");
            this.execute(sse, t);
            success = true;
            sse.info(this.getName(), TimeFormat.getCurrentTimeStamp(), "\u2714\u2714 successful to publish " + this.getResourceType() + "'" + this.getName() + "'");
        }
        catch (JobOrchestrateException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (!success) {
                sse.info(this.getName(), TimeFormat.getCurrentTimeStamp(), "\u2715\u2715 faild to publish " + this.getResourceType() + "'" + this.getName() + "'");
            }
            sse.writeComplete((ResName)this, success);
        }
    }

    protected abstract void execute(SSERunnable var1, T var2) throws JobOrchestrateException;

    protected abstract String getResourceType();

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws JobOrchestrateException;
    }

    public static interface SubJobExec<T> {
        public void accept(T var1) throws JobOrchestrateException;
    }

    public static interface OwnerJobExec<T, RESULT> {
        public RESULT accept(T var1) throws JobOrchestrateException;
    }
}

