/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.job.JobResName;
import com.qlangtech.tis.datax.job.SubJobMilestone;
import com.qlangtech.tis.datax.job.SubJobResName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface ILaunchingOrchestrate<T> {
    public String getTaskName();

    public List<ExecuteStep<T>> getExecuteSteps();

    public static <TT> ILaunchingOrchestrate<TT> create(final String taskName, final SubJobResName ... flinkDeployRes) {
        if (StringUtils.isEmpty((CharSequence)taskName)) {
            throw new IllegalArgumentException("param taskName can not be empty");
        }
        return new ILaunchingOrchestrate(){

            @Override
            public String getTaskName() {
                return taskName;
            }

            public List<ExecuteStep<TT>> getExecuteSteps() {
                ArrayList launchSteps = Lists.newArrayList();
                for (SubJobResName rcRes : flinkDeployRes) {
                    launchSteps.add(new ExecuteStep(rcRes, null));
                }
                return launchSteps;
            }
        };
    }

    default public ExecuteSteps createExecuteSteps(Object owner) {
        return new ExecuteSteps(this.getTaskName(), owner, this.getExecuteSteps());
    }

    public static class ExecuteStep<T>
    extends SubJobMilestone {
        private final JobResName<T> subJob;

        public ExecuteStep(JobResName<T> resName, String describe) {
            this(resName, describe, false, false);
        }

        public ExecuteStep(JobResName<T> name, String describe, boolean complete, boolean success) {
            super(name.getName(), describe, complete, success);
            this.subJob = name;
        }

        public JobResName<T> getSubJob() {
            return this.subJob;
        }

        public ExecuteStep<T> copy(SubJobMilestone subJobStone) {
            ExecuteStep<T> step = new ExecuteStep<T>(this.subJob, this.getDescribe(), subJobStone.isComplete(), subJobStone.isSuccess());
            return step;
        }

        public ExecuteStep<T> copy() {
            return new ExecuteStep<T>(this.subJob, this.getDescribe(), this.isComplete(), this.isSuccess());
        }
    }

    public static class ExecuteSteps {
        private final List<ExecuteStep> executeSteps;
        private final String taskName;

        public String getTaskName() {
            return this.taskName;
        }

        public List<ExecuteStep> getExecuteSteps() {
            return this.executeSteps;
        }

        public ExecuteSteps(String taskName, Object owner, List<? extends ExecuteStep> executeSteps) {
            this.executeSteps = executeSteps;
            this.taskName = Objects.requireNonNull(taskName, "param taskName can not be null");
            if (CollectionUtils.isEmpty(this.executeSteps)) {
                throw new IllegalStateException("executeSteps can not be empty,owner:" + Objects.requireNonNull(owner, "owner can not be null").getClass().getName());
            }
        }
    }
}

