/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.coredefine.module.action.ResName;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.SSEEventWriter;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchLog;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.datax.job.SubJobMilestone;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.trigger.socket.InfoType;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;

public class DefaultSSERunnable
implements SSERunnable {
    private final SSEEventWriter httpClientWriter;
    private final Runnable runnable;
    private Optional<ServerLaunchToken> launchToken = Optional.empty();
    private final ILaunchingOrchestrate.ExecuteSteps executeSteps;

    public DefaultSSERunnable(IControlMsgHandler controlHandler, ILaunchingOrchestrate.ExecuteSteps executeSteps, Runnable runnable) {
        this(controlHandler.getEventStreamWriter(), executeSteps, runnable);
    }

    public DefaultSSERunnable(SSEEventWriter clientWriter, ILaunchingOrchestrate.ExecuteSteps executeSteps, Runnable runnable) {
        SSERunnable.setLocalThread((SSERunnable)this);
        this.httpClientWriter = clientWriter;
        this.runnable = runnable;
        this.executeSteps = executeSteps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static k8SLaunching execute(DefaultSSERunnable launchProcess, boolean inService, ServerLaunchToken launchToken, Runnable runnable) {
        k8SLaunching k8SLaunching2 = launchProcess.hasLaunchingToken(launchToken);
        launchProcess.writeExecuteSteps(k8SLaunching2.launchWALLog.executeSteps);
        if (inService) {
            for (SubJobLog subJobLog : k8SLaunching2.getLogs()) {
                launchProcess.writeHistoryLog(subJobLog);
            }
            return k8SLaunching2;
        }
        if (k8SLaunching2.isLaunching()) {
            if (k8SLaunching2.isFaild()) {
                for (SubJobLog subJobLog : k8SLaunching2.getLogs()) {
                    launchProcess.writeHistoryLog(subJobLog);
                }
                return k8SLaunching2;
            }
            if (launchToken.hasWriteOwner()) {
                launchToken.addObserver(k8SLaunching2);
                return k8SLaunching2;
            }
        }
        try {
            launchProcess.setLaunchToken(launchToken);
            launchProcess.startLaunch();
            runnable.run();
            k8SLaunching k8SLaunching3 = null;
            return k8SLaunching3;
        }
        finally {
            launchProcess.terminate();
        }
    }

    public k8SLaunching hasLaunchingToken(ServerLaunchToken launchToken) {
        ServerLaunchLog launchWALLog = launchToken.buildWALLog(this.executeSteps);
        k8SLaunching k8SLaunching2 = new k8SLaunching(launchWALLog);
        if (!k8SLaunching2.launchWALLog.isLaunchingTokenExist()) {
            return k8SLaunching2;
        }
        return k8SLaunching2;
    }

    public void terminate() {
        try {
            ServerLaunchToken launchToken = this.launchToken.get();
            launchToken.setWriteOwner(null);
            launchToken.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setLaunchToken(ServerLaunchToken launchToken) {
        this.launchToken = Optional.of(launchToken);
        launchToken.setWriteOwner(this);
    }

    public void startLaunch() {
        this.launchToken.get().touchLaunchingToken();
    }

    public void writeExecuteSteps(ILaunchingOrchestrate.ExecuteSteps executeSteps) {
        JSONObject body = new JSONObject();
        JSONArray steps = SubJobMilestone.createSubJobJSONArray(Objects.requireNonNull(executeSteps, "executeSteps can not be null").getExecuteSteps());
        body.put("steps", (Object)steps);
        body.put("taskName", (Object)executeSteps.getTaskName());
        this.writeMessage(SSERunnable.SSEEventType.TASK_EXECUTE_STEPS, JsonUtil.toString((Object)body, (boolean)false));
    }

    public void writeComplete(ResName subJob, boolean success) {
        JSONObject m = SubJobMilestone.createMilestoneJson(subJob.getName(), Optional.empty(), true, success);
        this.writeMessage(SSERunnable.SSEEventType.TASK_MILESTONE, JsonUtil.toString((Object)m, (boolean)false));
    }

    public void info(String serviceName, long timestamp, String msg) {
        this.writeMessage(InfoType.INFO, timestamp, msg);
    }

    public void writeHistoryLog(SubJobLog subJobLog) {
        if (subJobLog == null) {
            return;
        }
        this.writeMessage(subJobLog.getLogLevel(), subJobLog.getTimestamp(), subJobLog.getMsg());
    }

    private void writeMessage(InfoType logLevel, long timestamp, String msg) {
        JSONObject m = SubJobLog.createSubJobLog(logLevel, timestamp, msg);
        this.writeMessage(SSERunnable.SSEEventType.TASK_LOG, JsonUtil.toString((Object)m, (boolean)false));
    }

    private void writeMessage(SSERunnable.SSEEventType event, Object data) {
        this.httpClientWriter.writeSSEEvent(event, String.valueOf(data));
        this.launchToken.ifPresent(lt -> lt.appendLaunchingLine(event.getEventType() + "\u0005" + data));
    }

    public void error(String serviceName, long timestamp, String msg) {
        this.writeMessage(InfoType.ERROR, timestamp, msg);
    }

    public void fatal(String serviceName, long timestamp, String msg) {
        this.writeMessage(InfoType.ERROR, timestamp, msg);
    }

    public void run() {
        this.runnable.run();
    }

    public static class SubJobLog {
        private final InfoType logLevel;
        private final long timestamp;
        private final String msg;

        private SubJobLog(InfoType logLevel, long timestamp, String msg) {
            this.logLevel = logLevel;
            this.timestamp = timestamp;
            this.msg = msg;
        }

        public static JSONObject createSubJobLog(InfoType logLevel, long timestamp, String msg) {
            JSONObject m = new JSONObject();
            m.put("level", (Object)logLevel.getToken());
            m.put("time", (Object)timestamp);
            m.put("msg", (Object)msg);
            return m;
        }

        public static SubJobLog readSubJobLog(String data) {
            JSONObject j = JSONObject.parseObject((String)data);
            return new SubJobLog(InfoType.getType((String)j.getString("level")), j.getLongValue("time"), j.getString("msg"));
        }

        public InfoType getLogLevel() {
            return this.logLevel;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    public class k8SLaunching
    implements Observer {
        public final ServerLaunchLog launchWALLog;
        private final List<ILaunchingOrchestrate.ExecuteStep> executeSteps;

        public k8SLaunching(ServerLaunchLog launchWALLog) {
            this.launchWALLog = launchWALLog;
            this.executeSteps = launchWALLog.getExecuteSteps();
        }

        public boolean isLaunching() {
            boolean complete = true;
            if (CollectionUtils.isEmpty(this.executeSteps)) {
                throw new IllegalStateException("executeSteps can not be empty");
            }
            for (ILaunchingOrchestrate.ExecuteStep step : this.executeSteps) {
                if (step.isComplete()) continue;
                complete = false;
            }
            return this.launchWALLog.isLaunchingTokenExist() && !complete;
        }

        public List<SubJobMilestone> getMilestones() {
            return this.launchWALLog.getMilestones();
        }

        public SubJobLog[] getLogs() {
            return this.launchWALLog.getLogs();
        }

        public List<ILaunchingOrchestrate.ExecuteStep> getExecuteSteps() {
            return this.executeSteps;
        }

        public boolean isFaild() {
            return this.launchWALLog.isFaild();
        }

        @Override
        public void update(Observable o, Object arg) {
            String line = (String)arg;
            ServerLaunchToken.processLaunchWALLine(line, new LaunchWALLineVisitor(){

                @Override
                public void process(SubJobLog jobLog) {
                    DefaultSSERunnable.this.writeHistoryLog(jobLog);
                }

                @Override
                public void process(SubJobMilestone stone) {
                    DefaultSSERunnable.this.writeComplete((ResName)new TargetResName(stone.getName()), stone.isSuccess());
                }
            });
        }
    }

    static interface LaunchWALLineVisitor {
        public void process(SubJobLog var1);

        public void process(SubJobMilestone var1);
    }
}

