/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.job;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.config.k8s.HorizontalpodAutoscaler;
import com.qlangtech.tis.config.k8s.ReplicasSpec;
import com.qlangtech.tis.coredefine.module.action.RcHpaStatus;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.coredefine.module.action.impl.RcDeployment;
import com.qlangtech.tis.datax.job.FlinkSessionResName;
import com.qlangtech.tis.datax.job.ILaunchingOrchestrate;
import com.qlangtech.tis.datax.job.SSERunnable;
import com.qlangtech.tis.datax.job.ServerLaunchToken;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.incr.WatchPodLog;
import com.qlangtech.tis.plugin.k8s.K8sImage;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.qlangtech.tis.util.HeteroEnum;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

@Public
public abstract class DataXJobWorker
implements Describable<DataXJobWorker> {
    protected static final String CLUSTER_ENTRYPOINT_HOST = "server_port_host";
    public static final String KEY_FIELD_NAME = "k8sImage";
    public static final String KEY_WORKER_TYPE = "workerType";
    public static final String GROUP_KEY_JOBWORKER = "jobworker";
    public static final String KEY_CPT_TYPE = "cptType";
    public static final FlinkSessionResName K8S_FLINK_CLUSTER_NAME = new FlinkSessionResName();
    @FormField(ordinal=1, type=FormFieldType.SELECTABLE, validate={Validator.require})
    public String k8sImage;
    private ReplicasSpec replicasSpec;
    private HorizontalpodAutoscaler hpa;

    public static ILaunchingOrchestrate getOrchestrate(DataXJobWorker dataXWorker) {
        if (!DataXJobWorker.isOrchestrate(dataXWorker)) {
            throw new IllegalArgumentException("dataXWorker must be type of " + ILaunchingOrchestrate.class.getName());
        }
        return (ILaunchingOrchestrate)((Object)dataXWorker);
    }

    public static boolean isOrchestrate(DataXJobWorker dataXWorker) {
        return Objects.requireNonNull(dataXWorker, "dataXWorker can not be null") instanceof ILaunchingOrchestrate;
    }

    public void updatePodNumber(SSERunnable sseRunnable, TargetResName cptType, Integer podNum) {
        throw new UnsupportedOperationException();
    }

    public static void validateTargetName(String targetName) {
        if (TargetResName.K8S_DATAX_INSTANCE_NAME.getName().equals(targetName) || K8S_FLINK_CLUSTER_NAME.match(targetName)) {
            return;
        }
        throw new IllegalArgumentException("targetName:" + targetName + " is illegal");
    }

    public static <K8SDataXPowerJobWorker extends DataXJobWorker> K8SDataXPowerJobWorker getK8SDataXPowerJobWorker() {
        return (K8SDataXPowerJobWorker)DataXJobWorker.getJobWorker(TargetResName.K8S_DATAX_INSTANCE_NAME, Optional.of(K8SWorkerCptType.Worker));
    }

    public static DataXJobWorker getJobWorker(TargetResName resName) {
        Optional<ServerLaunchToken> token = DataXJobWorker.getLaunchToken(resName);
        Optional<K8SWorkerCptType> powerjobCptType = token.map(t -> t.workerCptType);
        if (!powerjobCptType.isPresent()) {
            throw new IllegalStateException("resName:" + resName.getName() + " relevant powerjobCptType can not be empty");
        }
        return DataXJobWorker.getJobWorker(resName, powerjobCptType);
    }

    public static DataXJobWorker getJobWorker(TargetResName resName, Optional<K8SWorkerCptType> powerjobCptType) {
        if (DataXJobWorker.notMatchK8SDataXAndFlinkCluster(resName)) {
            throw new IllegalStateException("illegal resName:" + resName);
        }
        IPluginStore<DataXJobWorker> dataxJobWorkerStore = DataXJobWorker.getJobWorkerStore(resName, powerjobCptType);
        return dataxJobWorkerStore.getPlugin();
    }

    public static IPluginStore<DataXJobWorker> getFlinkKubernetesApplicationCfgStore() {
        return DataXJobWorker.getJobWorkerStore(K8S_FLINK_CLUSTER_NAME.group(), Optional.of(K8SWorkerCptType.FlinkKubernetesApplicationCfg));
    }

    public static IPluginStore<DataXJobWorker> getJobWorkerStore(TargetResName resName, Optional<K8SWorkerCptType> powerjobCptType) {
        if (DataXJobWorker.notMatchK8SDataXAndFlinkCluster(resName)) {
            throw new IllegalStateException("illegal resName:" + resName);
        }
        return TIS.getPluginStore(new KeyedPluginStore.Key<DataXJobWorker>(GROUP_KEY_JOBWORKER, new KeyedPluginStore.KeyVal(resName.getName(), powerjobCptType.map(type -> type.storeSuffix).map(storeSuffix -> "-" + storeSuffix).orElse("")){

            @Override
            public String getKeyVal() {
                return this.getVal() + this.suffix;
            }
        }, DataXJobWorker.class));
    }

    public static boolean notMatchK8SDataXAndFlinkCluster(TargetResName resName) {
        return !resName.equalWithName(TargetResName.K8S_DATAX_INSTANCE_NAME.getName()) && !K8S_FLINK_CLUSTER_NAME.match(resName);
    }

    public static void setJobWorker(TargetResName resName, Optional<K8SWorkerCptType> powerjobCptType, DataXJobWorker worker) {
        IPluginStore<DataXJobWorker> store = DataXJobWorker.getJobWorkerStore(resName, powerjobCptType);
        store.setPlugins(null, Optional.empty(), Collections.singletonList(PluginStore.getDescribablesWithMeta(store, worker)));
    }

    public static List<Descriptor<DataXJobWorker>> getDesc(TargetResName resName) {
        return HeteroEnum.DATAX_WORKER.descriptors().stream().map(d -> d).filter(desc -> DataXJobWorker.isJobWorkerMatch(resName, desc)).collect(Collectors.toList());
    }

    private static boolean isJobWorkerMatch(TargetResName targetName, Descriptor<DataXJobWorker> desc) {
        return targetName.getName().equals(desc.getExtractProps().get(KEY_WORKER_TYPE));
    }

    public boolean inService() {
        return this.getProcessTokenFile().isLaunchTokenExist();
    }

    protected void deleteLaunchToken() {
        this.getProcessTokenFile().deleteLaunchToken();
    }

    public ServerLaunchToken getProcessTokenFile() {
        BasicDescriptor basicDesc = Objects.requireNonNull((BasicDescriptor)this.getDescriptor(), "basicDesc can not be null");
        return this.getProcessTokenFile(basicDesc.getWorkerType(), false, basicDesc.getWorkerCptType());
    }

    public ServerLaunchToken getProcessTokenFile(TargetResName workerType, boolean launchTokenUseCptType, K8SWorkerCptType cptType) {
        BasicDescriptor basicDesc = Objects.requireNonNull((BasicDescriptor)this.getDescriptor(), "basicDesc can not be null");
        IPluginStore<DataXJobWorker> workerStore = basicDesc.getJobWorkerStore();
        File target = workerStore.getTargetFile().getFile();
        return ServerLaunchToken.create(target.getParentFile().getParentFile(), workerType, launchTokenUseCptType, cptType);
    }

    public static Optional<ServerLaunchToken> getLaunchToken(TargetResName workerType) {
        return DataXJobWorker.getLaunchToken(workerType, Optional.empty());
    }

    public static Optional<ServerLaunchToken> getLaunchToken(TargetResName workerType, K8SWorkerCptType cptType) {
        return DataXJobWorker.getLaunchToken(workerType, Optional.of(cptType));
    }

    private static Optional<ServerLaunchToken> getLaunchToken(TargetResName workerType, Optional<K8SWorkerCptType> cptType) {
        if (K8S_FLINK_CLUSTER_NAME.match(workerType)) {
            ServerLaunchToken flinkClusterToken = ServerLaunchToken.createFlinkClusterToken().token(ServerLaunchToken.FlinkClusterType.K8SSession, K8S_FLINK_CLUSTER_NAME.resName(workerType));
            return Optional.ofNullable(flinkClusterToken.isLaunchTokenExist() ? flinkClusterToken : null);
        }
        File parent = new File(TIS.pluginCfgRoot, GROUP_KEY_JOBWORKER);
        boolean launchTokenUseCptType = cptType.isPresent();
        File tokenFile = new File(parent, LaunchToken.SUCCESS_COMPLETE.getTokenFileName(workerType, launchTokenUseCptType, cptType.orElse(null)));
        try {
            if (!tokenFile.exists()) {
                return Optional.empty();
            }
            JSONObject content = JSONObject.parseObject((String)FileUtils.readFileToString((File)tokenFile, (Charset)TisUTF8.get()));
            return Optional.of(ServerLaunchToken.create(parent, workerType, launchTokenUseCptType, cptType.orElseGet(() -> K8SWorkerCptType.parse(content.getString(KEY_CPT_TYPE)))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void relaunch();

    public abstract void relaunch(String var1);

    public abstract List<RcDeployment> getRCDeployments();

    public Map<String, Object> getPayloadInfo() {
        return Collections.emptyMap();
    }

    public abstract RcHpaStatus getHpaStatus();

    public abstract WatchPodLog listPodAndWatchLog(String var1, ILogListener var2);

    protected <T extends K8sImage> T getK8SImage() {
        K8sImage k8sImage = this.getK8SImageCategory().getPluginStore().find(Objects.requireNonNull(this.k8sImage, "k8sImage can not be null"));
        Objects.requireNonNull(k8sImage, "k8sImage:" + this.k8sImage + " can not be null");
        return (T)k8sImage;
    }

    protected K8sImage.ImageCategory getK8SImageCategory() {
        return K8sImage.ImageCategory.DEFAULT_DESC_NAME;
    }

    public HorizontalpodAutoscaler getHpa() {
        return this.hpa;
    }

    public void setHpa(HorizontalpodAutoscaler hpa) {
        this.hpa = hpa;
    }

    protected boolean supportHPA() {
        return this.hpa != null;
    }

    public ReplicasSpec getReplicasSpec() {
        return this.replicasSpec;
    }

    public void setReplicasSpec(ReplicasSpec replicasSpec) {
        this.replicasSpec = replicasSpec;
    }

    public abstract void remove();

    public final void executeLaunchService(SSERunnable launchProcess) {
        ServerLaunchToken launchToken = this.getProcessTokenFile();
        launchToken.writeLaunchToken(() -> this.launchService(launchProcess));
        launchProcess.afterLaunched();
    }

    protected abstract Optional<JSONObject> launchService(SSERunnable var1);

    @Override
    public Descriptor<DataXJobWorker> getDescriptor() {
        return TIS.get().getDescriptor(this.getClass());
    }

    protected static abstract class BasicDescriptor
    extends Descriptor<DataXJobWorker> {
        public BasicDescriptor() {
            this.registerSelectOptions(DataXJobWorker.KEY_FIELD_NAME, () -> {
                IPluginStore<K8sImage> pluginStore = this.getK8SImageCategory().getPluginStore();
                return pluginStore.getPlugins();
            });
        }

        protected K8sImage.ImageCategory getK8SImageCategory() {
            return K8sImage.ImageCategory.DEFAULT_DESC_NAME;
        }

        @Override
        public final String getDisplayName() {
            return this.getWorkerCptType().token;
        }

        public abstract K8SWorkerCptType getWorkerCptType();

        @Override
        public Map<String, Object> getExtractProps() {
            Map<String, Object> extractProps = super.getExtractProps();
            extractProps.put(DataXJobWorker.KEY_WORKER_TYPE, this.getWorkerType().getName());
            return extractProps;
        }

        protected abstract TargetResName getWorkerType();

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return true;
        }

        public IPluginStore<DataXJobWorker> getJobWorkerStore() {
            return DataXJobWorker.getJobWorkerStore(this.getWorkerType(), Optional.of(K8SWorkerCptType.parse(this.getDisplayName())));
        }
    }

    static enum LaunchToken {
        DOING(".launching_token"),
        SUCCESS_COMPLETE(".launched_token");

        private final String token;

        private LaunchToken(String token) {
            this.token = token;
        }

        public File getTokenFile(File parent, TargetResName workerType, boolean launchTokenUseCptType, K8SWorkerCptType workerCptType) {
            return new File(parent, this.getTokenFileName(workerType, launchTokenUseCptType, workerCptType));
        }

        public String getTokenFileName(TargetResName workerType, boolean launchTokenUseCptType, K8SWorkerCptType workerCptType) {
            return workerType.getName() + (String)(launchTokenUseCptType ? "-" + Objects.requireNonNull(workerCptType.token) : "") + this.token;
        }
    }

    public static enum K8SWorkerCptType {
        Server("powerjob-server", null),
        Worker("powerjob-worker"),
        JobTpl("powerjob-job-tpl"),
        JobTplAppOverwrite("powerjob-job-tpl-app-overwrite"),
        UsingExistCluster("powerjob-use-exist-cluster", null),
        FlinkCluster("flink-cluster", null),
        FlinkKubernetesApplicationCfg("flink-kubernetes-application-cfg"),
        K8SPods("k8s-pods");

        public final String token;
        public final String storeSuffix;

        private K8SWorkerCptType(String token) {
            this(token, token);
        }

        private K8SWorkerCptType(String token, String storeSuffix) {
            this.token = token;
            this.storeSuffix = storeSuffix;
        }

        public static K8SWorkerCptType parse(String cptType) {
            for (K8SWorkerCptType type : K8SWorkerCptType.values()) {
                if (!type.token.equalsIgnoreCase(cptType)) continue;
                return type;
            }
            throw new IllegalStateException("param cptType:" + cptType + " is not illegal");
        }
    }
}

