/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.ds.CMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ESTableAlias
extends IDataxProcessor.TableMap {
    public static final String KEY_COLUMN = "column";
    public static final String MAX_READER_TABLE_SELECT_COUNT = "maxReaderTableCount";
    private final String schemaContent;

    public ESTableAlias(String schemaContent) {
        super(ESTableAlias.parseSourceCols(schemaContent));
        this.schemaContent = schemaContent;
    }

    @Override
    protected List<CMeta> rewriteCols(List<CMeta> cmetas) {
        return cmetas;
    }

    @Override
    public List<String> getPrimaryKeys() {
        return this.getSourceCols().stream().filter(col -> col.isPk()).map(col -> col.getName()).collect(Collectors.toList());
    }

    private static List<CMeta> parseSourceCols(String schemaContent) {
        ArrayList colsMeta = Lists.newArrayList();
        CMeta colMeta = null;
        JSONArray cols = ESTableAlias.getSchemaCols(schemaContent);
        JSONObject col = null;
        for (int i = 0; i < cols.size(); ++i) {
            col = cols.getJSONObject(i);
            colMeta = new CMeta();
            colMeta.setName(col.getString("name"));
            colMeta.setPk(col.getBoolean("pk"));
            colsMeta.add(colMeta);
        }
        return colsMeta;
    }

    private static JSONObject getSchema(String schemaContent) {
        if (StringUtils.isEmpty((String)schemaContent)) {
            throw new IllegalStateException("schemaContent can not be empty");
        }
        return JSON.parseObject((String)schemaContent);
    }

    public static JSONArray getSchemaCols(String schemaContent) {
        JSONObject schema = ESTableAlias.getSchema(schemaContent);
        JSONArray cols = schema.getJSONArray(KEY_COLUMN);
        return cols;
    }

    public byte[] getSchemaByteContent() {
        return this.schemaContent.getBytes(TisUTF8.get());
    }

    public String getSchemaContent() {
        return this.schemaContent;
    }
}

