/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.alibaba.datax.core.job.IJobContainerContext;
import com.alibaba.datax.core.job.ISourceTable;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.ElementPluginDesc;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.plugin.IDataXEndTypeGetter;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.ds.DataSourceFactory;
import com.qlangtech.tis.plugin.ds.IDataSourceFactoryGetter;
import com.qlangtech.tis.plugin.ds.IInitWriterTableExecutor;
import com.qlangtech.tis.plugin.ds.TableInDB;
import com.qlangtech.tis.util.IPluginContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

@Public
public abstract class DataxWriter
implements Describable<DataxWriter>,
IDataxWriter {
    private static transient LoadingCache<String, TableInDB> tabsInDBCache;
    public static IDataxWriterGetter dataxWriterGetter;

    private TableInDB getExistTabsInSink(String dataXName) throws ExecutionException {
        TableInDB result;
        if (tabsInDBCache == null) {
            tabsInDBCache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, TableInDB>(){

                public TableInDB load(String dataXName) throws Exception {
                    IDataSourceFactoryGetter writer = (IDataSourceFactoryGetter)((Object)DataxWriter.this);
                    DataSourceFactory ds = writer.getDataSourceFactory();
                    return ds.getTablesInDB();
                }
            });
        }
        if ((result = (TableInDB)tabsInDBCache.get((Object)dataXName)) == null) {
            throw new IllegalStateException("dataXName:" + dataXName + " relevant Sink end dataSource refects tables can not be null");
        }
        return result;
    }

    public static void process(IJobContainerContext containerContext, String sinkTableName, List<String> jdbcUrls) throws Exception {
        DataXName dataXName = containerContext.getTISDataXName();
        if (dataXName == null) {
            throw new IllegalArgumentException("param dataXName can not be null");
        }
        DataxWriter writer = DataxWriter.load(null, dataXName.getType(), dataXName.getPipelineName(), true);
        IInitWriterTableExecutor dataXWriter = (IInitWriterTableExecutor)((Object)writer);
        Objects.requireNonNull(dataXWriter, "dataXWriter can not be null,dataXName:" + dataXName);
        dataXWriter.initWriterTable((ISourceTable)containerContext, sinkTableName, jdbcUrls);
    }

    public static KeyedPluginStore<DataxWriter> getPluginStore(IPluginContext context, String appname) {
        return DataxWriter.getPluginStore(context, StoreResourceType.DataApp, appname);
    }

    public static KeyedPluginStore<DataxWriter> getPluginStore(IPluginContext context, StoreResourceType resType, String name) {
        return TIS.dataXWriterPluginStore.get(DataxWriter.createDataXWriterKey(context, resType, name));
    }

    public static void cleanPluginStoreCache(IPluginContext context, DataXName appname) {
        TIS.dataXWriterPluginStore.clear(DataxWriter.createDataXWriterKey(context, appname.getType(), appname.getPipelineName()));
    }

    private static KeyedPluginStore.AppKey createDataXWriterKey(IPluginContext context, String appname) {
        return DataxWriter.createDataXWriterKey(context, StoreResourceType.DataApp, appname);
    }

    private static KeyedPluginStore.AppKey createDataXWriterKey(IPluginContext context, StoreResourceType resType, String appname) {
        if (StringUtils.isEmpty((String)appname)) {
            throw new IllegalArgumentException("param appname can not be null");
        }
        return new KeyedPluginStore.AppKey<DataxWriter>(context, resType, appname, DataxWriter.class);
    }

    public static DataxWriter load(IPluginContext context, DataXName appName) {
        return DataxWriter.load(context, appName.getType(), appName.getPipelineName(), true);
    }

    public static DataxWriter load(IPluginContext context, String appName) {
        return DataxWriter.load(context, StoreResourceType.DataApp, appName, true);
    }

    public static DataxWriter load(IPluginContext context, String appName, boolean nullValidate) {
        return DataxWriter.load(context, StoreResourceType.DataApp, appName, nullValidate);
    }

    public static DataxWriter load(IPluginContext context, StoreResourceType resType, String appName, boolean nullValidate) {
        DataxWriter appSource = null;
        appSource = dataxWriterGetter != null ? dataxWriterGetter.get(appName) : (DataxWriter)DataxWriter.getPluginStore(context, resType, appName).getPlugin();
        if (nullValidate) {
            Objects.requireNonNull(appSource, "appName:" + appName + ",resType:" + resType + " relevant appSource can not be null");
        }
        return appSource;
    }

    @Override
    public BaseDataxWriterDescriptor getWriterDescriptor() {
        return (BaseDataxWriterDescriptor)this.getDescriptor();
    }

    @Override
    public final Descriptor<DataxWriter> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getOwnerClass());
        Class expectClazz = this.getExpectDescClass();
        if (!expectClazz.isAssignableFrom(descriptor.getClass())) {
            throw new IllegalStateException(descriptor.getClass() + " must implement the Descriptor of " + expectClazz.getName());
        }
        return descriptor;
    }

    protected <TT extends BaseDataxWriterDescriptor> Class<TT> getExpectDescClass() {
        return BaseDataxWriterDescriptor.class;
    }

    public static abstract class BaseDataxWriterDescriptor
    extends Descriptor<DataxWriter>
    implements IDataXEndTypeGetter {
        @Override
        public IEndTypeGetter.PluginVender getVender() {
            return IEndTypeGetter.PluginVender.DATAX;
        }

        @Override
        public final Map<String, Object> getExtractProps() {
            Map<String, Object> eprops = super.getExtractProps();
            eprops.put("supportMultiTable", this.isSupportMultiTable());
            eprops.put("rdbms", this.isRdbms());
            eprops.put("createDDL", this.isSupportTabCreate());
            eprops.put("supportIncr", this.isSupportIncr());
            eprops.put("supportBatch", this.isSupportBatch());
            return eprops;
        }

        @Override
        public boolean isSupportBatch() {
            return true;
        }

        public boolean isSupportMultiTable() {
            return true;
        }

        public abstract boolean isRdbms();

        public boolean isSupportTabCreate() {
            return false;
        }
    }

    public static interface IRewriteSuFormProperties {
        public static final ConcurrentHashMap<Class, SuFormProperties> rewriteSubFormProperties = new ConcurrentHashMap();

        public <TAB extends SelectedTab> Descriptor<TAB> getRewriterSelectTabDescriptor();

        default public SuFormProperties overwriteSubPluginFormPropertyType(SuFormProperties subformProps) throws Exception {
            Descriptor newSubDescriptor = this.getRewriterSelectTabDescriptor();
            if (newSubDescriptor == null) {
                return null;
            }
            return rewriteSubFormProperties.computeIfAbsent(this.getClass(), clazz -> {
                SuFormProperties rewriteSubFormProperties = SuFormProperties.copy(PropertyType.filterFieldProp(PropertyType.buildPropertyTypes(ElementPluginDesc.create(newSubDescriptor), newSubDescriptor.clazz)), newSubDescriptor.clazz, newSubDescriptor, subformProps);
                return rewriteSubFormProperties;
            });
        }
    }

    public static interface IDataxWriterGetter {
        public DataxWriter get(String var1);
    }
}

