/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.alibaba.datax.plugin.writer.hdfswriter.HdfsColMeta;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.common.utils.Assert;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IGroupChildTaskIterator;
import com.qlangtech.tis.datax.IStreamTableMeta;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.datax.impl.DataXBasicProcessMeta;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.PluginFormProperties;
import com.qlangtech.tis.extension.SubFormFilter;
import com.qlangtech.tis.extension.impl.BaseSubFormProperties;
import com.qlangtech.tis.extension.impl.EnumFieldMode;
import com.qlangtech.tis.extension.impl.IncrSourceExtendSelected;
import com.qlangtech.tis.extension.impl.PropertyType;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.plugin.CompanionPluginFactory;
import com.qlangtech.tis.plugin.IDataXEndTypeGetter;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.datax.SelectedTabExtend;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.plugin.incr.ISelectedTabExtendFactory;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import com.qlangtech.tis.util.HeteroEnum;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public abstract class DataxReader
implements Describable<DataxReader>,
IDataxReader,
IPluginStore.RecyclableController {
    private static final Logger logger = LoggerFactory.getLogger(DataxReader.class);
    public static final String HEAD_KEY_REFERER = "Referer";
    public static final String SUB_PROP_FIELD_NAME = "selectedTabs";
    public static final ThreadLocal<DataxReader> dataxReaderThreadLocal = new ThreadLocal();
    private transient LoadingCache<String, IStreamTableMeta> tabMetaCache;
    public static IDataxReaderGetter dataxReaderGetter;
    private transient boolean dirty = false;

    public static DataxReader getThreadBingDataXReader() {
        DataxReader reader = dataxReaderThreadLocal.get();
        return reader;
    }

    public static <T extends DataxReader> T getDataxReader(SubFormFilter filter) {
        return DataxReader.getDataxReader(filter.uploadPluginMeta);
    }

    public static <T extends DataxReader> T getDataxReader(UploadPluginMeta uploadPluginMeta) {
        IPluginStore<?> pluginStore = HeteroEnum.getDataXReaderAndWriterStore(uploadPluginMeta.getPluginContext(), true, uploadPluginMeta);
        DataxReader reader = (DataxReader)pluginStore.getPlugin();
        if (reader == null) {
            throw new IllegalStateException("dataXReader can not be null:" + uploadPluginMeta.toString());
        }
        return (T)reader;
    }

    public static Optional<Descriptor<SelectedTabExtend>> getBatchSourceSelectedTabExtendDescriptor(UploadPluginMeta uploadPluginMeta) {
        Object dataxReader = DataxReader.getDataxReader(uploadPluginMeta);
        Descriptor<DataxReader> descriptor = ((DataxReader)dataxReader).getDescriptor();
        if (!(descriptor instanceof ISelectedTabExtendFactory)) {
            return Optional.empty();
        }
        Descriptor<SelectedTabExtend> selectedTableExtendDesc = ((ISelectedTabExtendFactory)((Object)descriptor)).getSelectedTableExtendDescriptor();
        return Optional.ofNullable(selectedTableExtendDesc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ISelectedTab> createDefaultTables(IPluginContext pluginContext, List<String> selectedTabs, UploadPluginMeta pluginMeta, Consumer<Map.Entry<String, List<ColumnMetaData>>> tabMetaConsumer, boolean validateMapColsNull) {
        ArrayList allNewTabs = Lists.newArrayList();
        Map<String, List> mapCols = selectedTabs.stream().collect(Collectors.toMap(tab -> tab, tab -> {
            try {
                return this.getTableMetadata(false, pluginContext, EntityName.parse((String)tab));
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
        }));
        if (MapUtils.isEmpty(mapCols)) {
            if (validateMapColsNull) {
                throw new IllegalStateException("mapCols can not be empty");
            }
            return Collections.emptyList();
        }
        PluginFormProperties pluginFormPropertyTypes = this.getDescriptor().getPluginFormPropertyTypes(pluginMeta.getSubFormFilter());
        for (Map.Entry<String, List<ColumnMetaData>> entry : mapCols.entrySet()) {
            try {
                SuFormProperties.setSuFormGetterContext(this, pluginMeta, entry.getKey());
                allNewTabs.add(DataxReader.createNewSelectedTab(pluginFormPropertyTypes, entry));
                tabMetaConsumer.accept(entry);
            }
            finally {
                SuFormProperties.subFormGetterProcessThreadLocal.remove();
            }
        }
        return allNewTabs;
    }

    private static ISelectedTab createNewSelectedTab(PluginFormProperties pluginFormPropertyTypes, final Map.Entry<String, List<ColumnMetaData>> tab2cols) {
        return (ISelectedTab)pluginFormPropertyTypes.accept(new PluginFormProperties.IVisitor(){

            public ISelectedTab visit(BaseSubFormProperties props) {
                try {
                    SelectedTab subForm = (SelectedTab)props.newSubDetailed();
                    this.fillDefaultVals(props, subForm);
                    Descriptor parentDesc = props.getParentPluginDesc();
                    if (parentDesc instanceof CompanionPluginFactory) {
                        Descriptor companionDesc = ((CompanionPluginFactory)((Object)parentDesc)).getCompanionDescriptor();
                        SelectedTabExtend tabExt = (SelectedTabExtend)companionDesc.clazz.newInstance();
                        this.fillDefaultVals(companionDesc.getPluginFormPropertyTypes(), tabExt);
                        subForm.setSourceProps(tabExt);
                    }
                    return subForm;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            private void fillDefaultVals(PluginFormProperties props, Describable subForm) {
                Set<Map.Entry<String, PropertyType>> kvs = props.getKVTuples();
                PropertyType pp = null;
                HashSet skipProps = Sets.newHashSet();
                for (Map.Entry<String, PropertyType> pentry : kvs) {
                    pp = pentry.getValue();
                    if (pp.isIdentity()) {
                        pp.setVal(subForm, tab2cols.getKey());
                        skipProps.add(pentry.getKey());
                        continue;
                    }
                    if (pp.formField.type() != FormFieldType.MULTI_SELECTABLE) continue;
                    skipProps.add(pentry.getKey());
                    pp.setVal(subForm, ((List)tab2cols.getValue()).stream().map(ColumnMetaData::convert).collect(Collectors.toList()));
                }
                this.createPluginByDefaultVals(new StringBuffer(subForm.getClass().getName()), skipProps, kvs, subForm);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private Describable createPluginByDefaultVals(StringBuffer propPath, Set<String> skipProps, Set<Map.Entry<String, PropertyType>> kvTuples, Describable plugin) {
                Map.Entry<String, PropertyType> pentry;
                PropertyType pp = null;
                Iterator<Map.Entry<String, PropertyType>> iterator = kvTuples.iterator();
                block6: while (true) {
                    if (!iterator.hasNext()) {
                        return plugin;
                    }
                    pentry = iterator.next();
                    pp = pentry.getValue();
                    if (skipProps.contains(pentry.getKey())) continue;
                    if (pp.dftVal() != null) {
                        if (pp.isDescribable()) {
                            List<? extends Descriptor> descriptors = pp.getApplicableDescriptors();
                            try {
                                for (Descriptor descriptor : descriptors) {
                                    if (!StringUtils.endsWithIgnoreCase((String)String.valueOf(pp.dftVal()), (String)descriptor.getDisplayName())) continue;
                                    pp.setVal(plugin, this.createPluginByDefaultVals(new StringBuffer(propPath).append("->").append(pentry.getKey()).append(":").append(pp.fieldClazz.getName()), Sets.newHashSet(), descriptor.getPluginFormPropertyTypes().getKVTuples(), (Describable)descriptor.clazz.newInstance()));
                                    continue block6;
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            pp.setVal(plugin, pp.dftVal());
                            continue;
                        }
                    }
                    FormFieldType fieldType = pp.formField.type();
                    if (fieldType == FormFieldType.SELECTABLE || fieldType == FormFieldType.ENUM) {
                        List<Option> propOptions = pp.getEnumPropOptions();
                        EnumFieldMode enumFieldMode = pp.getEnumFieldMode();
                        int i = 0;
                        if (i < propOptions.size()) {
                            Option opt = propOptions.get(i);
                            List<Object> targetVal = null;
                            switch (enumFieldMode) {
                                case MULTIPLE: {
                                    targetVal = Collections.singletonList(opt.getValue());
                                    break;
                                }
                                case DEFAULT: {
                                    targetVal = opt.getValue();
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("illegal enumFieldMode:" + enumFieldMode);
                                }
                            }
                            pp.setVal(plugin, targetVal);
                            continue;
                        }
                    }
                    if (pp.isInputRequired()) break;
                }
                throw new IllegalStateException("have not prepare for table:" + (String)tab2cols.getKey() + " creating:" + propPath + ",prop name:'" + pentry.getKey() + "',subform class:" + plugin.getClass().getName());
            }
        });
    }

    @Override
    public final IStreamTableMeta getStreamTableMeta(TableAlias tableAlias) {
        String tableName = tableAlias.getFrom();
        if (this.tabMetaCache == null) {
            this.tabMetaCache = CacheBuilder.newBuilder().expireAfterWrite(40L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, IStreamTableMeta>(){

                public IStreamTableMeta load(String tableName) throws Exception {
                    try {
                        List<ColumnMetaData> cols = DataxReader.this.getTableMetadata(false, null, EntityName.parse((String)tableName));
                        final List colsMeta = cols.stream().map(c -> new HdfsColMeta(c.getName(), Boolean.valueOf(c.isNullable()), Boolean.valueOf(c.isPk()), c.getType())).collect(Collectors.toList());
                        return new IStreamTableMeta(){

                            public List<IColMetaGetter> getColsMeta() {
                                return colsMeta;
                            }
                        };
                    }
                    catch (TableNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        try {
            return (IStreamTableMeta)this.tabMetaCache.get((Object)tableName);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("tableName:" + tableName, e);
        }
    }

    @Override
    public void refresh() {
    }

    public static KeyedPluginStore<DataxReader> getPluginStore(IPluginContext pluginContext, String appname) {
        return DataxReader.getPluginStore(pluginContext, false, appname);
    }

    public static KeyedPluginStore<DataxReader> getPluginStore(IPluginContext pluginContext, boolean db, String appname) {
        return TIS.dataXReaderPluginStore.get(DataxReader.createDataXReaderKey(pluginContext, db, appname));
    }

    public static void cleanPluginStoreCache(IPluginContext pluginContext, boolean db, String appname) {
        TIS.DataXReaderAppKey appKey = DataxReader.createDataXReaderKey(pluginContext, db, appname);
        TIS.dataXReaderPluginStore.clear(appKey);
        if (pluginContext != null) {
            return;
        }
        Set<Map.Entry<SubFieldFormAppKey<? extends Describable>, KeyedPluginStore<? extends Describable>>> entries = TIS.dataXReaderSubFormPluginStore.getEntries();
        ArrayList willDelete = Lists.newArrayList();
        entries.forEach(e -> {
            SubFieldFormAppKey key = (SubFieldFormAppKey)e.getKey();
            if (StringUtils.equals((String)key.keyVal.getVal(), (String)appname) && key.isDB() == db) {
                willDelete.add(key);
            }
        });
        willDelete.forEach(deleteKey -> TIS.dataXReaderSubFormPluginStore.clear((SubFieldFormAppKey<? extends Describable>)deleteKey));
    }

    private static TIS.DataXReaderAppKey createDataXReaderKey(final IPluginContext pluginContext, final boolean db, final String appname) {
        TIS.DataXReaderAppKey key = new TIS.DataXReaderAppKey(pluginContext, db, appname, new PluginStore.IPluginProcessCallback<DataxReader>(){

            @Override
            public void afterDeserialize(PluginStore<DataxReader> ps, final DataxReader reader) {
                List<PluginFormProperties> subFieldFormPropertyTypes = reader.getDescriptor().getSubPluginFormPropertyTypes();
                if (subFieldFormPropertyTypes.size() > 0) {
                    subFieldFormPropertyTypes.forEach(pt -> pt.accept(new PluginFormProperties.IVisitor(){

                        public Void visit(final BaseSubFormProperties props) {
                            SubFieldFormAppKey<DataxReader> subFieldKey = new SubFieldFormAppKey<DataxReader>(pluginContext, db, appname, props, DataxReader.class);
                            KeyedPluginStore<DataxReader> subFieldStore = KeyedPluginStore.getPluginStore(subFieldKey);
                            Map<String, SelectedTab> tabsExtend = SelectedTabExtend.getTabExtend(pluginContext, appname, new PluginStore.PluginsUpdateListener[0]);
                            subFieldStore.addPluginsUpdateListener(new PluginStore.PluginsUpdateListener(subFieldKey.getSerializeFileName(), reader){

                                @Override
                                public void accept(PluginStore<Describable> pluginStore) {
                                    this.setReaderSubFormProp(props, pluginStore.getPlugins(), Collections.emptyMap());
                                }
                            });
                            List<DataxReader> subItems = subFieldStore.getPlugins();
                            if (CollectionUtils.isEmpty(subItems)) {
                                return null;
                            }
                            this.setReaderSubFormProp(props, subItems, tabsExtend);
                            return null;
                        }

                        private void setReaderSubFormProp(BaseSubFormProperties props, List<? extends Describable> subItems, Map<String, SelectedTab> subItemsExtend) {
                            this.setReaderSubFormProp(props, reader, subItems, subItemsExtend);
                        }

                        private void setReaderSubFormProp(BaseSubFormProperties props, DataxReader reader2, List<? extends Describable> subItems, Map<String, SelectedTab> subItemsExtend) {
                            if (reader2 == null) {
                                return;
                            }
                            subItems.forEach(item -> {
                                SelectedTab tab;
                                SelectedTab ext;
                                if (!props.instClazz.isAssignableFrom(item.getClass())) {
                                    throw new IllegalStateException("appname:" + appname + ",item class[" + item.getClass().getSimpleName() + "] is not type of " + props.instClazz.getName());
                                }
                                if (item instanceof SelectedTab && (ext = (SelectedTab)subItemsExtend.get((tab = (SelectedTab)item).identityValue())) != null) {
                                    tab.setIncrSourceProps((SelectedTabExtend)ext.getIncrSourceProps());
                                    tab.setIncrSinkProps((SelectedTabExtend)ext.getIncrSinkProps());
                                    tab.setSourceProps(ext.getSourceProps());
                                }
                            });
                            try {
                                props.subFormField.set(reader2, subItems);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("get subField:" + props.getSubFormFieldName(), e);
                            }
                        }
                    }));
                }
            }
        });
        return key;
    }

    public static DataxReader load(IPluginContext pluginContext, String appName) {
        return DataxReader.load(pluginContext, false, appName);
    }

    public static DataxReader load(IPluginContext pluginContext, boolean isDB, String appName) {
        DataxReader reader = null;
        if (dataxReaderGetter != null) {
            reader = dataxReaderGetter.get(appName);
            dataxReaderThreadLocal.set(reader);
            return reader;
        }
        reader = (DataxReader)DataxReader.getPluginStore(pluginContext, isDB, appName).getPlugin();
        Objects.requireNonNull(reader, "appName:" + appName + " relevant appSource can not be null");
        dataxReaderThreadLocal.set(reader);
        return reader;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void signDirty() {
        this.dirty = true;
    }

    @Override
    public final Descriptor<DataxReader> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getClass());
        Objects.requireNonNull(descriptor, "class:" + this.getClass() + " relevant descriptor can not be null");
        Class expectClass = this.getExpectDescClass();
        if (!expectClass.isAssignableFrom(descriptor.getClass())) {
            throw new IllegalStateException(descriptor.getClass() + " must implement the Descriptor of " + expectClass.getName());
        }
        BaseDataxReaderDescriptor readDesc = (BaseDataxReaderDescriptor)descriptor;
        if (readDesc.isRDBMSChangeableInLifetime() ^ this instanceof DataXBasicProcessMeta.IRDBMSSupport) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " bool status shall be same:\n readDesc.isRDBMSChangeableInLifetime(): " + readDesc.isRDBMSChangeableInLifetime() + "\n (" + this.getClass().getSimpleName() + " instanceof DataXBasicProcessMeta.IRDBMSSupport):" + (this instanceof DataXBasicProcessMeta.IRDBMSSupport));
        }
        return descriptor;
    }

    protected <TT extends BaseDataxReaderDescriptor> Class<TT> getExpectDescClass() {
        return BaseDataxReaderDescriptor.class;
    }

    @Override
    public final boolean isSupportBatch() {
        return ((BaseDataxReaderDescriptor)this.getDescriptor()).isSupportBatch();
    }

    public static class DataSourceMetaPlugin
    implements Describable<DataSourceMetaPlugin>,
    IDataxReader {
        public static final String tabName = "order";
        static List<ColumnMetaData> cols = Lists.newArrayList();
        static final ColumnMetaData orderId = new ColumnMetaData(0, "order_id", DataType.createVarChar((int)10), true);

        @Override
        public boolean isSupportBatch() {
            return true;
        }

        @Override
        public List<ColumnMetaData> getTableMetadata(boolean inSink, IPluginContext pluginContext, EntityName table) throws TableNotFoundException {
            Assert.assertEquals((String)tabName, (String)table.getTableName());
            return cols;
        }

        public List<SelectedTab> getSelectedTabs() {
            SelectedTab tab = new SelectedTab();
            tab.name = tabName;
            tab.cols = Lists.newArrayList((Object[])new CMeta[]{ColumnMetaData.convert((ColumnMetaData)orderId)});
            return Collections.singletonList(tab);
        }

        @Override
        public <T extends ISelectedTab> List<T> getUnfilledSelectedTabs() {
            return this.getSelectedTabs();
        }

        @Override
        public IGroupChildTaskIterator getSubTasks(Predicate<ISelectedTab> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTemplate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IStreamTableMeta getStreamTableMeta(TableAlias tableAlias) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startScanDependency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void refresh() {
            throw new UnsupportedOperationException();
        }

        static {
            cols.add(orderId);
            ColumnMetaData col = new ColumnMetaData(1, "name", DataType.createVarChar((int)10), false);
            cols.add(col);
        }
    }

    public static abstract class BaseDataxReaderDescriptor
    extends Descriptor<DataxReader>
    implements IDataXEndTypeGetter {
        @Override
        public PluginFormProperties getPluginFormPropertyTypes(Optional<SubFormFilter> subFormFilter) {
            SubFormFilter filter = null;
            if (subFormFilter.isPresent() && (filter = subFormFilter.get()).isIncrProcessExtend()) {
                Descriptor parentDesc = filter.getTargetDescriptor();
                SuFormProperties subProps = (SuFormProperties)parentDesc.getSubPluginFormPropertyTypes(filter.subFieldName);
                return new IncrSourceExtendSelected(filter.uploadPluginMeta, subProps.subFormField);
            }
            return super.getPluginFormPropertyTypes(subFormFilter);
        }

        @Override
        public final IEndTypeGetter.PluginVender getVender() {
            return IEndTypeGetter.PluginVender.DATAX;
        }

        @Override
        public final Map<String, Object> getExtractProps() {
            Map<String, Object> eprops = super.getExtractProps();
            eprops.put("rdbms", this.isRdbms());
            eprops.put("supportIncr", this.isSupportIncr());
            eprops.put("supportBatch", this.isSupportBatch());
            return eprops;
        }

        @Override
        public boolean isSupportBatch() {
            return true;
        }

        public boolean hasExplicitTable() {
            return this.isRdbms();
        }

        public abstract boolean isRdbms();

        public boolean isRDBMSChangeableInLifetime() {
            return false;
        }
    }

    public static class SubFieldFormAppKey<TT extends Describable>
    extends KeyedPluginStore.AppKey<TT> {
        public final BaseSubFormProperties subfieldForm;

        public SubFieldFormAppKey(IPluginContext pluginContext, boolean isDB, String appname, BaseSubFormProperties subfieldForm, Class<TT> clazz) {
            super(pluginContext, StoreResourceType.parse((boolean)isDB), Objects.requireNonNull(appname, "appname can not be empty"), clazz);
            this.subfieldForm = subfieldForm;
        }

        @Override
        public String getSerializeFileName() {
            return super.getSerializeFileName() + "." + this.subfieldForm.getSubFormFieldName();
        }
    }

    public static interface IDataxReaderGetter {
        public DataxReader get(String var1);
    }
}

