/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataXBasicProcessMeta;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.DescriptorExtensionList;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.IBasicAppSource;
import com.qlangtech.tis.manage.biz.dal.pojo.Application;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.PluginStore;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.trigger.JobTrigger;
import com.qlangtech.tis.sql.parser.tuple.creator.IStreamIncrGenerateStrategy;
import com.qlangtech.tis.util.IPluginContext;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public abstract class DataxProcessor
implements IBasicAppSource,
IDataxProcessor,
IStreamIncrGenerateStrategy,
IPluginStore.AfterPluginSaved {
    public static final String DATAX_CFG_DIR_NAME = "dataxCfg";
    public static final String DATAX_CREATE_DDL_DIR_NAME = "createDDL";
    private transient Map<String, TableAlias> _tableMaps;
    private transient PluginStore<IAppSource> pluginStore;
    private transient TableAliasMapper dftTableAliasMapper;
    public static IDataxProcessorGetter processorGetter;

    @Override
    public void afterSaved(IPluginContext pluginContext, Optional<Context> context) {
        this._tableMaps = null;
        this.dftTableAliasMapper = null;
    }

    @Override
    public void setPluginStore(PluginStore<IAppSource> pluginStore) {
        this.pluginStore = pluginStore;
    }

    public static IDataxProcessor load(IPluginContext pluginContext, DataXName dataXName) {
        return DataxProcessor.load(pluginContext, Objects.requireNonNull(dataXName, "dataXName can not be null").getType(), dataXName.getPipelineName());
    }

    public static IDataxProcessor load(IPluginContext pluginContext, String dataXName) {
        if (processorGetter != null) {
            return processorGetter.get(dataXName);
        }
        return DataxProcessor.load(pluginContext, StoreResourceType.DataApp, dataXName);
    }

    public static IDataxProcessor load(IPluginContext pluginContext, StoreResourceType resType, String dataXName) {
        if (resType == StoreResourceType.DataBase) {
            throw new IllegalArgumentException("resType is not support:" + StoreResourceType.DataBase);
        }
        if (processorGetter != null) {
            return processorGetter.get(dataXName);
        }
        Optional appSource = IAppSource.loadNullable(pluginContext, resType, dataXName);
        if (appSource.isPresent()) {
            return (IDataxProcessor)appSource.get();
        }
        KeyedPluginStore store = IAppSource.getPluginStore(pluginContext, resType, dataXName);
        throw new RuntimeException("targetName:" + dataXName + ",resType:" + resType + ",store file is not exist:" + store.getTargetFile().getFile());
    }

    public static Descriptor<IAppSource> getPluginDescMeta() {
        return DataxProcessor.getPluginDescMeta("DataxProcessor");
    }

    public static Descriptor<IAppSource> getPluginDescMeta(String targetProcessName) {
        DescriptorExtensionList descs = TIS.get().getDescriptorList(IAppSource.class);
        Optional<Descriptor> dataxProcessDescs = descs.stream().filter(des -> targetProcessName.equals(des.getDisplayName())).findFirst();
        if (!dataxProcessDescs.isPresent()) {
            throw new IllegalStateException("dataX process descriptor:" + targetProcessName + " relevant descriptor can not be null");
        }
        return dataxProcessDescs.get();
    }

    public static DataXCreateProcessMeta getDataXCreateProcessMeta(IPluginContext pluginContext, String dataxPipeName) {
        return DataxProcessor.getDataXCreateProcessMeta(pluginContext, dataxPipeName, true);
    }

    public static DataXCreateProcessMeta getDataXCreateProcessMeta(IPluginContext pluginContext, String dataxPipeName, boolean writerNullValidate) {
        DataxWriter writer = DataxWriter.load(pluginContext, dataxPipeName, writerNullValidate);
        DataxWriter.BaseDataxWriterDescriptor writerDesc = null;
        writerDesc = !writerNullValidate && writer == null ? (DataxWriter.BaseDataxWriterDescriptor)IDataxProcessor.getWriterDescriptor(pluginContext, dataxPipeName) : (DataxWriter.BaseDataxWriterDescriptor)Objects.requireNonNull(writer, "name:" + dataxPipeName + " relevant dataXWriter can not be null").getDescriptor();
        DataxReader dataxReader = DataxReader.load(pluginContext, dataxPipeName);
        DataxReader.BaseDataxReaderDescriptor readDescriptor = (DataxReader.BaseDataxReaderDescriptor)dataxReader.getDescriptor();
        boolean dataXReaderRDBMSSwitchOn = false;
        if (dataxReader instanceof DataXBasicProcessMeta.IRDBMSSupport) {
            dataXReaderRDBMSSwitchOn = ((DataXBasicProcessMeta.IRDBMSSupport)((Object)dataxReader)).isRDBMSSupport();
        }
        DataXCreateProcessMeta processMeta = new DataXCreateProcessMeta(writer, dataxReader);
        processMeta.setReaderRDBMS(dataXReaderRDBMSSwitchOn || readDescriptor.isRdbms());
        processMeta.setReaderHasExplicitTable(readDescriptor.hasExplicitTable());
        processMeta.setWriterRDBMS(writerDesc.isRdbms());
        processMeta.setWriterSupportMultiTableInReader(writerDesc.isSupportMultiTable());
        return processMeta;
    }

    public abstract Application buildApp();

    @Override
    public <T> T accept(IBasicAppSource.IAppSourceVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public TableAliasMapper getTabAlias() {
        return this.getTabAlias(null, true);
    }

    private Map<String, TableAlias> getTableMaps(IPluginContext pluginCtx) {
        if (this._tableMaps == null) {
            List<TableAlias> aliases = TableAlias.load(pluginCtx, this.identityValue());
            this._tableMaps = aliases.stream().collect(Collectors.toMap(m -> {
                if (StringUtils.isEmpty((String)m.getFrom())) {
                    throw new IllegalArgumentException("table mapper from can not be empty");
                }
                return m.getFrom();
            }, m -> m));
        }
        return this._tableMaps;
    }

    @Override
    public TableAliasMapper getTabAlias(IPluginContext pluginCtx, boolean withDft) {
        Map<String, TableAlias> tableMaps = this.getTableMaps(pluginCtx);
        return MapUtils.isEmpty(tableMaps) ? this.getDefault(pluginCtx, withDft) : new TableAliasMapper(tableMaps);
    }

    private TableAliasMapper getDefault(IPluginContext pluginCtx, boolean withDft) {
        if (!withDft) {
            return TableAliasMapper.Null;
        }
        if (this.dftTableAliasMapper == null) {
            this.dftTableAliasMapper = TableAliasMapper.Null;
            IDataxReader reader = this.getReader(pluginCtx);
            List tabs = reader.getUnfilledSelectedTabs();
            HashMap mapper = Maps.newHashMap();
            for (ISelectedTab tab : tabs) {
                mapper.put(tab.getName(), new IDataxProcessor.TableMap(tab));
            }
            this.dftTableAliasMapper = new TableAliasMapper(mapper);
        }
        return this.dftTableAliasMapper;
    }

    @Override
    public void saveCreateTableDDL(IPluginContext pluginCtx, StringBuffer createDDL, String sqlFileName, boolean overWrite) throws IOException {
        File createDDLDir = this.getDataxCreateDDLDir(pluginCtx);
        DataxProcessor.saveCreateTableDDL(createDDL, createDDLDir, sqlFileName, overWrite);
        Objects.requireNonNull(this.pluginStore, "pluginStore can be null,shall be set by method  setPluginStore ahead").writeLastModifyTimeStamp();
    }

    public static void saveCreateTableDDL(StringBuffer createDDL, File createDDLDir, String sqlFileName, boolean overWrite) throws IOException {
        if (StringUtils.isEmpty((String)sqlFileName)) {
            throw new IllegalArgumentException("param sqlFileName can not be empty");
        }
        File f = new File(createDDLDir, sqlFileName);
        if (overWrite || !f.exists()) {
            FileUtils.write((File)f, (CharSequence)createDDL.toString(), (Charset)TisUTF8.get());
        }
    }

    @Override
    public final boolean isReaderUnStructed(IPluginContext pluginCtx) {
        DataXCreateProcessMeta dataXCreateProcessMeta = DataxProcessor.getDataXCreateProcessMeta(pluginCtx, this.identityValue());
        return dataXCreateProcessMeta.isReaderUnStructed();
    }

    @Override
    public boolean isRDBMS2UnStructed(IPluginContext pluginCtx) {
        DataXCreateProcessMeta dataXCreateProcessMeta = DataxProcessor.getDataXCreateProcessMeta(pluginCtx, this.identityValue());
        return dataXCreateProcessMeta.isReaderRDBMS() && !dataXCreateProcessMeta.isWriterRDBMS();
    }

    @Override
    public boolean isRDBMS2RDBMS(IPluginContext pluginCtx) {
        DataXCreateProcessMeta dataXCreateProcessMeta = DataxProcessor.getDataXCreateProcessMeta(pluginCtx, this.identityValue());
        return dataXCreateProcessMeta.isReaderRDBMS() && dataXCreateProcessMeta.isWriterRDBMS();
    }

    @Override
    public boolean isWriterSupportMultiTableInReader(IPluginContext pluginCtx) {
        DataXCreateProcessMeta dataXCreateProcessMeta = DataxProcessor.getDataXCreateProcessMeta(pluginCtx, this.identityValue());
        return dataXCreateProcessMeta.isWriterSupportMultiTableInReader();
    }

    @Override
    public IDataxReader getReader(IPluginContext pluginCtx) {
        return DataxReader.load(pluginCtx, this.identityValue());
    }

    @Override
    public IDataxWriter getWriter(IPluginContext pluginCtx, boolean validateNull) {
        return DataxWriter.load(pluginCtx, StoreResourceType.DataApp, this.identityValue(), validateNull);
    }

    @Override
    public File getDataxCfgDir(IPluginContext pluginContext) {
        return DataxProcessor.getDataxCfgDir(pluginContext, this);
    }

    public static File getDataxCfgDir(IPluginContext pluginContext, IDataxProcessor processor) {
        File dataXWorkDir = processor.getDataXWorkDir(pluginContext);
        return new File(dataXWorkDir, DATAX_CFG_DIR_NAME);
    }

    @Override
    public File getDataxCreateDDLDir(IPluginContext pluginContext) {
        return DataxProcessor.getDataxCreateDDLDir(pluginContext, this);
    }

    public static File getDataxCreateDDLDir(IPluginContext pluginContext, IDataxProcessor processor) {
        File dataXWorkDir = processor.getDataXWorkDir(pluginContext);
        File ddlDir = new File(dataXWorkDir, DATAX_CREATE_DDL_DIR_NAME);
        try {
            FileUtils.forceMkdir((File)ddlDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ddlDir;
    }

    @Override
    public File getDataXWorkDir(IPluginContext pluginContext) {
        return IDataxProcessor.getDataXWorkDir(pluginContext, this.identityValue());
    }

    @Override
    public DataXCfgGenerator.GenerateCfgs getDataxCfgFileNames(IPluginContext pluginContext, Optional<JobTrigger> partialTrigger) {
        return DataxProcessor.getDataxCfgFileNames(pluginContext, partialTrigger, this);
    }

    public static DataXCfgGenerator.GenerateCfgs getDataxCfgFileNames(IPluginContext pluginContext, Optional<JobTrigger> partialTrigger, IDataxProcessor processor) {
        File dataxCfgDir = processor.getDataxCfgDir(pluginContext);
        if (!dataxCfgDir.exists()) {
            throw new IllegalStateException("dataxCfgDir is not exist:" + dataxCfgDir.getAbsolutePath());
        }
        if (dataxCfgDir.list().length < 1) {
            throw new IllegalStateException("dataxCfgDir is empty can not find any files:" + dataxCfgDir.getAbsolutePath());
        }
        DataXCfgGenerator.GenerateCfgs genCfgs = DataXCfgGenerator.GenerateCfgs.readFromGen(processor, pluginContext, dataxCfgDir, partialTrigger);
        return genCfgs;
    }

    public boolean isExcludeFacadeDAOSupport() {
        return true;
    }

    public static class DataXCreateProcessMeta
    extends DataXBasicProcessMeta {
        private final DataxWriter writer;
        private final DataxReader reader;

        public DataXCreateProcessMeta(DataxWriter writer, DataxReader reader) {
            this.writer = writer;
            this.reader = reader;
        }

        @JSONField(serialize=false)
        public DataxWriter getWriter() {
            return this.writer;
        }

        @JSONField(serialize=false)
        public DataxReader getReader() {
            return this.reader;
        }
    }

    public static interface IDataxProcessorGetter {
        public DataxProcessor get(String var1);
    }
}

