/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.qlangtech.tis.datax.DBDataXChildTask;
import com.qlangtech.tis.datax.DataXCfgFile;
import com.qlangtech.tis.datax.DataXJobInfo;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataXGenerateCfgs;
import com.qlangtech.tis.datax.IDataXNameAware;
import com.qlangtech.tis.datax.IDataXPluginMeta;
import com.qlangtech.tis.datax.IDataxContext;
import com.qlangtech.tis.datax.IDataxGlobalCfg;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IDataxReaderContext;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.IGroupChildTaskIterator;
import com.qlangtech.tis.datax.SourceColMetaGetter;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.datax.impl.TISClasspathResourceLoader;
import com.qlangtech.tis.datax.impl.TransformerInfo;
import com.qlangtech.tis.manage.common.AppAndRuntime;
import com.qlangtech.tis.manage.common.Option;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.datax.AbstractCreateTableSqlBuilder;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.trigger.JobTrigger;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.IPluginContext;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class DataXCfgGenerator
implements IDataXNameAware {
    private static final transient VelocityEngine velocityEngine;
    private final IDataxProcessor dataxProcessor;
    private final IDataxGlobalCfg globalCfg;
    private final String dataxName;
    private final IPluginContext pluginCtx;
    private final TableMapCreator tableMapCreator;
    public static final String FILE_GEN = "gen";

    public DataXName getCollectionName() {
        return new DataXName(this.dataxName, this.dataxProcessor.getResType());
    }

    public DataXCfgGenerator(IPluginContext pluginCtx, String dataxName, IDataxProcessor dataxProcessor) {
        Objects.requireNonNull(dataxProcessor, "dataXprocessor can not be null");
        IDataxGlobalCfg dataXGlobalCfg = dataxProcessor.getDataXGlobalCfg();
        Objects.requireNonNull(dataXGlobalCfg, "globalCfg can not be null");
        this.dataxProcessor = dataxProcessor;
        this.globalCfg = dataXGlobalCfg;
        this.dataxName = dataxName;
        this.pluginCtx = pluginCtx;
        this.tableMapCreator = new TableMapCreator();
    }

    protected String getTemplateContent(IDataxReaderContext readerContext, IDataxReader reader, IDataxWriter writer, Optional<RecordTransformerRules> transformerRules) {
        String tpl = this.globalCfg.getTemplate();
        if (StringUtils.isEmpty((String)reader.getTemplate())) {
            throw new IllegalStateException("readerTpl of '" + reader.getDataxMeta().getName() + "' can not be null");
        }
        StringBuffer readerTpl = new StringBuffer(reader.getTemplate());
        String writerTpl = writer.getTemplate();
        if (StringUtils.isEmpty((String)writerTpl)) {
            throw new IllegalStateException("writerTpl of '" + writer.getDataxMeta().getName() + "' can not be null");
        }
        readerTpl.append(",\n\t\"").append("transformer").append("\":\t\t\n {\"").append("name").append("\":\"").append(readerContext.getSourceTableName()).append("\",\n\"").append("cols").append("\":").append("[");
        if (transformerRules.isPresent()) {
            readerTpl.append(transformerRules.get().relevantColKeys().stream().map(col -> "\"" + col + "\"").collect(Collectors.joining(",")));
        }
        readerTpl.append("]").append("}");
        String template = StringUtils.replace((String)tpl, (String)"<!--reader-->", (String)readerTpl.toString());
        template = StringUtils.replace((String)template, (String)"<!--writer-->", (String)writerTpl);
        return template;
    }

    public GenerateCfgs getExistCfg(File parentDir) throws Exception {
        File dataxCfgDir = this.dataxProcessor.getDataxCfgDir(this.pluginCtx);
        GenerateCfgs generateCfgs = new GenerateCfgs(this.dataxProcessor, this.pluginCtx, dataxCfgDir);
        File genFile = new File(parentDir, FILE_GEN);
        if (!genFile.exists()) {
            return generateCfgs;
        }
        generateCfgs.createDDLFiles = this.getExistDDLFiles();
        GenerateCfgs cfgs = GenerateCfgs.readFromGen(this.dataxProcessor, this.pluginCtx, dataxCfgDir, Optional.empty());
        generateCfgs.setGenTime(cfgs.getGenTime());
        generateCfgs.setGroupedChildTask(cfgs.getGroupedChildTask());
        return generateCfgs;
    }

    private List<String> getExistDDLFiles() {
        File dataxCreateDDLDir = this.dataxProcessor.getDataxCreateDDLDir(this.pluginCtx);
        return Lists.newArrayList((Object[])dataxCreateDDLDir.list((dir, f) -> StringUtils.endsWith((String)f, (String)".sql")));
    }

    public GenerateCfgs startGenerateCfg(final File dataXCfgDir) throws Exception {
        final boolean supportDataXBatch = this.dataxProcessor.isSupportBatch(this.pluginCtx);
        if (supportDataXBatch) {
            FileUtils.cleanDirectory((File)dataXCfgDir);
        }
        return this.startGenerateCfg(new IGenerateScriptFile(){

            @Override
            public void generateScriptFile(SourceColMetaGetter colMetaGetter, IDataxReader reader, IDataxWriter writer, DataxWriter.BaseDataxWriterDescriptor writerDescriptor, IDataxReaderContext readerContext, Set<String> createDDLFiles, Optional<IDataxProcessor.TableMap> tableMapper) throws IOException {
                if (writerDescriptor.isSupportTabCreate()) {
                    DataXCfgGenerator.generateTabCreateDDL(DataXCfgGenerator.this.pluginCtx, DataXCfgGenerator.this.dataxProcessor, colMetaGetter, writer, readerContext, createDDLFiles, tableMapper, false);
                }
                if (supportDataXBatch) {
                    if (StringUtils.isEmpty((String)readerContext.getTaskName())) {
                        throw new IllegalStateException("readerContext.getTaskName() must be present");
                    }
                    File configFile = DataXJobInfo.getJobPath((File)dataXCfgDir, (String)readerContext.getReaderContextId(), (String)(readerContext.getTaskName() + ".json"));
                    FileUtils.write((File)configFile, (CharSequence)DataXCfgGenerator.this.generateDataxConfig(readerContext, writer, reader, tableMapper), (Charset)TisUTF8.get(), (boolean)false);
                }
            }
        });
    }

    public GenerateCfgs startGenerateCfg(IGenerateScriptFile scriptFileGenerator) throws Exception {
        boolean unStructedReader = this.dataxProcessor.isReaderUnStructed(this.pluginCtx);
        IDataxWriter writer = this.dataxProcessor.getWriter(this.pluginCtx);
        DataxWriter.BaseDataxWriterDescriptor writerDescriptor = writer.getWriterDescriptor();
        SourceColMetaGetter colMetaGetter = null;
        HashSet createDDLFiles = Sets.newHashSet();
        List<String> existDDLFiles = this.getExistDDLFiles();
        GenerateCfgs cfgs = new GenerateCfgs(this.dataxProcessor, this.pluginCtx, this.dataxProcessor.getDataxCfgDir(this.pluginCtx));
        List<IDataxReader> readers = this.dataxProcessor.getReaders(this.pluginCtx);
        if (CollectionUtils.isEmpty(readers)) {
            throw new IllegalStateException(this.dataxName + " relevant readers can not be empty");
        }
        for (IDataxReader reader : readers) {
            colMetaGetter = reader.createSourceColMetaGetter();
            IGroupChildTaskIterator subTasks = Objects.requireNonNull(reader.getSubTasks(), "subTasks can not be null");
            try {
                IDataxReaderContext readerContext = null;
                while (subTasks.hasNext()) {
                    readerContext = (IDataxReaderContext)subTasks.next();
                    Optional<IDataxProcessor.TableMap> tableMapper = this.buildTabMapper(reader, readerContext);
                    scriptFileGenerator.generateScriptFile(colMetaGetter, reader, writer, writerDescriptor, readerContext, createDDLFiles, tableMapper);
                }
                Map<String, List<DBDataXChildTask>> groupedInfo = subTasks.getGroupedInfo();
                if (MapUtils.isEmpty(groupedInfo)) {
                    throw new IllegalStateException("groupedInfo can not be empty");
                }
                cfgs.groupedChildTask.putAll(groupedInfo);
            }
            finally {
                if (subTasks == null) continue;
                subTasks.close();
            }
        }
        if (writerDescriptor.isSupportTabCreate()) {
            File createDDLDir = this.dataxProcessor.getDataxCreateDDLDir(this.pluginCtx);
            for (String oldDDLFile : existDDLFiles) {
                if (createDDLFiles.contains(oldDDLFile)) continue;
                FileUtils.deleteQuietly((File)new File(createDDLDir, oldDDLFile));
            }
            if (!writer.isGenerateCreateDDLSwitchOff() && CollectionUtils.isEmpty((Collection)createDDLFiles)) {
                throw new IllegalStateException("createDDLFiles can not be empty ");
            }
        }
        long current = System.currentTimeMillis();
        cfgs.createDDLFiles = Lists.newArrayList((Iterable)createDDLFiles);
        cfgs.genTime = current;
        return cfgs;
    }

    public Optional<IDataxProcessor.TableMap> buildTabMapper(IDataxReader reader, IDataxReaderContext readerContext) {
        return this.tableMapCreator.build(reader, readerContext);
    }

    public static void generateTabCreateDDL(IPluginContext pluginCtx, IDataxProcessor dataxProcessor, SourceColMetaGetter colMetaGetter, IDataxWriter writer, IDataxReaderContext readerContext, Set<String> createDDLFiles, Optional<IDataxProcessor.TableMap> tableMapper, boolean overWrite) throws IOException {
        DataxWriter.BaseDataxWriterDescriptor writerDescriptor = writer.getWriterDescriptor();
        if (writer.isGenerateCreateDDLSwitchOff()) {
            return;
        }
        if (tableMapper.isPresent() && writerDescriptor.isSupportTabCreate()) {
            for (CMeta colMeta : tableMapper.get().getSourceCols()) {
                if (colMeta.getType() == null) {
                    throw new IllegalStateException("reader context:" + readerContext.getSourceTableName() + " relevant col type which's name " + colMeta.getName() + " can not be null");
                }
                if (!StringUtils.isEmpty((String)colMeta.getName())) continue;
                throw new IllegalStateException("reader context:" + readerContext.getSourceTableName() + " relevant col name  can not be null");
            }
            IDataxProcessor.TableMap mapper = tableMapper.get();
            String sqlFileName = mapper.getFrom() + ".sql";
            if (!createDDLFiles.contains(sqlFileName)) {
                Optional<RecordTransformerRules> transformers = RecordTransformerRules.loadTransformerRules(pluginCtx, dataxProcessor, mapper.getFrom());
                AbstractCreateTableSqlBuilder.CreateDDL createDDL = Objects.requireNonNull(writer.generateCreateDDL(colMetaGetter, mapper, transformers), "createDDL can not be null");
                createDDLFiles.add(sqlFileName);
                dataxProcessor.saveCreateTableDDL(pluginCtx, createDDL.getDDLScript(), sqlFileName, overWrite);
            }
        }
    }

    private IDataxProcessor.TableMap createTableMap(TableAliasMapper tabAlias, Map<String, ISelectedTab> selectedTabs, IDataxReaderContext readerContext) {
        return readerContext.createTableMap(tabAlias, selectedTabs);
    }

    public String generateDataxConfig(IDataxReaderContext readerContext, IDataxWriter writer, IDataxReader reader, Optional<IDataxProcessor.TableMap> tableMapper) throws IOException {
        Optional<RecordTransformerRules> transformerRules = RecordTransformerRules.loadTransformerRules(this.pluginCtx, Objects.requireNonNull(this.dataxProcessor, "dataxProcessor can not be null"), readerContext.getSourceTableName());
        return this.generateDataxConfig(readerContext, writer, reader, transformerRules, tableMapper);
    }

    public String generateDataxConfig(IDataxReaderContext readerContext, IDataxWriter writer, IDataxReader reader, Optional<RecordTransformerRules> transformerRules, Optional<IDataxProcessor.TableMap> tableMap) {
        Objects.requireNonNull(writer, "writer can not be null");
        String tpl = this.getTemplateContent(readerContext, reader, writer, transformerRules);
        if (StringUtils.isEmpty((String)tpl)) {
            throw new IllegalStateException("velocity template content can not be null");
        }
        try {
            VelocityContext mergeData = this.createContext(readerContext, writer.getSubTask(tableMap, transformerRules));
            String content = DataXCfgGenerator.evaluateTemplate(mergeData, tpl);
            JSONObject cfg = JSON.parseObject((String)content);
            this.validatePluginName(writer, reader, cfg);
            return JsonUtil.toString((Object)cfg, (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(tpl + "\n", e);
        }
    }

    public static String evaluateTemplate(VelocityContext mergeData, String tpl) {
        String string;
        StringWriter writerContent = new StringWriter();
        try {
            velocityEngine.evaluate((Context)mergeData, (Writer)writerContent, "tablex-writer.vm", tpl);
            string = writerContent.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writerContent.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        writerContent.close();
        return string;
    }

    public void validatePluginName(IDataxWriter writer, IDataxReader reader, JSONObject cfg) {
        JSONObject job = cfg.getJSONObject("job");
        if (job == null) {
            return;
        }
        JSONArray contentAry = job.getJSONArray("content");
        JSONObject rw = contentAry.getJSONObject(0);
        String readerName = rw.getJSONObject("reader").getString("name");
        String writerName = rw.getJSONObject("writer").getString("name");
        DataXCfgGenerator.validatePluginName(writer.getDataxMeta(), reader.getDataxMeta(), Objects.requireNonNull(writerName, "writerName can not be null"), Objects.requireNonNull(readerName, "readerName can not be null"));
    }

    public static void validatePluginName(IDataXPluginMeta.DataXMeta writer, IDataXPluginMeta.DataXMeta reader, String writerName, String readerName) {
        if (!StringUtils.equals((String)readerName, (String)reader.getName())) {
            throw new IllegalStateException("reader plugin name:" + readerName + " must equal with '" + reader.getName() + "'");
        }
        if (!StringUtils.equals((String)writerName, (String)writer.getName())) {
            throw new IllegalStateException("writer plugin name:" + writerName + " must equal with '" + writer.getName() + "'");
        }
    }

    private VelocityContext createContext(IDataxContext reader, IDataxContext writer) {
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("dataxName", (Object)this.dataxName);
        velocityContext.put("reader", (Object)reader);
        velocityContext.put("writer", (Object)writer);
        velocityContext.put("cfg", (Object)this.globalCfg);
        return velocityContext;
    }

    static {
        try {
            velocityEngine = new VelocityEngine();
            Properties prop = new Properties();
            prop.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogChute");
            prop.setProperty("resource.loader", "tisLoader");
            prop.setProperty("tisLoader.resource.loader.class", TISClasspathResourceLoader.class.getName());
            velocityEngine.init(prop);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class GenerateCfgs
    implements IDataXGenerateCfgs {
        private List<DataXCfgFile> _dataxFiles;
        private List<String> createDDLFiles = Collections.emptyList();
        private Map<String, List<DBDataXChildTask>> groupedChildTask = Maps.newHashMap();
        private long genTime;
        private final File dataxCfgDir;
        private final IPluginContext pluginCtx;
        private final IDataxProcessor dataxProcessor;
        public static final String KEY_GEN_TIME = "genTime";
        public static final String KEY_GROUP_CHILD_TASKS = "groupChildTasks";

        public GenerateCfgs(IDataxProcessor dataxProcessor, IPluginContext pluginCtx, File dataxCfgDir) {
            this.dataxCfgDir = dataxCfgDir;
            this.pluginCtx = pluginCtx;
            this.dataxProcessor = dataxProcessor;
        }

        public List<DataXCfgFile> getDataxFiles() {
            return this.getDataXCfgFiles().stream().map(file -> file).collect(Collectors.toList());
        }

        public static List<Option> getTabsCandidate() {
            AppAndRuntime appAndRuntime = AppAndRuntime.getAppAndRuntime();
            if (appAndRuntime == null) {
                return Collections.emptyList();
            }
            IDataxProcessor dataxProcessor = DataxProcessor.load(null, appAndRuntime.getAppName());
            if (!dataxProcessor.isSupportBatch((IPluginContext)null)) {
                return Collections.emptyList();
            }
            File dataxCfgDir = dataxProcessor.getDataxCfgDir(null);
            if (!dataxCfgDir.exists()) {
                return Collections.emptyList();
            }
            GenerateCfgs dataxCfgFileNames = dataxProcessor.getDataxCfgFileNames(null, Optional.empty());
            return dataxCfgFileNames.getTargetTabs().stream().map(tab -> new Option(tab)).collect(Collectors.toList());
        }

        @JSONField(serialize=false)
        public List<DataXCfgFile> getDataXCfgFiles() {
            if (this._dataxFiles == null) {
                this._dataxFiles = this.getGroupedChildTask().values().stream().flatMap(tasks -> tasks.stream()).map(task -> {
                    task.getDbFactoryId();
                    File dataXCfg = task.getJobPath(this.dataxCfgDir);
                    if (!dataXCfg.exists()) {
                        throw new IllegalStateException("dataXCfg is not exist, path:" + dataXCfg.getAbsolutePath());
                    }
                    return new DataXCfgFile().setFile(dataXCfg).setDbFactoryId(task.dbFactoryId);
                }).collect(Collectors.toList());
            }
            return this._dataxFiles;
        }

        public final Set<String> getTargetTabs() {
            return this.getGroupedChildTask().keySet();
        }

        @JSONField(name="transformerInfo", serialize=true)
        public final Set<TransformerInfo> getTransformerInfo() {
            return this.dataxProcessor.getTransformerInfo(this.pluginCtx, this.groupedChildTask);
        }

        private Map<String, List<DBDataXChildTask>> getGroupedChildTask() {
            if (this.groupedChildTask == null) {
                throw new IllegalStateException("groupedChildTask can not be null");
            }
            return this.groupedChildTask;
        }

        public void setGroupedChildTask(Map<String, List<DBDataXChildTask>> groupedChildTask) {
            this.groupedChildTask = groupedChildTask;
        }

        public List<DBDataXChildTask> getDataXTaskDependencies(String taskGroupName) {
            List<DBDataXChildTask> subChildTask = null;
            Map<String, List<DBDataXChildTask>> groupdTsk = this.getGroupedChildTask();
            subChildTask = groupdTsk.get(taskGroupName);
            if (CollectionUtils.isEmpty(subChildTask)) {
                throw new IllegalStateException("taskGroupName:" + taskGroupName + " relevant childTask:" + String.join((CharSequence)",", groupdTsk.keySet()) + " can not be empty");
            }
            return subChildTask;
        }

        public void write2GenFile(File dataxCfgDir) {
            try {
                JSONObject o = new JSONObject();
                o.put(KEY_GROUP_CHILD_TASKS, this.getGroupedChildTask());
                o.put(KEY_GEN_TIME, (Object)this.getGenTime());
                FileUtils.write((File)new File(dataxCfgDir, DataXCfgGenerator.FILE_GEN), (CharSequence)JsonUtil.toString((Object)o), (Charset)TisUTF8.get(), (boolean)false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public static GenerateCfgs readFromGen(IDataxProcessor processor, IPluginContext pluginCtx, File dataxCfgDir, Optional<JobTrigger> partialTrigger) {
            try {
                GenerateCfgs cfgs = new GenerateCfgs(processor, pluginCtx, dataxCfgDir);
                JSONObject o = JSON.parseObject((String)FileUtils.readFileToString((File)new File(dataxCfgDir, DataXCfgGenerator.FILE_GEN), (Charset)TisUTF8.get()));
                cfgs.genTime = o.getLongValue(KEY_GEN_TIME);
                HashMap groupedChildTasks = Maps.newHashMap();
                Map childTasks = (Map)o.getObject(KEY_GROUP_CHILD_TASKS, Map.class);
                Set filterTabsName = null;
                if (partialTrigger.isPresent()) {
                    filterTabsName = partialTrigger.get().selectedTabs().stream().map(tab -> tab.identityValue()).collect(Collectors.toSet());
                }
                List tasks = null;
                for (Map.Entry entry : childTasks.entrySet()) {
                    if (filterTabsName != null && !filterTabsName.contains(entry.getKey())) continue;
                    tasks = ((JSONArray)entry.getValue()).toJavaList(DBDataXChildTask.class);
                    groupedChildTasks.put((String)entry.getKey(), tasks);
                }
                cfgs.groupedChildTask = groupedChildTasks;
                return cfgs;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public List<String> getCreateDDLFiles() {
            return this.createDDLFiles;
        }

        public long getGenTime() {
            return this.genTime;
        }

        public void setGenTime(long genTime) {
            this.genTime = genTime;
        }
    }

    public static interface IGenerateScriptFile {
        public void generateScriptFile(SourceColMetaGetter var1, IDataxReader var2, IDataxWriter var3, DataxWriter.BaseDataxWriterDescriptor var4, IDataxReaderContext var5, Set<String> var6, Optional<IDataxProcessor.TableMap> var7) throws IOException;
    }

    private class TableMapCreator {
        final boolean unStructedReader;
        final IDataxWriter writer;
        final TableAliasMapper tabAlias;
        private Function<IDataxReader, Map<String, ISelectedTab>> selectedTabsCall;

        public TableMapCreator() {
            this.unStructedReader = DataXCfgGenerator.this.dataxProcessor.isReaderUnStructed(DataXCfgGenerator.this.pluginCtx);
            this.writer = DataXCfgGenerator.this.dataxProcessor.getWriter(DataXCfgGenerator.this.pluginCtx);
            this.tabAlias = Objects.requireNonNull(DataXCfgGenerator.this.dataxProcessor.getTabAlias(DataXCfgGenerator.this.pluginCtx, false), "tabAlias can not be null");
            HashMap selectedTabsRef = new HashMap();
            this.selectedTabsCall = reader -> {
                Map<String, ISelectedTab> readerSelectedTabs = null;
                readerSelectedTabs = (Map<String, ISelectedTab>)selectedTabsRef.get(reader);
                if (readerSelectedTabs == null) {
                    readerSelectedTabs = reader.getSelectedTabs().stream().collect(Collectors.toMap(t -> t.getName(), t -> t));
                    selectedTabsRef.put(reader, readerSelectedTabs);
                }
                return readerSelectedTabs;
            };
        }

        Optional<IDataxProcessor.TableMap> build(IDataxReader reader, IDataxReaderContext readerContext) {
            if (readerContext == null) {
                throw new IllegalArgumentException("param readerContext can not be null");
            }
            if (reader == null) {
                throw new IllegalArgumentException("param reader can not be null");
            }
            Optional<IDataxProcessor.TableMap> tableMapper = null;
            if (!DataXCfgGenerator.this.dataxProcessor.isWriterSupportMultiTableInReader(DataXCfgGenerator.this.pluginCtx)) {
                if (this.tabAlias.isSingle()) {
                    Optional<IDataxProcessor.TableMap> first = this.tabAlias.getFirstTableMap();
                    if (first.isPresent()) {
                        tableMapper = first;
                    }
                } else if (this.writer instanceof IDataxProcessor.INullTableMapCreator) {
                    tableMapper = Optional.empty();
                }
                Objects.requireNonNull(tableMapper, "tabMapper can not be null,tabAlias.size()=" + this.tabAlias.size() + ",tabs:[" + this.tabAlias.getFromTabDesc() + "]");
            } else if (this.unStructedReader) {
                Optional<IDataxProcessor.TableMap> f = this.tabAlias.getFirstTableMap();
                if (!f.isPresent()) {
                    throw new IllegalStateException("tableMap can not be null");
                }
                tableMapper = f;
            } else if (DataXCfgGenerator.this.dataxProcessor.isRDBMS2UnStructed(DataXCfgGenerator.this.pluginCtx)) {
                IDataxProcessor.TableMap m = DataXCfgGenerator.this.createTableMap(this.tabAlias, this.selectedTabsCall.apply(reader), readerContext);
                tableMapper = Optional.of(m);
            } else if (DataXCfgGenerator.this.dataxProcessor.isRDBMS2RDBMS(DataXCfgGenerator.this.pluginCtx)) {
                tableMapper = Optional.of(DataXCfgGenerator.this.createTableMap(this.tabAlias, this.selectedTabsCall.apply(reader), readerContext));
            } else {
                throw new IllegalStateException("unexpect status");
            }
            return tableMapper;
        }
    }
}

