/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax.impl;

import com.qlangtech.tis.datax.impl.DataxReader;
import java.util.Objects;
import java.util.Optional;

public class DataXBasicProcessMeta {
    private boolean readerRDBMS;
    private boolean readerRDBMSChangeableInLifetime;
    private boolean explicitTable;
    private boolean writerRDBMS;
    private boolean isWriterSupportMultiTableInReader;

    public static DataXBasicProcessMeta getDataXBasicProcessMetaByReader(Optional<DataxReader.BaseDataxReaderDescriptor> readerDesc) {
        Objects.requireNonNull(readerDesc, "readerDesc can not be null");
        DataXBasicProcessMeta processMeta = new DataXBasicProcessMeta();
        if (readerDesc.isPresent()) {
            DataxReader.BaseDataxReaderDescriptor rd = readerDesc.get();
            processMeta.setReaderHasExplicitTable(rd.hasExplicitTable());
            processMeta.setReaderRDBMS(rd.isRdbms());
            processMeta.setReaderRDBMSChangeableInLifetime(rd.isRDBMSChangeableInLifetime());
        }
        return processMeta;
    }

    public boolean isReaderRDBMSChangeableInLifetime() {
        return this.readerRDBMSChangeableInLifetime;
    }

    public void setReaderRDBMSChangeableInLifetime(boolean readerRDBMSChangeableInLifetime) {
        this.readerRDBMSChangeableInLifetime = readerRDBMSChangeableInLifetime;
    }

    public boolean isWriterSupportMultiTableInReader() {
        return this.isWriterSupportMultiTableInReader;
    }

    public void setWriterSupportMultiTableInReader(boolean writerSupportMultiTableInReader) {
        this.isWriterSupportMultiTableInReader = writerSupportMultiTableInReader;
    }

    public boolean isReaderUnStructed() {
        return !this.readerRDBMS;
    }

    public boolean isWriterRDBMS() {
        return this.writerRDBMS;
    }

    public boolean isReaderRDBMS() {
        return this.readerRDBMS;
    }

    public boolean isExplicitTable() {
        return this.explicitTable;
    }

    public void setReaderRDBMS(boolean readerRDBMS) {
        this.readerRDBMS = readerRDBMS;
    }

    public void setReaderHasExplicitTable(boolean explicitTable) {
        this.explicitTable = explicitTable;
    }

    public void setWriterRDBMS(boolean writerRDBMS) {
        this.writerRDBMS = writerRDBMS;
    }

    public String toString() {
        return "ProcessMeta{readerRDBMS=" + this.readerRDBMS + ", writerRDBMS=" + this.writerRDBMS + "}";
    }

    public static interface IRDBMSSupport {
        public boolean isRDBMSSupport();
    }
}

