/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.pubhook.common.Nullable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class TableAliasMapper {
    public static final TableAliasMapper Null = new NULL();
    private final Map<String, TableAlias> mapper;

    public TableAliasMapper(Map<String, TableAlias> mapper) {
        this.mapper = mapper;
    }

    public boolean isNull() {
        return this.size() < 1 || this instanceof Nullable;
    }

    public void forEach(BiConsumer<String, TableAlias> action) {
        this.mapper.forEach(action);
    }

    public TableAlias get(String name) {
        return this.mapper.get(name);
    }

    public TableAlias getWithCheckNotNull(String name) {
        TableAlias alia = this.mapper.get(name);
        Objects.requireNonNull(alia, "tab:" + name + " relevant alias can not be null");
        return alia;
    }

    public TableAlias get(ISelectedTab tab) {
        return this.get(tab.getName());
    }

    public Optional<TableAlias> findFirst() {
        return this.mapper.values().stream().findFirst();
    }

    public boolean isSingle() {
        return this.mapper.size() == 1;
    }

    public Optional<IDataxProcessor.TableMap> getFirstTableMap() {
        Optional<IDataxProcessor.TableMap> first = this.mapper.values().stream().filter(t -> t instanceof IDataxProcessor.TableMap).map(t -> (IDataxProcessor.TableMap)t).findFirst();
        return first;
    }

    public int size() {
        return this.mapper.size();
    }

    public String getFromTabDesc() {
        return this.mapper.keySet().stream().collect(Collectors.joining(","));
    }

    private static class NULL
    extends TableAliasMapper
    implements Nullable {
        public NULL() {
            super(Collections.emptyMap());
        }

        @Override
        public TableAlias get(String name) {
            return null;
        }

        @Override
        public TableAlias getWithCheckNotNull(String name) {
            return this.get(name);
        }
    }
}

