/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.alibaba.fastjson.annotation.JSONField;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.impl.XmlFile;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.datax.common.AutoCreateTable;
import com.qlangtech.tis.util.IPluginContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class TableAlias
implements Describable<TableAlias> {
    public static final String KEY_FROM_TABLE_NAME = "fromTableName";
    private String from;
    private String to;
    private boolean shallNotRewriteTargetTableName;
    public static List<TableAlias> testTabAlias;

    public static TableAlias create(String from, String to) {
        if (StringUtils.isEmpty((String)from)) {
            throw new IllegalArgumentException("param from can not be empty");
        }
        if (StringUtils.isEmpty((String)to)) {
            throw new IllegalArgumentException("param to can not be empty");
        }
        TableAlias tableAlias = new TableAlias();
        tableAlias.setFrom(from);
        tableAlias.setTo(to);
        return tableAlias;
    }

    private static KeyedPluginStore.AppKey createAppSourceKey(IPluginContext context, String appName) {
        return new KeyedPluginStore.AppKey<TableAlias>(context, StoreResourceType.DataApp, appName, TableAlias.class);
    }

    public static void save(IPluginContext context, String appName, List<TableAlias> tableMaps) {
        try {
            TableAlias.createAppSourceKey(context, appName).getSotreFile().write(tableMaps, Collections.emptySet());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<TableAlias> load(IPluginContext context, String appName) {
        if (testTabAlias != null) {
            return testTabAlias;
        }
        try {
            XmlFile sotreFile = TableAlias.createAppSourceKey(context, appName).getSotreFile();
            if (!sotreFile.exists()) {
                return Collections.emptyList();
            }
            return (List)sotreFile.unmarshal(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TableAlias() {
    }

    public static void saveTableMapper(IPluginContext pluginContext, String dataxName, List<TableAlias> tableMaps) {
        if (StringUtils.isBlank((String)dataxName)) {
            throw new IllegalArgumentException("param dataxName can not be null");
        }
        TableAlias.save(pluginContext, dataxName, tableMaps);
        DataxProcessor dataxProcessor = (DataxProcessor)DataxProcessor.load(pluginContext, dataxName);
        dataxProcessor.afterSaved(pluginContext, Optional.empty());
    }

    public <T extends TableAlias> T setShallNotRewriteTargetTableName() {
        this.shallNotRewriteTargetTableName = true;
        return (T)this;
    }

    public boolean hasNotUseAlias() {
        return StringUtils.equalsIgnoreCase((String)this.getFrom(), (String)this.getTo());
    }

    public TableAlias(String from) {
        this.from = from;
        int indexOfCommon = StringUtils.indexOf((String)from, (String)".");
        this.to = indexOfCommon > -1 ? StringUtils.substring((String)from, (int)(indexOfCommon + 1)) : from;
    }

    private boolean isFromEqualTo() {
        return StringUtils.equals((String)this.from, (String)this.to);
    }

    public String createTargetTableName(AutoCreateTable autoCreateTable) {
        if (this.shallNotRewriteTargetTableName) {
            return this.getFrom();
        }
        return this.isFromEqualTo() ? autoCreateTable.appendTabPrefix(this.getFrom()) : this.getTo();
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    @Override
    @JSONField(serialize=false)
    public Descriptor<TableAlias> getDescriptor() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "TableAlias{from='" + this.from + "', to='" + this.to + "'}";
    }
}

