/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.google.common.collect.Maps;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.plugin.ds.ColumnMetaData;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import java.util.Map;
import java.util.Objects;

public class SourceColMetaGetter {
    private final IDataxReader dataXReader;
    private final Map<IDataxProcessor.TableMap, Map<String, ColumnMetaData>> tab2ColsMapper = Maps.newHashMap();

    public static SourceColMetaGetter getNone() {
        SourceColMetaGetter colMetaGetter = new SourceColMetaGetter(null, false){

            @Override
            public ColumnMetaData getColMeta(IDataxProcessor.TableMap tableMapper, String colName) {
                return null;
            }
        };
        return colMetaGetter;
    }

    public SourceColMetaGetter(IDataxReader dataXReader, boolean validateNull) {
        if (validateNull) {
            Objects.requireNonNull(dataXReader, "dataXReader");
        }
        this.dataXReader = dataXReader;
    }

    protected Map<String, ColumnMetaData> getColMetaDataMap(IDataxReader dataXReader, IDataxProcessor.TableMap tableMapper) {
        try {
            return ColumnMetaData.toMap(dataXReader.getTableMetadata(false, null, tableMapper));
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ColumnMetaData getColMeta(IDataxProcessor.TableMap tableMapper, String colName) {
        Map<String, ColumnMetaData> colsMeta = this.tab2ColsMapper.get(tableMapper);
        if (colsMeta == null) {
            colsMeta = this.getColMetaDataMap(this.dataXReader, tableMapper);
            this.tab2ColsMapper.put(tableMapper, colsMeta);
        }
        return colsMeta.get(colName);
    }
}

