/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.google.common.collect.Lists;
import com.qlangtech.tis.datax.DBDataXChildTask;
import com.qlangtech.tis.datax.IDataxReaderContext;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public interface IGroupChildTaskIterator
extends Iterator<IDataxReaderContext>,
Closeable {
    public static IGroupChildTaskIterator create(final IDataxReaderContext readerContext) {
        final AtomicReference<IDataxReaderContext> ref = new AtomicReference<IDataxReaderContext>(readerContext);
        return new IGroupChildTaskIterator(){

            @Override
            public boolean hasNext() {
                return ref.get() != null;
            }

            @Override
            public Map<String, List<DBDataXChildTask>> getGroupedInfo() {
                if (StringUtils.isEmpty((String)readerContext.getTaskName())) {
                    throw new IllegalStateException("readerContext.getTaskName() can not be empty");
                }
                return Collections.singletonMap(readerContext.getTaskName(), Lists.newArrayList((Object[])new DBDataXChildTask[]{new DBDataXChildTask(null, readerContext.getReaderContextId(), readerContext.getTaskName())}));
            }

            @Override
            public IDataxReaderContext next() {
                return ref.getAndSet(null);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    default public Map<String, List<DBDataXChildTask>> getGroupedInfo() {
        return Collections.emptyMap();
    }
}

