/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.datax.IDataXPluginMeta;
import com.qlangtech.tis.datax.IGroupChildTaskIterator;
import com.qlangtech.tis.datax.IStreamTableMeataCreator;
import com.qlangtech.tis.datax.SourceColMetaGetter;
import com.qlangtech.tis.extension.impl.SuFormProperties;
import com.qlangtech.tis.plugin.IRepositoryResourceScannable;
import com.qlangtech.tis.plugin.datax.SelectedTab;
import com.qlangtech.tis.plugin.datax.ThreadCacheTableCols;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.DataSourceMeta;
import com.qlangtech.tis.plugin.ds.IReaderSource;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.TableNotFoundException;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public interface IDataxReader
extends DataSourceMeta,
IDataXPluginMeta,
IStreamTableMeataCreator.ISourceStreamMetaCreator,
IRepositoryResourceScannable,
IReaderSource {
    default public SourceColMetaGetter createSourceColMetaGetter() {
        return new SourceColMetaGetter(this, true);
    }

    public boolean isSupportBatch();

    default public boolean hasMulitTable() {
        return this.getSelectedTabs().size() > 0;
    }

    public <T extends ISelectedTab> List<T> getSelectedTabs();

    public <T extends ISelectedTab> List<T> getUnfilledSelectedTabs();

    @Override
    default public ISelectedTab getSelectedTab(String tableName) {
        if (StringUtils.isEmpty((CharSequence)tableName)) {
            throw new IllegalArgumentException("param tableName can not be null");
        }
        for (ISelectedTab tab : this.getSelectedTabs()) {
            if (!tableName.equals(tab.getName())) continue;
            return tab;
        }
        throw new IllegalStateException("tableName:" + tableName + " relevant tab can not be null");
    }

    default public IGroupChildTaskIterator getSubTasks() {
        return this.getSubTasks(tab -> true);
    }

    public IGroupChildTaskIterator getSubTasks(Predicate<ISelectedTab> var1);

    public String getTemplate();

    default public ThreadCacheTableCols getContextTableColsStream(SuFormProperties.SuFormGetterContext context) {
        return this.getContextTableColsStream(context, targetTab -> {
            SelectedTab selectedTab = SelectedTab.loadFromTmp(Objects.requireNonNull(context.store, "store can not be null"), targetTab.getFullName());
            List filledSelectedTab = this.fillSelectedTabMeta(Collections.singletonList(selectedTab));
            Iterator iterator = filledSelectedTab.iterator();
            if (iterator.hasNext()) {
                SelectedTab tab = (SelectedTab)iterator.next();
                for (CMeta cmeta : tab.getCols()) {
                    if (cmeta.getType() != null) continue;
                    throw new IllegalStateException("table:" + context.getSubFormIdentityField() + ",col:" + cmeta.getName() + " relevant type can not be null");
                }
                return tab.getCols();
            }
            throw new IllegalStateException("can not arrive here");
        });
    }

    default public ThreadCacheTableCols getContextTableColsStream(SuFormProperties.SuFormGetterContext context, Function<EntityName, List<CMeta>> selectedCols) {
        IDataxReader plugin;
        if (context == null || context.isTest() || context.plugin == null) {
            return ThreadCacheTableCols.createEmptyTableCols();
        }
        IDataxReader dsMeta = plugin = this;
        ThreadCacheTableCols cols = context.getContextAttr("tableRelevantCols", key -> {
            try {
                EntityName targetTable = EntityName.parse((String)context.getSubFormIdentityField());
                return new ThreadCacheTableCols(plugin, targetTable, selectedCols, dsMeta.getTableMetadata(false, Objects.requireNonNull(context.param, "param can not be null").getPluginContext(), targetTable));
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return cols;
    }
}

