/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.alibaba.datax.plugin.writer.hdfswriter.HdfsColMeta;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.DBDataXChildTask;
import com.qlangtech.tis.datax.DataXCfgFile;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataxGlobalCfg;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.TableAlias;
import com.qlangtech.tis.datax.TableAliasMapper;
import com.qlangtech.tis.datax.impl.DataXCfgGenerator;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.datax.impl.TransformerInfo;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.StoreResourceTypeGetter;
import com.qlangtech.tis.plugin.datax.transformer.OutputParameter;
import com.qlangtech.tis.plugin.datax.transformer.RecordTransformerRules;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.IDBReservedKeys;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.trigger.JobTrigger;
import com.qlangtech.tis.realtime.yarn.rpc.SynResTarget;
import com.qlangtech.tis.util.IPluginContext;
import com.qlangtech.tis.util.UploadPluginMeta;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public interface IDataxProcessor
extends IdentityName,
StoreResourceTypeGetter,
Describable.IRefreshable {
    public static File getWriterDescFile(IPluginContext pluginContext, String dataXName) {
        File workDir = IDataxProcessor.getDataXWorkDir(pluginContext, dataXName);
        return new File(workDir, "writerDesc");
    }

    public static JSONObject createNode(String pipeName, StoreResourceType type) {
        if (StringUtils.isEmpty((String)pipeName)) {
            throw new IllegalArgumentException("param pipeName can not be empty");
        }
        if (type == null) {
            throw new IllegalArgumentException("param type can not be null");
        }
        JSONObject initNode = new JSONObject();
        initNode.put("dataxName", (Object)pipeName);
        initNode.put("appname", (Object)pipeName);
        initNode.put("storeResType", (Object)type.getType());
        return initNode;
    }

    @Override
    default public void refresh() {
    }

    default public JSONObject createNode() {
        return IDataxProcessor.createNode(this.identityValue(), this.getResType());
    }

    public Pair<List<RecordTransformerRules>, IPluginStore> getRecordTransformerRulesAndPluginStore(IPluginContext var1, String var2);

    default public SynResTarget getResTarget() {
        switch (this.getResType()) {
            case DataApp: {
                return SynResTarget.pipeline((String)this.identityValue());
            }
            case DataFlow: {
                return SynResTarget.transform((String)this.identityValue());
            }
        }
        throw new IllegalStateException("resType:" + this.getResType() + " is not support ");
    }

    public static File getDataXWorkDir(IPluginContext pluginContext, String appName) {
        KeyedPluginStore<DataxReader> readerStore = DataxReader.getPluginStore(pluginContext, appName);
        File targetFile = readerStore.getTargetFile().getFile();
        return targetFile.getParentFile();
    }

    public static Descriptor getWriterDescriptor(UploadPluginMeta pluginMeta) throws Exception {
        DataXName dataXName = pluginMeta.getDataXName(false);
        if (dataXName != null) {
            return IDataxProcessor.getWriterDescriptor(pluginMeta.getPluginContext(), dataXName.getPipelineName());
        }
        return null;
    }

    public static Descriptor getWriterDescriptor(IPluginContext pluginContext, String dataXName) {
        try {
            Objects.requireNonNull(pluginContext, "pluginContext can not be null");
            if (StringUtils.isEmpty((String)dataXName)) {
                throw new IllegalArgumentException("param dataXName can not be empty");
            }
            File writerDescFile = IDataxProcessor.getWriterDescFile(pluginContext, dataXName);
            if (!writerDescFile.exists()) {
                return null;
            }
            Descriptor descriptor = TIS.get().getDescriptor(FileUtils.readFileToString((File)writerDescFile, (Charset)TisUTF8.get()));
            return descriptor;
        }
        catch (IOException e) {
            throw new RuntimeException("dataXName:" + dataXName, e);
        }
    }

    default public void makeTempDir(String execId) throws Exception {
        File workingDir = this.getDataXWorkDir(null);
        FileUtils.copyDirectory((File)workingDir, (File)new File(workingDir.getParentFile(), ".tmp/" + workingDir.getName() + "-" + execId));
    }

    default public List<IDataxReader> getReaders(IPluginContext pluginCtx) {
        return Collections.singletonList(this.getReader(pluginCtx));
    }

    public IDataxReader getReader(IPluginContext var1, ISelectedTab var2);

    public IDataxReader getReader(IPluginContext var1);

    default public IDataxWriter getWriter(IPluginContext pluginCtx) {
        return this.getWriter(pluginCtx, true);
    }

    public IDataxWriter getWriter(IPluginContext var1, boolean var2);

    public IDataxGlobalCfg getDataXGlobalCfg();

    public File getDataxCfgDir(IPluginContext var1);

    default public File getDataXCfgFile(IPluginContext pluginCtx, DataXCfgFile criteria) {
        File cfgDir = this.getDataxCfgDir(pluginCtx);
        File cfgFile = new File(cfgDir, criteria.getDbFactoryId() + File.separator + criteria.getFileName());
        if (!cfgFile.exists()) {
            throw new IllegalStateException("target file:" + cfgFile.getAbsolutePath());
        }
        return cfgFile;
    }

    public File getDataxCreateDDLDir(IPluginContext var1);

    public void saveCreateTableDDL(IPluginContext var1, StringBuffer var2, String var3, boolean var4) throws IOException;

    public File getDataXWorkDir(IPluginContext var1);

    public boolean isReaderUnStructed(IPluginContext var1);

    public boolean isRDBMS2UnStructed(IPluginContext var1);

    public boolean isRDBMS2RDBMS(IPluginContext var1);

    public boolean isWriterSupportMultiTableInReader(IPluginContext var1);

    public DataXCfgGenerator.GenerateCfgs getDataxCfgFileNames(IPluginContext var1, Optional<JobTrigger> var2);

    public TableAliasMapper getTabAlias(IPluginContext var1, boolean var2);

    default public boolean isSupportBatch(IPluginContext pluginCtx) {
        List<IDataxReader> readers = this.getReaders(pluginCtx);
        DataxWriter writer = (DataxWriter)this.getWriter(pluginCtx);
        DataxWriter.BaseDataxWriterDescriptor writerDesc = (DataxWriter.BaseDataxWriterDescriptor)writer.getDescriptor();
        return this.isSupportBatch(readers) && writerDesc.isSupportBatch();
    }

    private boolean isSupportBatch(List<IDataxReader> readers) {
        for (IDataxReader readerDesc : readers) {
            if (readerDesc.isSupportBatch()) continue;
            return false;
        }
        return true;
    }

    public Set<TransformerInfo> getTransformerInfo(IPluginContext var1, Map<String, List<DBDataXChildTask>> var2);

    public static class TabCols {
        private final List<String> cols;
        private final IDBReservedKeys dbReservedKeys;

        public static TabCols create(IDBReservedKeys dbReservedKeys, TableMap tm, Optional<RecordTransformerRules> transformerRules) {
            List<IColMetaGetter> cols = tm.appendTransformerRuleCols(transformerRules);
            return new TabCols(dbReservedKeys, cols.stream().map(c -> c.getName()).collect(Collectors.toList()));
        }

        private TabCols(IDBReservedKeys dbReservedKeys, List<String> cols) {
            this.cols = cols;
            this.dbReservedKeys = dbReservedKeys;
        }

        public List<String> getRawCols() {
            return this.cols;
        }

        public String getColsQuotes() {
            return this.getColumnWithLink(Optional.of("\""));
        }

        public String getCols() {
            return this.getColumnWithLink(Optional.empty());
        }

        protected String getColumnWithLink(Optional<String> includeIn) {
            return this.cols.stream().map(r -> this.dbReservedKeys.getEscapedEntity(includeIn, r)).collect(Collectors.joining(","));
        }
    }

    public static class TableMap
    extends TableAlias {
        private final ISelectedTab tab;

        public List<IColMetaGetter> appendTransformerRuleCols(Optional<RecordTransformerRules> transformerRules) {
            List cols = transformerRules.map(rule -> {
                RecordTransformerRules.TransformerOverwriteCols<OutputParameter> outputParameters = rule.overwriteCols(this.getSourceCols());
                return outputParameters.getCols().stream().map(c -> c).collect(Collectors.toList());
            }).orElseGet(() -> this.getSourceCols().stream().map(c -> c).collect(Collectors.toList()));
            return cols;
        }

        public TableMap(TableAlias tabAlia, ISelectedTab tab) {
            this(tab);
            this.setTo(tabAlia.getTo());
            this.setFrom(tabAlia.getFrom());
        }

        public TableMap(ISelectedTab tab) {
            super(tab.getName());
            this.tab = tab;
        }

        public TableMap(List<CMeta> cmetas) {
            this(Optional.empty(), cmetas);
        }

        public TableMap(final Optional<String> tabName, List<CMeta> cmetas) {
            final List<CMeta> cMetas = this.rewriteCols(cmetas);
            final List pks = cMetas.stream().filter(c -> c.isPk()).map(c -> c.getName()).collect(Collectors.toUnmodifiableList());
            this.tab = new ISelectedTab(){

                public String getName() {
                    return (String)tabName.get();
                }

                public List<String> getPrimaryKeys() {
                    return pks;
                }

                public List<CMeta> getCols() {
                    return cMetas;
                }
            };
        }

        protected List<CMeta> rewriteCols(List<CMeta> cmetas) {
            return cmetas;
        }

        public List<String> getPrimaryKeys() {
            return this.tab.getPrimaryKeys();
        }

        public static TableMap create(String tableName, List<IColMetaGetter> cols) {
            ArrayList cmetas = Lists.newArrayList();
            CMeta cm = null;
            for (IColMetaGetter col : cols) {
                cm = TableMap.getCMeta(col);
                cmetas.add(cm);
            }
            return TableMap.createByColMeta(tableName, cmetas);
        }

        public static CMeta getCMeta(IColMetaGetter col) {
            CMeta cm = new CMeta();
            if (col instanceof HdfsColMeta) {
                HdfsColMeta c = (HdfsColMeta)col;
                cm.setName(c.colName);
                cm.setNullable(c.nullable);
                cm.setType(c.type);
                cm.setPk(Boolean.valueOf(c.pk));
            } else {
                cm.setName(col.getName());
                cm.setNullable(true);
                cm.setType(col.getType());
                cm.setPk(Boolean.valueOf(col.isPk()));
            }
            return cm;
        }

        public static TableMap createByColMeta(String tableName, List<CMeta> colMetas) {
            TableMap tableMapper = new TableMap(colMetas);
            tableMapper.setFrom(tableName);
            tableMapper.setTo(tableName);
            return tableMapper;
        }

        public List<CMeta> getSourceCols() {
            return this.getSourceTab().getCols();
        }

        @JSONField(serialize=false)
        public ISelectedTab getSourceTab() {
            Objects.requireNonNull(this.tab, "param tab can not be null");
            return this.tab;
        }

        public int hashCode() {
            return Objects.hashCode(this.getFrom());
        }
    }

    public static interface INullTableMapCreator {
    }
}

