/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.datax.IDataXGenerateCfgs;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxWriter;
import com.qlangtech.tis.exec.ExecutePhaseRange;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPostTrigger;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskPreviousTrigger;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.tuple.Pair;

public interface IDataXBatchPost {
    public static final String KEY_POST = "post_";
    public static final String KEY_PREP = "prep_";

    public static Pair<IRemoteTaskPreviousTrigger, IRemoteTaskPostTrigger> process(IDataxProcessor appSource, ISelectedTab entry, BiFunction<IDataXBatchPost, EntityName, Pair<IRemoteTaskPreviousTrigger, IRemoteTaskPostTrigger>> consumer) {
        if (entry == null) {
            throw new IllegalArgumentException("param entry can not be null");
        }
        IDataxWriter writer = Objects.requireNonNull(appSource, "appSource can not be null").getWriter(null, true);
        if (writer instanceof IDataXBatchPost) {
            IDataXBatchPost batchPostTask = (IDataXBatchPost)((Object)writer);
            EntityName entryName = batchPostTask.parseEntity(entry);
            return Objects.requireNonNull(consumer, "consumer can not be null").apply(batchPostTask, Objects.requireNonNull(entryName, "entryName can not be null"));
        }
        return Pair.of(null, null);
    }

    public EntityName parseEntity(ISelectedTab var1);

    public ExecutePhaseRange getPhaseRange();

    public static String getPreExecuteTaskName(EntityName tab) {
        return KEY_PREP + tab.getTabName();
    }

    public IRemoteTaskPreviousTrigger createPreExecuteTask(IExecChainContext var1, EntityName var2, ISelectedTab var3);

    public IRemoteTaskPostTrigger createPostTask(IExecChainContext var1, EntityName var2, ISelectedTab var3, IDataXGenerateCfgs var4);

    public static enum LifeCycleHook {
        Prep("prep_"),
        Post("post_");

        private final String token;

        private LifeCycleHook(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }
    }
}

