/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.manage.common.Option;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public enum Delimiter {
    Comma("comma", ','),
    Tab("tab", '\t'),
    Char001("char001", '\u0001'),
    Char005("char005", '\u0005');

    public final String token;
    public final char val;

    public static List<Option> options() {
        return Arrays.stream(Delimiter.values()).map(e -> new Option(e.name(), (Object)e.token)).collect(Collectors.toList());
    }

    public static Delimiter parse(String token) {
        for (Delimiter d : Delimiter.values()) {
            if (!d.token.equalsIgnoreCase(token)) continue;
            return d;
        }
        throw new IllegalStateException("illegal token:" + token);
    }

    public static Delimiter parseByVal(String val) {
        if (StringUtils.isEmpty((String)val)) {
            throw new IllegalArgumentException("param val can not be empty");
        }
        for (Delimiter d : Delimiter.values()) {
            if (d.val != val.charAt(0)) continue;
            return d;
        }
        throw new IllegalStateException("illegal value:" + val);
    }

    private Delimiter(String token, char val) {
        this.token = token;
        this.val = val;
    }
}

