/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.alibaba.citrus.turbine.Context;
import com.google.common.collect.Maps;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IManipulateStatus;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.extension.IDescribableManipulate;
import com.qlangtech.tis.plugin.IEndTypeGetter;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.KeyedPluginStore;
import com.qlangtech.tis.plugin.alert.AlertChannel;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.ds.manipulate.ManipulateItemsProcessor;
import com.qlangtech.tis.plugin.ds.manipulate.ManipuldateUtils;
import com.qlangtech.tis.util.IPluginContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class DefaultDataXProcessorManipulate
implements Describable<DefaultDataXProcessorManipulate>,
IPluginStore.ManipuldateProcessor,
IdentityName {
    @FormField(identity=true, ordinal=0, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.identity})
    public String name;
    private static final ConcurrentMap<String, DataXProcessorTemplateManipulateStore> processorManipulateRegister = Maps.newConcurrentMap();

    public static DataXProcessorTemplateManipulateStore getManipulateStore(String pipelineName) {
        if (StringUtils.isEmpty((CharSequence)pipelineName)) {
            throw new IllegalArgumentException("param pipelineName can not be empty");
        }
        return processorManipulateRegister.computeIfAbsent(pipelineName, pipe -> {
            DataXProcessorTemplateManipulateStore store = new DataXProcessorTemplateManipulateStore();
            for (DefaultDataXProcessorManipulate manipulate : DefaultDataXProcessorManipulate.getPluginStore(null, DataXName.createDataXPipeline((String)pipe)).getPlugins()) {
                store.replace(manipulate);
            }
            return store;
        });
    }

    public static IPluginStore<DefaultDataXProcessorManipulate> getPluginStore(IPluginContext context, DataXName appName) {
        if (appName == null) {
            throw new IllegalArgumentException("param appName can not be empty");
        }
        KeyedPluginStore.AppKey<DefaultDataXProcessorManipulate> appKey = new KeyedPluginStore.AppKey<DefaultDataXProcessorManipulate>(context, appName.getType(), appName.getPipelineName(), DefaultDataXProcessorManipulate.class);
        IPluginStore<DefaultDataXProcessorManipulate> pluginStore = TIS.getPluginStore(appKey);
        return pluginStore;
    }

    public final String identityValue() {
        return this.name;
    }

    public final boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDataXProcessorManipulate that = (DefaultDataXProcessorManipulate)o;
        return Objects.equals(this.name, that.name);
    }

    public final int hashCode() {
        return Objects.hashCode(this.name);
    }

    protected String getNewIdentityName() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void manipuldateProcess(IPluginContext pluginContext, Optional<Context> context) {
        Class<DefaultDataXProcessorManipulate> clazz = DefaultDataXProcessorManipulate.class;
        synchronized (DefaultDataXProcessorManipulate.class) {
            List<?> existPlugins;
            ManipulateItemsProcessor itemsProcessor = ManipuldateUtils.instance(pluginContext, context.orElseThrow(), this.getNewIdentityName(), meta -> {});
            if (itemsProcessor == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            BasicDesc desc = (BasicDesc)this.getDescriptor();
            ProcessorManipulateManager<?> store = DefaultDataXProcessorManipulate.loadPlugins(pluginContext, this.getClass(), itemsProcessor.getOriginIdentityId().orElseThrow(() -> new IllegalStateException("originId can not be null")), desc);
            if (itemsProcessor.isDeleteProcess()) {
                store.delete(pluginContext, context, this);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            if (desc.isManipulateStorable() && !itemsProcessor.isUpdateProcess() && CollectionUtils.isNotEmpty(existPlugins = store.getTargetInstancePlugin())) {
                for (DefaultDataXProcessorManipulate i : existPlugins) {
                    pluginContext.addErrorMessage(context.get(), "\u5b9e\u4f8b'" + i.identityValue() + "'\u5df2\u7ecf\u914d\u7f6e\uff0c\u4e0d\u80fd\u518d\u521b\u5efa\u65b0\u5b9e\u4f8b");
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this.afterManipuldateProcess(pluginContext, context, itemsProcessor);
            if (desc.isManipulateStorable()) {
                store.replace(pluginContext, context, this);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    protected abstract void afterManipuldateProcess(IPluginContext var1, Optional<Context> var2, ManipulateItemsProcessor var3);

    public static <T extends DefaultDataXProcessorManipulate> ProcessorManipulateManager<T> loadPlugins(IPluginContext context, Class<T> clazz, DataXName pipelineName, IDescribableManipulate.IManipulateStorable storable) {
        IPluginStore<DefaultDataXProcessorManipulate> store = DefaultDataXProcessorManipulate.getPluginStore(context, pipelineName);
        List result = store.getPlugins().stream().map(p -> p).collect(Collectors.toList());
        return new ProcessorManipulateManager<T>(pipelineName, clazz, store, result, storable);
    }

    @Override
    public final Descriptor<DefaultDataXProcessorManipulate> getDescriptor() {
        Descriptor<DefaultDataXProcessorManipulate> desc = Describable.super.getDescriptor();
        if (!(desc instanceof BasicDesc)) {
            throw new IllegalStateException("descriptor:" + desc.getClass().getName() + " must extend from " + BasicDesc.class.getSimpleName());
        }
        return desc;
    }

    protected static class BasicDesc
    extends Descriptor<DefaultDataXProcessorManipulate>
    implements IEndTypeGetter,
    IDescribableManipulate.IManipulateStorable {
    }

    public static class ProcessorManipulateManager<T extends DefaultDataXProcessorManipulate> {
        private final Class<T> targetClazz;
        private final IPluginStore<DefaultDataXProcessorManipulate> store;
        private final List<? extends DefaultDataXProcessorManipulate> plugins;
        private final IDescribableManipulate.IManipulateStorable storable;
        private final DataXName pipelineName;

        public ProcessorManipulateManager(DataXName pipelineName, Class<T> targetClazz, IPluginStore<DefaultDataXProcessorManipulate> store, List<? extends DefaultDataXProcessorManipulate> plugins, IDescribableManipulate.IManipulateStorable storable) {
            this.targetClazz = targetClazz;
            this.store = store;
            this.plugins = plugins;
            this.storable = storable;
            this.pipelineName = Objects.requireNonNull(pipelineName, "pipelineName can not be null");
        }

        public List<T> getTargetInstancePlugin() {
            return this.plugins.stream().filter(p -> this.targetClazz.isAssignableFrom(p.getClass())).map(this.targetClazz::cast).collect(Collectors.toList());
        }

        public void replace(IPluginContext pluginContext, Optional<Context> context, DefaultDataXProcessorManipulate beReplace) {
            if (!this.storable.isManipulateStorable()) {
                throw new UnsupportedOperationException();
            }
            List dlist = this.getPluginsExclude(beReplace);
            dlist.add(new Descriptor.ParseDescribable<DefaultDataXProcessorManipulate>(beReplace));
            this.store.setPlugins(pluginContext, context, dlist, true);
            DataXProcessorTemplateManipulateStore manipulateStore = this.getManipulateStore();
            manipulateStore.replace(beReplace);
        }

        private DataXProcessorTemplateManipulateStore getManipulateStore() {
            return DefaultDataXProcessorManipulate.getManipulateStore(this.pipelineName.getPipelineName());
        }

        public void delete(IPluginContext pluginContext, Optional<Context> context, IdentityName id) {
            if (!this.storable.isManipulateStorable()) {
                throw new UnsupportedOperationException();
            }
            List dlist = this.getPluginsExclude(id);
            this.store.setPlugins(pluginContext, context, dlist, true);
            DataXProcessorTemplateManipulateStore manipulateStore = this.getManipulateStore();
            manipulateStore.remove(id);
        }

        private List<Descriptor.ParseDescribable<DefaultDataXProcessorManipulate>> getPluginsExclude(IdentityName id) {
            List<Descriptor.ParseDescribable<DefaultDataXProcessorManipulate>> dlist = this.plugins.stream().filter(p -> !StringUtils.equals((CharSequence)Objects.requireNonNull(id, "param id can not be null").identityValue(), (CharSequence)p.identityValue())).map(p -> new Descriptor.ParseDescribable<DefaultDataXProcessorManipulate>((DefaultDataXProcessorManipulate)p)).collect(Collectors.toList());
            return dlist;
        }
    }

    public static interface MonitorForEventsManager
    extends IManipulateStatus {
        public static final String KEY_ALERT = "alert";

        public boolean isActivate();

        public void addSendCount();

        public List<AlertChannel> getAlertChannels();
    }

    public static final class DataXProcessorTemplateManipulateStore {
        private Map<IdentityName, DefaultDataXProcessorManipulate> manipuldateStore = Maps.newHashMap();

        public Collection<DefaultDataXProcessorManipulate> getManipulates() {
            return this.manipuldateStore.values();
        }

        public DefaultDataXProcessorManipulate getManipuldate(IdentityName id) {
            return this.manipuldateStore.get(id);
        }

        public MonitorForEventsManager getAlertManager() {
            DefaultDataXProcessorManipulate manipuldate = this.getManipuldate(IdentityName.create((String)"alert"));
            return (MonitorForEventsManager)((Object)manipuldate);
        }

        public void replace(DefaultDataXProcessorManipulate replace) {
            this.manipuldateStore.put(IdentityName.create((IdentityName)replace), replace);
        }

        public void remove(IdentityName replace) {
            this.manipuldateStore.remove(IdentityName.create((IdentityName)replace));
        }
    }
}

