/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.config.ParamsConfig;
import com.qlangtech.tis.datax.DataXJobSingleProcessorException;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IPluginStore;
import com.qlangtech.tis.plugin.MemorySpecification;
import com.qlangtech.tis.plugin.annotation.FormField;
import com.qlangtech.tis.plugin.annotation.FormFieldType;
import com.qlangtech.tis.plugin.annotation.Validator;
import com.qlangtech.tis.plugin.impl.DefaultMemorySpecification;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.util.IPluginContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public abstract class DataXJobSubmitParams
extends ParamsConfig
implements IPluginStore.AfterPluginSaved {
    private static final String LOCAL_DATAX_SUBMIT_PARAMS = "DataXSubmitParams";
    private static final String FIELD_NAME = "name";
    @FormField(ordinal=0, identity=true, type=FormFieldType.INPUTTEXT, validate={Validator.require, Validator.identity})
    public String name;
    @FormField(ordinal=1, type=FormFieldType.INT_NUMBER, validate={Validator.require, Validator.integer})
    public Integer maxJobs;
    @FormField(ordinal=2, type=FormFieldType.INT_NUMBER, validate={Validator.require, Validator.integer})
    public Integer pipelineParallelism;
    @FormField(ordinal=3, type=FormFieldType.INT_NUMBER, validate={Validator.require, Validator.integer})
    public Integer vmParallelism;
    @FormField(ordinal=4, type=FormFieldType.INT_NUMBER, validate={Validator.require, Validator.integer})
    public Integer taskExpireHours;
    @FormField(ordinal=5, validate={Validator.require})
    public MemorySpecification memorySpec;
    private transient ArrayBlockingQueue<Long> availableAreaController;

    public String getJavaMemorySpec() {
        return Objects.requireNonNull(this.memorySpec).getJavaMemorySpec();
    }

    private ArrayBlockingQueue<Long> getAvailableAreaController() {
        if (this.availableAreaController == null) {
            this.availableAreaController = new ArrayBlockingQueue(this.vmParallelism);
        }
        return this.availableAreaController;
    }

    @Override
    public void afterSaved(IPluginContext pluginContext, Optional<Context> context) {
        this.availableAreaController = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execParallelTask(String dataxName, ParallelTaskRunnable runnable) throws IOException, InterruptedException, DataXJobSingleProcessorException {
        ArrayBlockingQueue<Long> parallelismController = this.getAvailableAreaController();
        Objects.requireNonNull(parallelismController);
        if (parallelismController.offer(System.currentTimeMillis(), 1L, TimeUnit.HOURS)) {
            try {
                runnable.run();
            }
            finally {
                parallelismController.take();
            }
        } else {
            throw new DataXJobSingleProcessorException("dataX:" + dataxName + ",job submit timeout,wait for 1 hours");
        }
    }

    public final DataXJobSubmitParams createConfigInstance() {
        return this;
    }

    public static DataXJobSubmitParams getDftIfEmpty() {
        return DataXJobSubmitParams.getSubmitParams().orElseGet(() -> {
            DataXJobSubmitParams dft = new DataXJobSubmitParams(){};
            dft.name = "default";
            dft.maxJobs = 40;
            dft.vmParallelism = 1;
            dft.pipelineParallelism = 1;
            dft.memorySpec = new DefaultMemorySpecification();
            dft.taskExpireHours = 10;
            return dft;
        });
    }

    public static Integer dftMaxJobs() {
        return 40;
    }

    public static Integer dftParallelism() {
        return 1;
    }

    private static Optional<DataXJobSubmitParams> getSubmitParams() {
        List cfgs = ParamsConfig.getItems(LOCAL_DATAX_SUBMIT_PARAMS);
        Iterator iterator = cfgs.iterator();
        if (iterator.hasNext()) {
            DataXJobSubmitParams cfg = (DataXJobSubmitParams)iterator.next();
            return Optional.of(cfg);
        }
        return Optional.empty();
    }

    public String identityValue() {
        return this.name;
    }

    public static abstract class DefaultDesc
    extends ParamsConfig.BasicParamsConfigDescriptor {
        private static final String FIELD_PIPELINE_PARALLELISM = "pipelineParallelism";
        private static final String FIELD_VM_PARALLELISM = "vmParallelism";

        public DefaultDesc() {
            super(DataXJobSubmitParams.LOCAL_DATAX_SUBMIT_PARAMS);
        }

        @Override
        public String getDisplayName() {
            return DataXJobSubmitParams.LOCAL_DATAX_SUBMIT_PARAMS;
        }

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            return this.verify(msgHandler, context, postFormVals);
        }

        public boolean validateTaskExpireHours(IFieldErrorHandler msgHandler, Context context, String fieldName, String value) {
            Integer hours = Integer.parseInt(value);
            if (hours < 1) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5c0f\u4e8e1", new Object[0]);
                return false;
            }
            int maxHours = 24;
            if (hours > maxHours) {
                msgHandler.addFieldError(context, fieldName, "\u4e0d\u80fd\u5927\u4e8e" + maxHours + "\u5c0f\u65f6", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        protected boolean verify(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            Optional<DataXJobSubmitParams> params = DataXJobSubmitParams.getSubmitParams();
            DataXJobSubmitParams submitParams = (DataXJobSubmitParams)postFormVals.newInstance();
            if (params.isPresent()) {
                DataXJobSubmitParams already = params.get();
                if (!StringUtils.equals((CharSequence)already.name, (CharSequence)submitParams.name)) {
                    msgHandler.addFieldError(context, DataXJobSubmitParams.FIELD_NAME, "\u8be5\u914d\u7f6e\u5fc5\u987b\u4e3a\u5355\u5b9e\u4f8b\uff0c\u5df2\u7ecf\u5b58\u5728ID\u4e3a\uff1a" + already.name + "\u7684\u914d\u7f6e\u5b9e\u4f8b", new Object[0]);
                    return false;
                }
            }
            boolean validateFaild = false;
            if (submitParams.maxJobs < 40) {
                msgHandler.addFieldError(context, "maxJobs", "\u4e0d\u80fd\u5c0f\u4e8e40", new Object[0]);
                validateFaild = true;
            }
            if (submitParams.pipelineParallelism < 1) {
                msgHandler.addFieldError(context, FIELD_PIPELINE_PARALLELISM, "\u4e0d\u80fd\u5c0f\u4e8e1", new Object[0]);
                validateFaild = true;
            }
            if (submitParams.vmParallelism < 1) {
                msgHandler.addFieldError(context, FIELD_VM_PARALLELISM, "\u4e0d\u80fd\u5c0f\u4e8e1", new Object[0]);
                validateFaild = true;
            }
            if (!validateFaild && submitParams.pipelineParallelism > submitParams.vmParallelism) {
                msgHandler.addFieldError(context, FIELD_PIPELINE_PARALLELISM, "\u4e0d\u80fd\u5927\u4e8e" + submitParams.vmParallelism, new Object[0]);
                msgHandler.addFieldError(context, FIELD_VM_PARALLELISM, "\u4e0d\u80fd\u5c0f\u4e8e" + submitParams.pipelineParallelism, new Object[0]);
                validateFaild = true;
            }
            return !validateFaild;
        }
    }

    public static interface ParallelTaskRunnable {
        public void run() throws IOException, InterruptedException, DataXJobSingleProcessorException;
    }
}

