/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.datax.common.element.QueryCriteria;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.annotation.Public;
import com.qlangtech.tis.build.task.IBuildHistory;
import com.qlangtech.tis.coredefine.module.action.TargetResName;
import com.qlangtech.tis.coredefine.module.action.TriggerBuildResult;
import com.qlangtech.tis.datax.CuratorDataXTaskMessage;
import com.qlangtech.tis.datax.DBDataXChildTask;
import com.qlangtech.tis.datax.DataXCfgFile;
import com.qlangtech.tis.datax.DataXJobInfo;
import com.qlangtech.tis.datax.DataXJobSubmitParams;
import com.qlangtech.tis.datax.DataXName;
import com.qlangtech.tis.datax.IDataXPowerJobSubmit;
import com.qlangtech.tis.datax.IDataXTaskRelevant;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.IDataxReader;
import com.qlangtech.tis.datax.TimeFormat;
import com.qlangtech.tis.datax.job.DataXJobWorker;
import com.qlangtech.tis.datax.preview.IPreviewRowsDataService;
import com.qlangtech.tis.datax.preview.PreviewRowsData;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.extension.ExtensionList;
import com.qlangtech.tis.extension.TISExtensible;
import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.ds.CMeta;
import com.qlangtech.tis.plugin.ds.DBIdentity;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import com.qlangtech.tis.plugin.ds.ISelectedTab;
import com.qlangtech.tis.plugin.ds.TableInDB;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.runtime.module.misc.IMessageHandler;
import com.qlangtech.tis.util.RobustReflectionConverter2;
import com.qlangtech.tis.web.start.TisAppLaunch;
import com.qlangtech.tis.workflow.pojo.IWorkflow;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.tis.hadoop.rpc.RpcServiceReference;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TISExtensible
@Public
public abstract class DataXJobSubmit
implements IPreviewRowsDataService {
    private static final Logger logger = LoggerFactory.getLogger(DataXJobSubmit.class);
    public static final String KEY_DATAX_READERS = "dataX_readers";
    public static final int MAX_TABS_NUM_IN_PER_JOB = 40;
    public static final int DEFAULT_PARALLELISM_IN_VM = 1;
    public static Callable<DataXJobSubmit> mockGetter;

    public static void main(String[] args) throws Exception {
        Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("com/google/common/base/Preconditions.class");
        while (resources.hasMoreElements()) {
            System.out.println(resources.nextElement());
        }
    }

    public static InstanceType getDataXTriggerType() {
        InstanceType execType;
        DataXJobWorker jobWorker = DataXJobWorker.getJobWorker(TargetResName.K8S_DATAX_INSTANCE_NAME, Optional.of(DataXJobWorker.K8SWorkerCptType.Server));
        boolean dataXWorkerServiceOnDuty = jobWorker != null && jobWorker.inService();
        InstanceType instanceType = execType = dataXWorkerServiceOnDuty ? InstanceType.DISTRIBUTE : InstanceType.LOCAL;
        if (execType == InstanceType.LOCAL && TisAppLaunch.isTestMock()) {
            return InstanceType.EMBEDDED;
        }
        return execType;
    }

    public static DataXJobSubmit getDataXJobSubmit() {
        Optional<DataXJobSubmit> dataXJobSubmit = DataXJobSubmit.getDataXJobSubmit(false, DataXJobSubmit.getDataXTriggerType());
        DataXJobSubmit jobSubmit = dataXJobSubmit.orElseThrow(() -> new IllegalStateException("dataXJobSubmit must be present"));
        return jobSubmit;
    }

    public static Optional<IDataXPowerJobSubmit> getPowerJobSubmit() {
        DataXJobSubmit dataXJobSubmit = DataXJobSubmit.getDataXJobSubmit();
        logger.info("get dataXJobSubmit instanceof :" + dataXJobSubmit.getClass().getName() + ",triggerType:" + DataXJobSubmit.getDataXTriggerType());
        if (dataXJobSubmit instanceof IDataXPowerJobSubmit) {
            return Optional.of((IDataXPowerJobSubmit)((Object)dataXJobSubmit));
        }
        return Optional.empty();
    }

    public static Optional<DataXJobSubmit> getDataXJobSubmit(boolean dryRun, InstanceType expectDataXJobSumit) {
        try {
            if (mockGetter != null) {
                return Optional.ofNullable(mockGetter.call());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InstanceType targetType = dryRun ? InstanceType.EMBEDDED : expectDataXJobSumit;
        ExtensionList<DataXJobSubmit> jobSumits = Objects.requireNonNull(TIS.get(), "tis instance can not be null").getExtensionList(DataXJobSubmit.class);
        Optional<DataXJobSubmit> jobSubmit = jobSumits.stream().filter(jsubmit -> targetType == jsubmit.getType()).findFirst();
        return jobSubmit;
    }

    public static Optional<DataXJobSubmit> getDataXJobSubmit(IJoinTaskContext joinTaskContext, InstanceType expectDataXJobSumit) {
        return DataXJobSubmit.getDataXJobSubmit(joinTaskContext.isDryRun(), expectDataXJobSumit);
    }

    @Override
    public PreviewRowsData previewRowsData(DataXName dataXName, String tableName, QueryCriteria queryCriteria) {
        throw new UnsupportedOperationException();
    }

    public abstract InstanceType getType();

    public CuratorDataXTaskMessage getDataXJobDTO(IDataXJobContext jobContext, DataXJobInfo dataXJobInfo, IDataxProcessor processor) {
        IJoinTaskContext taskContext = jobContext.getTaskContext();
        if (processor.getResType() == null) {
            throw new NullPointerException("dataXJobDTO.getResType() can not be null");
        }
        CuratorDataXTaskMessage msg = new CuratorDataXTaskMessage();
        if (taskContext.hasIndexName()) {
            msg.setDataXName(taskContext.getIndexName());
        } else {
            msg.setDataXName(processor.identityValue());
        }
        msg.setTaskSerializeNum(jobContext.getTaskSerializeNum());
        msg.setJobId(taskContext.getTaskId());
        msg.setJobName(dataXJobInfo.serialize());
        msg.setExecTimeStamp(taskContext.getPartitionTimestampWithMillis());
        msg.setResType(processor.getResType());
        if (jobContext.getSpecifiedLocalLoggerPath() != null) {
            msg.setLocalLoggerPath(jobContext.getSpecifiedLocalLoggerPath().getAbsolutePath());
        }
        msg.setDisableGrpcRemoteServerConnect(jobContext.isDisableGrpcRemoteServerConnect());
        PhaseStatusCollection preTaskStatus = (PhaseStatusCollection)taskContext.loadPhaseStatusFromLatest();
        logger.info("preTaskStatus is{} null", (Object)(preTaskStatus != null ? " not" : ""));
        DumpPhaseStatus.TableDumpStatus dataXJob = null;
        if (preTaskStatus != null && (dataXJob = preTaskStatus.getDumpPhase().getTable(dataXJobInfo.jobFileName)) != null && dataXJob.getAllRows() > 0) {
            msg.setAllRowsApproximately(dataXJob.getReadRows());
        } else {
            msg.setAllRowsApproximately(-1);
        }
        logger.info("job:{} relevant DataXJob:{}", (Object)dataXJobInfo.jobFileName, dataXJob != null ? "{" + dataXJob.getReadRows() + "}" : " is null");
        return msg;
    }

    public abstract TriggerBuildResult triggerJob(IControlMsgHandler var1, Context var2, DataXName var3, Optional<Long> var4, Optional<WorkFlowBuildHistory> var5);

    public abstract TriggerBuildResult triggerWorkflowJob(IControlMsgHandler var1, Context var2, IWorkflow var3, Boolean var4, Optional<Long> var5, Optional<WorkFlowBuildHistory> var6);

    public abstract boolean cancelTask(IControlMsgHandler var1, Context var2, IBuildHistory var3);

    public final IRemoteTaskTrigger createDataXJob(IDataXJobContext taskContext, RpcServiceReference statusRpc, IDataxProcessor processor, TableDataXEntity tabDataXEntity) {
        DataXJobInfo jobName = this.getDataXJobInfo(tabDataXEntity, taskContext, processor);
        if (this.getType() == InstanceType.DISTRIBUTE) {
            RobustReflectionConverter2.PluginMetas pluginMetas = RobustReflectionConverter2.PluginMetas.collectMetas(metas -> {});
        }
        CuratorDataXTaskMessage dataXJobDTO = this.getDataXJobDTO(taskContext, jobName, processor);
        return this.createDataXJob(taskContext, statusRpc, jobName, processor, dataXJobDTO);
    }

    public abstract IRemoteTaskTrigger createDataXJob(IDataXJobContext var1, RpcServiceReference var2, DataXJobInfo var3, IDataxProcessor var4, CuratorDataXTaskMessage var5);

    private DataXJobInfo getDataXJobInfo(TableDataXEntity tabDataXEntity, IDataXJobContext taskContext, IDataxProcessor dataxProcessor) {
        List readers = (List)taskContext.getTaskContext().getAttribute(KEY_DATAX_READERS, () -> dataxProcessor.getReaders(null));
        if (CollectionUtils.isEmpty((Collection)readers)) {
            throw new IllegalStateException("readers can not be empty");
        }
        return DataXJobSubmit.getDataXJobInfo(tabDataXEntity, p -> {
            TableInDB tabsInDB = (TableInDB)p.getLeft();
            DataXJobInfo jobName = tabsInDB.createDataXJobInfo(tabDataXEntity, false);
            return jobName;
        }, readers);
    }

    public static <T> T getDataXJobInfo(DBIdentity targetDBId, Function<Pair<TableInDB, IDataxReader>, T> convert, List<IDataxReader> readers) {
        for (IDataxReader reader : readers) {
            TableInDB tabsInDB = reader.getTablesInDB();
            if (!tabsInDB.isMatch(targetDBId)) continue;
            return convert.apply((Pair<TableInDB, IDataxReader>)Pair.of((Object)tabsInDB, (Object)reader));
        }
        throw new IllegalStateException(targetDBId.toString());
    }

    public abstract IDataXJobContext createJobContext(IExecChainContext var1);

    public static interface IDataXJobContext
    extends IDataXTaskRelevant {
        public static final AtomicInteger order = new AtomicInteger();

        public static IDataXJobContext create(final IExecChainContext parentContext) {
            if (parentContext == null) {
                throw new IllegalArgumentException("param parentContext can not be null");
            }
            return new IDataXJobContext(){

                @Override
                public IJoinTaskContext getTaskContext() {
                    return parentContext;
                }

                public boolean isDisableGrpcRemoteServerConnect() {
                    return parentContext.isDisableGrpcRemoteServerConnect();
                }

                public File getSpecifiedLocalLoggerPath() {
                    return parentContext.getSpecifiedLocalLoggerPath();
                }

                public <T> void setAttr(Class<T> key, Object val) {
                    throw new UnsupportedOperationException();
                }

                public <T> T getAttr(Class<T> key) {
                    throw new UnsupportedOperationException();
                }

                public Integer getTaskId() {
                    return parentContext.getTaskId();
                }

                public String getJobName() {
                    throw new UnsupportedOperationException();
                }

                public String getDataXName() {
                    return parentContext.getIndexName();
                }

                public long getExecEpochMilli() {
                    return parentContext.getPartitionTimestampWithMillis();
                }

                @Override
                public void destroy() {
                }
            };
        }

        public IJoinTaskContext getTaskContext();

        default public int getTaskSerializeNum() {
            return order.getAndIncrement();
        }

        default public String getFormatTime(TimeFormat format) {
            return format.format(this.getTaskContext().getPartitionTimestampWithMillis());
        }

        public void destroy();
    }

    public static class TableDataXEntity
    implements DBIdentity {
        public static final String TEST_JDBC_URL = "jdbc_url_test";
        public final DBDataXChildTask fileName;
        private final ISelectedTab selectedTab;

        public String identityValue() {
            return this.fileName.getDbFactoryId();
        }

        public static TableDataXEntity createTableEntity4Test(String dataXCfgFileName, String tabName) {
            return TableDataXEntity.createTableEntity(dataXCfgFileName, TEST_JDBC_URL, tabName);
        }

        public static TableDataXEntity createTableEntity(String dataXCfgFileName, String dbIdenetity, final String tabName) {
            ISelectedTab selTab = new ISelectedTab(){

                public String getName() {
                    return tabName;
                }

                public List<IColMetaGetter> overwriteCols(IMessageHandler pluginCtx, boolean includeContextParams) {
                    throw new UnsupportedOperationException();
                }

                public List<CMeta> getCols() {
                    throw new UnsupportedOperationException();
                }
            };
            return new TableDataXEntity(new DBDataXChildTask(dbIdenetity, null, dataXCfgFileName), selTab);
        }

        public TableDataXEntity(DBDataXChildTask fileName, ISelectedTab selectedTab) {
            this.fileName = fileName;
            this.selectedTab = selectedTab;
        }

        public String getFileName() {
            return this.fileName.getDataXCfgFileNameWithSuffix();
        }

        public String getDbIdenetity() {
            return this.fileName.getDbIdenetity();
        }

        public ISelectedTab getSelectedTab() {
            return this.selectedTab;
        }

        public String getSourceTableName() {
            return this.selectedTab.getName();
        }

        public String toString() {
            return "{" + this.fileName + ", selectedTab=" + this.selectedTab.getName() + "}";
        }
    }

    public static enum InstanceType {
        DS("dolphinscheduler"){

            @Override
            public boolean validate(IControlMsgHandler controlMsgHandler, Context context, List<DataXCfgFile> cfgFileNames) {
                return true;
            }
        }
        ,
        DISTRIBUTE("distribute"){

            @Override
            public boolean validate(IControlMsgHandler controlMsgHandler, Context context, List<DataXCfgFile> cfgFileNames) {
                return true;
            }
        }
        ,
        EMBEDDED("embedded"){

            @Override
            public boolean validate(IControlMsgHandler controlMsgHandler, Context context, List<DataXCfgFile> cfgFileNames) {
                return true;
            }
        }
        ,
        LOCAL("local"){

            @Override
            public boolean validate(IControlMsgHandler controlMsgHandler, Context context, List<DataXCfgFile> cfgFileNames) {
                DataXJobSubmitParams submitParams = DataXJobSubmitParams.getDftIfEmpty();
                if (cfgFileNames.size() > submitParams.maxJobs) {
                    controlMsgHandler.addErrorMessage(context, "\u5355\u673a\u7248\uff0c\u5355\u6b21\u8868\u5bfc\u5165\u4e0d\u80fd\u8d85\u8fc7" + submitParams.maxJobs + "\u5f20\uff0c\u5982\u9700\u8981\u5bfc\u5165\u66f4\u591a\u8868\uff0c\u8bf7\u4f7f\u7528\u5206\u5e03\u5f0fK8S DataX\u6267\u884c\u671f");
                    return false;
                }
                return true;
            }
        };

        public final String literia;
        public static final String KEY_TYPE = "triggertype";

        public static InstanceType parse(String val) {
            for (InstanceType t : InstanceType.values()) {
                if (!t.literia.equals(val)) continue;
                return t;
            }
            throw new IllegalArgumentException("value:" + val + " is not illegal");
        }

        private InstanceType(String val) {
            this.literia = val;
        }

        public abstract boolean validate(IControlMsgHandler var1, Context var2, List<DataXCfgFile> var3);
    }
}

