/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.dao;

import com.qlangtech.tis.assemble.ExecResult;
import com.qlangtech.tis.assemble.TriggerType;
import com.qlangtech.tis.exec.IExecChainContext;
import com.qlangtech.tis.manage.biz.dal.dao.IApplicationDAO;
import com.qlangtech.tis.manage.common.CreateNewTaskResult;
import com.qlangtech.tis.realtime.yarn.rpc.SynResTarget;
import com.qlangtech.tis.workflow.dao.IWorkFlowBuildHistoryDAO;
import com.qlangtech.tis.workflow.dao.IWorkFlowDAO;
import com.qlangtech.tis.workflow.dao.IWorkflowDAOFacade;
import com.qlangtech.tis.workflow.pojo.WorkFlow;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistory;
import com.qlangtech.tis.workflow.pojo.WorkFlowBuildHistoryCriteria;
import com.qlangtech.tis.workflow.pojo.WorkFlowCriteria;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public interface ICommonDAOContext {
    public IApplicationDAO getApplicationDAO();

    public IWorkflowDAOFacade getWorkflowDAOFacade();

    default public WorkFlowBuildHistory getLatestSuccessWorkflowHistory(SynResTarget resTarget) {
        Objects.requireNonNull(resTarget, "param resTarget can not be null");
        WorkFlowBuildHistoryCriteria historyCriteria = new WorkFlowBuildHistoryCriteria();
        historyCriteria.setOrderByClause("id desc");
        WorkFlowBuildHistoryCriteria.Criteria criteria = historyCriteria.createCriteria().andStateEqualTo(Byte.valueOf((byte)ExecResult.SUCCESS.getValue()));
        if (resTarget.isPipeline()) {
            criteria.andAppNameEqualTo(resTarget.getName());
        } else {
            Integer workflowId = resTarget.getWorkflowId();
            if (workflowId == null) {
                WorkFlowCriteria wfCriteria = new WorkFlowCriteria();
                wfCriteria.createCriteria().andNameEqualTo(resTarget.getName());
                List workFlows = this.getWorkflowDAOFacade().getWorkFlowDAO().selectByExample(wfCriteria, 1, 1);
                boolean hasSetWfId = false;
                for (WorkFlow wf : workFlows) {
                    workflowId = wf.getId();
                    hasSetWfId = true;
                }
                if (!hasSetWfId) {
                    throw new IllegalStateException("has not set workflow Id workFlows.size:" + workFlows.size() + ",workflowName:" + resTarget.getName());
                }
            }
            criteria.andWorkFlowIdEqualTo(workflowId);
        }
        List histories = this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO().selectByExample(historyCriteria, 1, 1);
        Iterator iterator = histories.iterator();
        if (iterator.hasNext()) {
            WorkFlowBuildHistory buildHistory = (WorkFlowBuildHistory)iterator.next();
            return buildHistory;
        }
        return null;
    }

    public CreateNewTaskResult createNewDataXTask(IExecChainContext var1, TriggerType var2);

    default public IWorkFlowBuildHistoryDAO getTaskBuildHistoryDAO() {
        return this.getWorkflowDAOFacade().getWorkFlowBuildHistoryDAO();
    }

    default public IWorkFlowDAO getWorkFlowDAO() {
        return this.getWorkflowDAOFacade().getWorkFlowDAO();
    }
}

