/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import com.qlangtech.tis.solrj.util.ZkUtils;
import com.qlangtech.tis.web.start.TisSubModule;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TriggerBuildResult {
    public static final String TRIGGER_FULL_BUILD_COLLECTION_PATH = "/trigger";
    public static final String KEY_APPNAME = "appname";
    private static final String bizKey = "biz";
    public boolean success;
    public int taskid;

    public TriggerBuildResult() {
    }

    public TriggerBuildResult(boolean success) {
        this.success = success;
    }

    public static TriggerBuildResult triggerBuild(IControlMsgHandler module, Context context, List<HttpUtils.PostParam> appendParams) throws MalformedURLException {
        return TriggerBuildResult.triggerBuild(module, context, ConfigFileContext.HTTPMethod.POST, appendParams, Collections.emptyList());
    }

    public static String getAssembleNodeAddress(ITISCoordinator coordinator) {
        String incrStateCollectAddress = ZkUtils.getFirstChildValue((ITISCoordinator)coordinator, (String)"/tis/incr-transfer-group/incr-state-collect", (boolean)true);
        return "http://" + StringUtils.substringBefore((String)incrStateCollectAddress, (String)":") + ":" + TisSubModule.TIS_ASSEMBLE.getLaunchPort() + TisSubModule.TIS_ASSEMBLE.servletContext;
    }

    public static TriggerBuildResult triggerBuild(final IControlMsgHandler module, final Context context, ConfigFileContext.HTTPMethod httpMethod, List<HttpUtils.PostParam> appendParams, List<ConfigFileContext.Header> headers) throws MalformedURLException {
        String assembleNodeAddress = TriggerBuildResult.getAssembleNodeAddress(ITISCoordinator.create());
        TriggerBuildResult triggerResult = (TriggerBuildResult)HttpUtils.process((URL)new URL(assembleNodeAddress + TRIGGER_FULL_BUILD_COLLECTION_PATH), appendParams, (PostFormStreamProcess)new PostFormStreamProcess<TriggerBuildResult>(headers){

            public PostFormStreamProcess.ContentType getContentType() {
                return PostFormStreamProcess.ContentType.Application_x_www_form_urlencoded;
            }

            public TriggerBuildResult p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                TriggerBuildResult triggerResult = null;
                try {
                    JSONTokener token = new JSONTokener(stream);
                    JSONObject result = new JSONObject(token);
                    String successKey = "success";
                    if (result.isNull("success")) {
                        return new TriggerBuildResult(false);
                    }
                    triggerResult = new TriggerBuildResult(true);
                    if (!result.isNull(TriggerBuildResult.bizKey)) {
                        JSONObject o = result.getJSONObject(TriggerBuildResult.bizKey);
                        if (!o.isNull("taskid")) {
                            triggerResult.taskid = Integer.parseInt(o.getString("taskid"));
                        }
                        module.setBizResult(context, (Object)o);
                    }
                    if (result.getBoolean("success")) {
                        return triggerResult;
                    }
                    module.addErrorMessage(context, result.getString("msg"));
                    return new TriggerBuildResult(false);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, (ConfigFileContext.HTTPMethod)httpMethod);
        return triggerResult;
    }

    public int getTaskid() {
        return this.taskid;
    }
}

