/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.coredefine.module.action.IProcessMetaCreator;
import com.qlangtech.tis.datax.IDataxProcessor;
import com.qlangtech.tis.datax.StoreResourceType;
import com.qlangtech.tis.datax.impl.DataXBasicProcessMeta;
import com.qlangtech.tis.datax.impl.DataxProcessor;
import com.qlangtech.tis.datax.impl.DataxReader;
import com.qlangtech.tis.datax.impl.DataxWriter;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.manage.IAppSource;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.util.IPluginContext;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public enum ProcessModel {
    CreateWorkFlow("createWorkFlow", (pluginContext, dataxPipeName, reader, writerDesc) -> ProcessModel.getDataXBasicProcessMeta(Optional.empty(), writerDesc), () -> DataxProcessor.getPluginDescMeta("WorkflowProcessor"), StoreResourceType.DataFlow),
    CreateDatax("createDatax", (pluginContext, dataxPipeName, readerDesc, writerDesc) -> {
        DataXBasicProcessMeta processMeta = ProcessModel.getDataXBasicProcessMeta(Optional.of(readerDesc), writerDesc);
        FileUtils.write((File)IDataxProcessor.getWriterDescFile(pluginContext, dataxPipeName), (CharSequence)writerDesc.getId(), (Charset)TisUTF8.get(), (boolean)false);
        return processMeta;
    }, () -> DataxProcessor.getPluginDescMeta("DataxProcessor"), StoreResourceType.DataApp);

    private final String val;
    public final StoreResourceType resType;
    private final IProcessMetaCreator processMetaCreator;
    private final Supplier<Descriptor<IAppSource>> targetProcessDescsGetter;

    public static DataXBasicProcessMeta getDataXBasicProcessMeta(Optional<DataxReader.BaseDataxReaderDescriptor> readerDesc, DataxWriter.BaseDataxWriterDescriptor writerDesc) {
        Objects.requireNonNull(readerDesc, "readerDesc can not be null");
        Objects.requireNonNull(writerDesc, "writerDesc can not be null");
        DataXBasicProcessMeta processMeta = DataXBasicProcessMeta.getDataXBasicProcessMetaByReader(readerDesc);
        processMeta.setWriterRDBMS(writerDesc.isRdbms());
        processMeta.setWriterSupportMultiTableInReader(writerDesc.isSupportMultiTable());
        return processMeta;
    }

    public static ProcessModel parse(String val) {
        if (StringUtils.isEmpty((String)val)) {
            return CreateDatax;
        }
        for (ProcessModel m : ProcessModel.values()) {
            if (!m.val.equals(val)) continue;
            return m;
        }
        return CreateDatax;
    }

    private ProcessModel(String val, IProcessMetaCreator processMetaCreator, Supplier<Descriptor<IAppSource>> targetProcessDescsGetter, StoreResourceType resType) {
        this.val = val;
        this.processMetaCreator = processMetaCreator;
        this.targetProcessDescsGetter = targetProcessDescsGetter;
        this.resType = resType;
    }

    public DataXBasicProcessMeta createProcessMeta(IPluginContext pluginContext, String dataXName, JSONObject reader, JSONObject writer) throws Exception {
        return this.processMetaCreator.createProcessMeta(pluginContext, dataXName, reader, writer);
    }

    public DataXBasicProcessMeta createProcessMeta(IPluginContext pluginContext, String dataXName, DataxReader.BaseDataxReaderDescriptor reader, DataxWriter.BaseDataxWriterDescriptor writer) throws Exception {
        return this.processMetaCreator.createProcessMeta(pluginContext, dataXName, reader, writer);
    }

    public Descriptor<IAppSource> getPluginDescMeta() {
        return this.targetProcessDescsGetter.get();
    }

    public DataxWriter loadWriter(IPluginContext pluginContext, JSONObject writerDesc, String name) {
        IDataxProcessor processor = (IDataxProcessor)((Object)this.loadDataXProcessor(pluginContext, name));
        DataxWriter writer = (DataxWriter)processor.getWriter(pluginContext, false);
        String requestDescId = writerDesc.getString("impl");
        if (this == CreateDatax && writer != null && StringUtils.equals((String)writer.getDescriptor().getId(), (String)requestDescId)) {
            DataxReader readerPlugin = DataxReader.load(pluginContext, name);
            DataxWriter.BaseDataxWriterDescriptor writerDescriptor = (DataxWriter.BaseDataxWriterDescriptor)writer.getDescriptor();
            if (!writerDescriptor.isSupportMultiTable() && readerPlugin.getSelectedTabs().size() > 1) {
                throw new IllegalStateException("status is not allowed:!writerDescriptor.isSupportMultiTable() && readerPlugin.hasMulitTable()");
            }
            return writer;
        }
        return writer;
    }

    public Optional<DataxReader> getDataXReader(IPluginContext pluginContext, String name) {
        IDataxProcessor processor = (IDataxProcessor)((Object)this.loadDataXProcessor(pluginContext, name));
        if (this == CreateDatax) {
            return Optional.of((DataxReader)processor.getReader(pluginContext));
        }
        if (this == CreateWorkFlow) {
            return Optional.empty();
        }
        throw new IllegalStateException("illegal process model:" + this);
    }

    public IAppSource loadDataXProcessor(IPluginContext pluginContext, String name) {
        return (IAppSource)((Object)DataxProcessor.load(pluginContext, this.resType, name));
    }
}

