/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.kerberos;

import com.alibaba.citrus.turbine.Context;
import com.qlangtech.tis.TIS;
import com.qlangtech.tis.extension.Describable;
import com.qlangtech.tis.extension.Descriptor;
import com.qlangtech.tis.plugin.IdentityName;
import com.qlangtech.tis.plugin.InnerPropOfIdentityName;
import com.qlangtech.tis.realtime.utils.NetUtils;
import com.qlangtech.tis.runtime.module.misc.IControlMsgHandler;
import java.io.File;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.krb5.Config;

public abstract class Krb5Res
implements Describable<Krb5Res>,
InnerPropOfIdentityName {
    protected transient IdentityName parentPluginId;

    public abstract File getKrb5Path();

    public abstract boolean isKrb5PathNotNull();

    public void setIdentity(IdentityName id) {
        this.parentPluginId = id;
    }

    @Override
    public final Descriptor<Krb5Res> getDescriptor() {
        Descriptor descriptor = TIS.get().getDescriptor(this.getClass());
        if (!(descriptor instanceof BaseDescriptor)) {
            throw new IllegalStateException("descriptor class:" + descriptor.getClass().getName() + " must be type of " + BaseDescriptor.class.getName());
        }
        return descriptor;
    }

    public static abstract class BaseDescriptor
    extends Descriptor<Krb5Res> {
        static final String KEY_KRB5_CONFIG = "java.security.krb5.conf";
        private static final Logger logger = LoggerFactory.getLogger(BaseDescriptor.class);

        protected abstract String getResPropFieldName();

        @Override
        protected boolean validateAll(IControlMsgHandler msgHandler, Context context, Descriptor.PostFormVals postFormVals) {
            Krb5Res krb5Res = (Krb5Res)postFormVals.newInstance();
            if (krb5Res.isKrb5PathNotNull()) {
                File krb5Path = krb5Res.getKrb5Path();
                if (!krb5Path.exists()) {
                    msgHandler.addFieldError(context, this.getResPropFieldName(), NetUtils.getHost() + "\u8282\u70b9\u4e2d\uff0c\u6587\u4ef6\u6587\u4ef6\uff1a" + krb5Path.getAbsolutePath() + "\u4e0d\u5b58\u5728\u8be5\u8def\u5f84", new Object[0]);
                    return false;
                }
                if (!BaseDescriptor.krb5ConfigTmpSession(krb5Res, () -> {
                    Config.refresh();
                    return true;
                }, e -> msgHandler.addFieldError(context, this.getResPropFieldName(), e.getMessage(), new Object[0])).booleanValue()) {
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T> T krb5ConfigTmpSession(Krb5Res krb5Res, Krb5Provider<T> process, Consumer<Exception> ... errProcs) {
            String krb5Config = System.getProperty(KEY_KRB5_CONFIG);
            File krb5Path = krb5Res.getKrb5Path();
            if (!krb5Path.exists()) {
                throw new IllegalStateException("krb5Path is not exist:" + krb5Path.getAbsolutePath());
            }
            try {
                System.setProperty(KEY_KRB5_CONFIG, krb5Path.getAbsolutePath());
                T t = process.run();
                return t;
            }
            catch (Exception e) {
                Consumer<Exception>[] consumerArray;
                logger.warn(e.getMessage(), (Throwable)e);
                try {
                    consumerArray = errProcs;
                    int n = consumerArray.length;
                    int n2 = 0;
                    if (n2 < n) {
                        Consumer<Exception> errProcess = consumerArray[n2];
                        errProcess.accept(e);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                consumerArray = null;
                return (T)consumerArray;
            }
            finally {
                if (StringUtils.isNotBlank((String)krb5Config)) {
                    System.setProperty(KEY_KRB5_CONFIG, krb5Config);
                } else {
                    System.clearProperty(KEY_KRB5_CONFIG);
                }
            }
        }

        @FunctionalInterface
        public static interface Krb5Provider<T> {
            public T run() throws Exception;
        }
    }
}

